/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.markdown;

import org.sonar.channel.Channel;
import org.sonar.channel.CodeReader;
import org.sonar.channel.RegexChannel;
import org.sonar.markdown.MarkdownOutput;

class HtmlBlockquoteChannel
extends Channel<MarkdownOutput> {
    private QuotedLineElementChannel quotedLineElement = new QuotedLineElementChannel();
    private EndOfLine endOfLine = new EndOfLine();
    private boolean pendingBlockConstruction;

    HtmlBlockquoteChannel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean consume(CodeReader code, MarkdownOutput output) {
        try {
            if (code.getColumnPosition() == 0 && this.quotedLineElement.consume(code, output)) {
                while (this.endOfLine.consume(code, output) && this.quotedLineElement.consume(code, output)) {
                }
                output.append("</blockquote>");
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pendingBlockConstruction = false;
        }
    }

    private static final class EndOfLine
    extends RegexChannel<MarkdownOutput> {
        public EndOfLine() {
            super("(\r?\n)|(\r)");
        }

        public void consume(CharSequence token, MarkdownOutput output) {
            output.append(token);
        }
    }

    private class QuotedLineElementChannel
    extends RegexChannel<MarkdownOutput> {
        private QuotedLineElementChannel() {
            super("&gt;\\s[^\r\n]*+");
        }

        public void consume(CharSequence token, MarkdownOutput output) {
            if (!HtmlBlockquoteChannel.this.pendingBlockConstruction) {
                output.append("<blockquote>");
                HtmlBlockquoteChannel.this.pendingBlockConstruction = true;
            }
            output.append(token.subSequence(this.searchIndexOfFirstCharacter(token), token.length()));
            output.append("<br/>");
        }

        private int searchIndexOfFirstCharacter(CharSequence token) {
            for (int index = 0; index < token.length(); ++index) {
                if (token.charAt(index) != '&') continue;
                index += 4;
                while (index < token.length()) {
                    if (token.charAt(++index) == ' ') continue;
                    return index;
                }
            }
            return token.length() - 1;
        }
    }
}

