(window.webpackJsonp=window.webpackJsonp||[]).push([[383],{1228:function(e){e.exports={owaspTop10:{a1:{title:"Injection",description:"Injection flaws, such as SQL, NoSQL, OS, and LDAP injection, occur when untrusted data is sent to an interpreter as part of a command or query. The attacker's hostile data can trick the interpreter into executing unintended commands or accessing data without proper authorization."},a2:{title:"Broken Authentication",description:"Application functions related to authentication and session management are often implemented incorrectly, allowing attackers to compromise passwords, keys, or session tokens, or to exploit other implementation flaws to assume other users' identities temporarily or permanently."},a3:{title:"Sensitive Data Exposure",description:"Many web applications and APIs do not properly protect sensitive data, such as financial, healthcare, and PII. Attackers may steal or modify such weakly protected data to conduct credit card fraud, identity theft, or other crimes. Sensitive data may be compromised without extra protection, such as encryption at rest or in transit, and requires special precautions when exchanged with the browser."},a4:{title:"XML External Entities (XXE)",description:"Many older or poorly configured XML processors evaluate external entity references within XML documents. External entities can be used to disclose internal files using the file URI handler, internal file shares, internal port scanning, remote code execution, and denial of service attacks."},a5:{title:"Broken Access Control",description:"Restrictions on what authenticated users are allowed to do are often not properly enforced. Attackers can exploit these flaws to access unauthorized functionality and/or data, such as access other users' accounts, view sensitive files, modify other users' data, change access rights, etc."},a6:{title:"Security Misconfiguration",description:"Security misconfiguration is the most commonly seen issue. This is commonly a result of insecure default configurations, incomplete or ad hoc configurations, open cloud storage, misconfigured HTTP headers, and verbose error messages containing sensitive information. Not only must all operating systems, frameworks, libraries, and applications be securely configured, but they must be patched and upgraded in a timely fashion."},a7:{title:"Cross-Site Scripting (XSS)",description:"XSS flaws occur whenever an application includes untrusted data in a new web page without proper validation or escaping, or updates an existing web page with user-supplied data using a browser API that can create HTML or JavaScript. XSS allows attackers to execute scripts in the victim's browser which can hijack user sessions, deface web sites, or redirect the user to malicious sites."},a8:{title:"Insecure Deserialization",description:"Insecure deserialization often leads to remote code execution. Even if deserialization flaws do not result in remote code execution, they can be used to perform attacks, including replay attacks, injection attacks, and privilege escalation attacks."},a9:{title:"Using Components with Known Vulnerabilities",description:"Components, such as libraries, frameworks, and other software modules, run with the same privileges as the application. If a vulnerable component is exploited, such an attack can facilitate serious data loss or server takeover. Applications and APIs using components with known vulnerabilities may undermine application defenses and enable various attacks and impacts."},a10:{title:"Insufficient Logging & Monitoring",description:"Insufficient logging and monitoring, coupled with missing or ineffective integration with incident response, allows attackers to further attack systems, maintain persistence, pivot to more systems, and tamper, extract, or destroy data. Most breach studies show time to detect a breach is over 200 days, typically detected by external parties rather than internal processes or monitoring."}},sansTop25:{"insecure-interaction":{title:"Insecure Interaction Between Components",description:"These weaknesses are related to insecure ways in which data is sent and received between separate components, modules, programs, processes, threads, or systems."},"risky-resource":{title:"Risky Resource Management",description:"The weaknesses in this category are related to ways in which software does not properly manage the creation, usage, transfer, or destruction of important system resources."},"porous-defenses":{title:"Porous Defenses",description:"The weaknesses in this category are related to defensive techniques that are often misused, abused, or just plain ignored."}},cwe:{5:{title:"J2EE Misconfiguration: Data Transmission Without Encryption",description:"Information sent over a network can be compromised while in transit. An attacker may be able to read or modify the contents if the data are sent in plaintext or are weakly encrypted."},6:{title:"J2EE Misconfiguration: Insufficient Session-ID Length",description:"The J2EE application is configured to use an insufficient session ID length."},7:{title:"J2EE Misconfiguration: Missing Custom Error Page",description:"The default error page of a web application should not display sensitive information about the software system."},8:{title:"J2EE Misconfiguration: Entity Bean Declared Remote",description:"When an application exposes a remote interface for an entity bean, it might also expose methods that get or set the bean's data. These methods could be leveraged to read sensitive information, or to change data in ways that violate the application's expectations, potentially leading to other vulnerabilities."},9:{title:"J2EE Misconfiguration: Weak Access Permissions for EJB Methods",description:"If elevated access rights are assigned to EJB methods, then an attacker can take advantage of the permissions to exploit the software system."},11:{title:"ASP.NET Misconfiguration: Creating Debug Binary",description:"Debugging messages help attackers learn about the system and plan a form of attack."},12:{title:"ASP.NET Misconfiguration: Missing Custom Error Page",description:"An ASP .NET application must enable custom error pages in order to prevent attackers from mining information from the framework's built-in responses."},13:{title:"ASP.NET Misconfiguration: Password in Configuration File",description:"Storing a plaintext password in a configuration file allows anyone who can read the file access to the password-protected resource making them an easy target for attackers."},14:{title:"Compiler Removal of Code to Clear Buffers",description:"Sensitive memory is cleared according to the source code, but compiler optimizations leave the memory untouched when it is not read from again, aka dead store removal."},15:{title:"External Control of System or Configuration Setting",description:"One or more system settings or configuration elements can be externally controlled by a user."},20:{title:"Improper Input Validation",description:"The product does not validate or incorrectly validates input that can affect the control flow or data flow of a program."},22:{title:"Improper Limitation of a Pathname to a Restricted Directory ('Path Traversal')",description:"The software uses external input to construct a pathname that is intended to identify a file or directory that is located underneath a restricted parent directory, but the software does not properly neutralize special elements within the pathname that can cause the pathname to resolve to a location that is outside of the restricted directory."},23:{title:"Relative Path Traversal",description:"The software uses external input to construct a pathname that should be within a restricted directory, but it does not properly neutralize sequences such as .. that can resolve to a location that is outside of that directory."},24:{title:"Path Traversal: '../filedir'",description:"The software uses external input to construct a pathname that should be within a restricted directory, but it does not properly neutralize ../ sequences that can resolve to a location that is outside of that directory."},25:{title:"Path Traversal: '/../filedir'",description:"The software uses external input to construct a pathname that should be within a restricted directory, but it does not properly neutralize /../ sequences that can resolve to a location that is outside of that directory."},26:{title:"Path Traversal: '/dir/../filename'",description:"The software uses external input to construct a pathname that should be within a restricted directory, but it does not properly neutralize /dir/../filename sequences that can resolve to a location that is outside of that directory."},27:{title:"Path Traversal: 'dir/../../filename'",description:"The software uses external input to construct a pathname that should be within a restricted directory, but it does not properly neutralize multiple internal ../ sequences that can resolve to a location that is outside of that directory."},28:{title:"Path Traversal: '..filedir'",description:"The software uses external input to construct a pathname that should be within a restricted directory, but it does not properly neutralize .. sequences that can resolve to a location that is outside of that directory."},29:{title:"Path Traversal: '..filename'",description:"The software uses external input to construct a pathname that should be within a restricted directory, but it does not properly neutralize '..filename' (leading backslash dot dot) sequences that can resolve to a location that is outside of that directory."},30:{title:"Path Traversal: 'dir..filename'",description:"The software uses external input to construct a pathname that should be within a restricted directory, but it does not properly neutralize 'dir..filename' (leading backslash dot dot) sequences that can resolve to a location that is outside of that directory."},31:{title:"Path Traversal: 'dir....filename'",description:"The software uses external input to construct a pathname that should be within a restricted directory, but it does not properly neutralize 'dir....filename' (multiple internal backslash dot dot) sequences that can resolve to a location that is outside of that directory."},32:{title:"Path Traversal: '...' (Triple Dot)",description:"The software uses external input to construct a pathname that should be within a restricted directory, but it does not properly neutralize '...' (triple dot) sequences that can resolve to a location that is outside of that directory."},33:{title:"Path Traversal: '....' (Multiple Dot)",description:"The software uses external input to construct a pathname that should be within a restricted directory, but it does not properly neutralize '....' (multiple dot) sequences that can resolve to a location that is outside of that directory."},34:{title:"Path Traversal: '....//'",description:"The software uses external input to construct a pathname that should be within a restricted directory, but it does not properly neutralize '....//' (doubled dot dot slash) sequences that can resolve to a location that is outside of that directory."},35:{title:"Path Traversal: '.../...//'",description:"The software uses external input to construct a pathname that should be within a restricted directory, but it does not properly neutralize '.../...//' (doubled triple dot slash) sequences that can resolve to a location that is outside of that directory."},36:{title:"Absolute Path Traversal",description:"The software uses external input to construct a pathname that should be within a restricted directory, but it does not properly neutralize absolute path sequences such as /abs/path that can resolve to a location that is outside of that directory."},37:{title:"Path Traversal: '/absolute/pathname/here'",description:"A software system that accepts input in the form of a slash absolute path ('/absolute/pathname/here') without appropriate validation can allow an attacker to traverse the file system to unintended locations or access arbitrary files."},38:{title:"Path Traversal: 'absolutepathnamehere'",description:"A software system that accepts input in the form of a backslash absolute path ('absolutepathnamehere') without appropriate validation can allow an attacker to traverse the file system to unintended locations or access arbitrary files."},39:{title:"Path Traversal: 'C:dirname'",description:"An attacker can inject a drive letter or Windows volume letter ('C:dirname') into a software system to potentially redirect access to an unintended location or arbitrary file."},40:{title:"Path Traversal: 'UNCsharename' (Windows UNC Share)",description:"An attacker can inject a Windows UNC share ('UNCsharename') into a software system to potentially redirect access to an unintended location or arbitrary file."},41:{title:"Improper Resolution of Path Equivalence",description:"The system or application is vulnerable to file system contents disclosure through path equivalence. Path equivalence involves the use of special characters in file and directory names. The associated manipulations are intended to generate multiple names for the same object."},42:{title:"Path Equivalence: 'filename.' (Trailing Dot)",description:"A software system that accepts path input in the form of trailing dot ('filedir.') without appropriate validation can lead to ambiguous path resolution and allow an attacker to traverse the file system to unintended locations or access arbitrary files."},43:{title:"Path Equivalence: 'filename....' (Multiple Trailing Dot)",description:"A software system that accepts path input in the form of multiple trailing dot ('filedir....') without appropriate validation can lead to ambiguous path resolution and allow an attacker to traverse the file system to unintended locations or access arbitrary files."},44:{title:"Path Equivalence: 'file.name' (Internal Dot)",description:"A software system that accepts path input in the form of internal dot ('file.ordir') without appropriate validation can lead to ambiguous path resolution and allow an attacker to traverse the file system to unintended locations or access arbitrary files."},45:{title:"Path Equivalence: 'file...name' (Multiple Internal Dot)",description:"A software system that accepts path input in the form of multiple internal dot ('file...dir') without appropriate validation can lead to ambiguous path resolution and allow an attacker to traverse the file system to unintended locations or access arbitrary files."},46:{title:"Path Equivalence: 'filename ' (Trailing Space)",description:"A software system that accepts path input in the form of trailing space ('filedir ') without appropriate validation can lead to ambiguous path resolution and allow an attacker to traverse the file system to unintended locations or access arbitrary files."},47:{title:"Path Equivalence: ' filename' (Leading Space)",description:"A software system that accepts path input in the form of leading space (' filedir') without appropriate validation can lead to ambiguous path resolution and allow an attacker to traverse the file system to unintended locations or access arbitrary files."},48:{title:"Path Equivalence: 'file name' (Internal Whitespace)",description:"A software system that accepts path input in the form of internal space ('file(SPACE)name') without appropriate validation can lead to ambiguous path resolution and allow an attacker to traverse the file system to unintended locations or access arbitrary files."},49:{title:"Path Equivalence: 'filename/' (Trailing Slash)",description:"A software system that accepts path input in the form of trailing slash ('filedir/') without appropriate validation can lead to ambiguous path resolution and allow an attacker to traverse the file system to unintended locations or access arbitrary files."},50:{title:"Path Equivalence: '//multiple/leading/slash'",description:"A software system that accepts path input in the form of multiple leading slash ('//multiple/leading/slash') without appropriate validation can lead to ambiguous path resolution and allow an attacker to traverse the file system to unintended locations or access arbitrary files."},51:{title:"Path Equivalence: '/multiple//internal/slash'",description:"A software system that accepts path input in the form of multiple internal slash ('/multiple//internal/slash/') without appropriate validation can lead to ambiguous path resolution and allow an attacker to traverse the file system to unintended locations or access arbitrary files."},52:{title:"Path Equivalence: '/multiple/trailing/slash//'",description:"A software system that accepts path input in the form of multiple trailing slash ('/multiple/trailing/slash//') without appropriate validation can lead to ambiguous path resolution and allow an attacker to traverse the file system to unintended locations or access arbitrary files."},53:{title:"Path Equivalence: 'multipleinternalbackslash'",description:"A software system that accepts path input in the form of multiple internal backslash ('multipletrailingslash') without appropriate validation can lead to ambiguous path resolution and allow an attacker to traverse the file system to unintended locations or access arbitrary files."},54:{title:"Path Equivalence: 'filedir' (Trailing Backslash)",description:"A software system that accepts path input in the form of trailing backslash ('filedir') without appropriate validation can lead to ambiguous path resolution and allow an attacker to traverse the file system to unintended locations or access arbitrary files."},55:{title:"Path Equivalence: '/./' (Single Dot Directory)",description:"A software system that accepts path input in the form of single dot directory exploit ('/./') without appropriate validation can lead to ambiguous path resolution and allow an attacker to traverse the file system to unintended locations or access arbitrary files."},56:{title:"Path Equivalence: 'filedir*' (Wildcard)",description:"A software system that accepts path input in the form of asterisk wildcard ('filedir*') without appropriate validation can lead to ambiguous path resolution and allow an attacker to traverse the file system to unintended locations or access arbitrary files."},57:{title:"Path Equivalence: 'fakedir/../realdir/filename'",description:"The software contains protection mechanisms to restrict access to 'realdir/filename', but it constructs pathnames using external input in the form of 'fakedir/../realdir/filename' that are not handled by those mechanisms. This allows attackers to perform unauthorized actions against the targeted file."},58:{title:"Path Equivalence: Windows 8.3 Filename",description:"The software contains a protection mechanism that restricts access to a long filename on a Windows operating system, but the software does not properly restrict access to the equivalent short 8.3 filename."},59:{title:"Improper Link Resolution Before File Access ('Link Following')",description:"The software attempts to access a file based on the filename, but it does not properly prevent that filename from identifying a link or shortcut that resolves to an unintended resource."},61:{title:"UNIX Symbolic Link (Symlink) Following",description:"The software, when opening a file or directory, does not sufficiently account for when the file is a symbolic link that resolves to a target outside of the intended control sphere. This could allow an attacker to cause the software to operate on unauthorized files."},62:{title:"UNIX Hard Link",description:"The software, when opening a file or directory, does not sufficiently account for when the name is associated with a hard link to a target that is outside of the intended control sphere. This could allow an attacker to cause the software to operate on unauthorized files."},64:{title:"Windows Shortcut Following (.LNK)",description:"The software, when opening a file or directory, does not sufficiently handle when the file is a Windows shortcut (.LNK) whose target is outside of the intended control sphere. This could allow an attacker to cause the software to operate on unauthorized files."},65:{title:"Windows Hard Link",description:"The software, when opening a file or directory, does not sufficiently handle when the name is associated with a hard link to a target that is outside of the intended control sphere. This could allow an attacker to cause the software to operate on unauthorized files."},66:{title:"Improper Handling of File Names that Identify Virtual Resources",description:"The product does not handle or incorrectly handles a file name that identifies a virtual resource that is not directly specified within the directory that is associated with the file name, causing the product to perform file-based operations on a resource that is not a file."},67:{title:"Improper Handling of Windows Device Names",description:"The software constructs pathnames from user input, but it does not handle or incorrectly handles a pathname containing a Windows device name such as AUX or CON. This typically leads to denial of service or an information exposure when the application attempts to process the pathname as a regular file."},69:{title:"Improper Handling of Windows ::DATA Alternate Data Stream",description:"The software does not properly prevent access to, or detect usage of, alternate data streams (ADS)."},72:{title:"Improper Handling of Apple HFS+ Alternate Data Stream Path",description:"The software does not properly handle special paths that may identify the data or resource fork of a file on the HFS+ file system."},73:{title:"External Control of File Name or Path",description:"The software allows user input to control or influence paths or file names that are used in filesystem operations."},74:{title:"Improper Neutralization of Special Elements in Output Used by a Downstream Component ('Injection')",description:"The software constructs all or part of a command, data structure, or record using externally-influenced input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could modify how it is parsed or interpreted when it is sent to a downstream component."},75:{title:"Failure to Sanitize Special Elements into a Different Plane (Special Element Injection)",description:"The software does not adequately filter user-controlled input for special elements with control implications."},76:{title:"Improper Neutralization of Equivalent Special Elements",description:"The software properly neutralizes certain special elements, but it improperly neutralizes equivalent special elements."},77:{title:"Improper Neutralization of Special Elements used in a Command ('Command Injection')",description:"The software constructs all or part of a command using externally-influenced input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could modify the intended command when it is sent to a downstream component."},78:{title:"Improper Neutralization of Special Elements used in an OS Command ('OS Command Injection')",description:"The software constructs all or part of an OS command using externally-influenced input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could modify the intended OS command when it is sent to a downstream component."},79:{title:"Improper Neutralization of Input During Web Page Generation ('Cross-site Scripting')",description:"The software does not neutralize or incorrectly neutralizes user-controllable input before it is placed in output that is used as a web page that is served to other users."},80:{title:"Improper Neutralization of Script-Related HTML Tags in a Web Page (Basic XSS)",description:"The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special characters such as <, >, and & that could be interpreted as web-scripting elements when they are sent to a downstream component that processes web pages."},81:{title:"Improper Neutralization of Script in an Error Message Web Page",description:"The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special characters that could be interpreted as web-scripting elements when they are sent to an error page."},82:{title:"Improper Neutralization of Script in Attributes of IMG Tags in a Web Page",description:"The web application does not neutralize or incorrectly neutralizes scripting elements within attributes of HTML IMG tags, such as the src attribute."},83:{title:"Improper Neutralization of Script in Attributes in a Web Page",description:"The software does not neutralize or incorrectly neutralizes javascript: or other URIs from dangerous attributes within tags, such as onmouseover, onload, onerror, or style."},84:{title:"Improper Neutralization of Encoded URI Schemes in a Web Page",description:"The web application improperly neutralizes user-controlled input for executable script disguised with URI encodings."},85:{title:"Doubled Character XSS Manipulations",description:"The web application does not filter user-controlled input for executable script disguised using doubling of the involved characters."},86:{title:"Improper Neutralization of Invalid Characters in Identifiers in Web Pages",description:"The software does not neutralize or incorrectly neutralizes invalid characters or byte sequences in the middle of tag names, URI schemes, and other identifiers."},87:{title:"Improper Neutralization of Alternate XSS Syntax",description:"The software does not neutralize or incorrectly neutralizes user-controlled input for alternate script syntax."},88:{title:"Argument Injection or Modification",description:"The software does not sufficiently delimit the arguments being passed to a component in another control sphere, allowing alternate arguments to be provided, leading to potentially security-relevant changes."},89:{title:"Improper Neutralization of Special Elements used in an SQL Command ('SQL Injection')",description:"The software constructs all or part of an SQL command using externally-influenced input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could modify the intended SQL command when it is sent to a downstream component."},90:{title:"Improper Neutralization of Special Elements used in an LDAP Query ('LDAP Injection')",description:"The software constructs all or part of an LDAP query using externally-influenced input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could modify the intended LDAP query when it is sent to a downstream component."},91:{title:"XML Injection (aka Blind XPath Injection)",description:"The software does not properly neutralize special elements that are used in XML, allowing attackers to modify the syntax, content, or commands of the XML before it is processed by an end system."},93:{title:"Improper Neutralization of CRLF Sequences ('CRLF Injection')",description:"The software uses CRLF (carriage return line feeds) as a special element, e.g. to separate lines or records, but it does not neutralize or incorrectly neutralizes CRLF sequences from inputs."},94:{title:"Improper Control of Generation of Code ('Code Injection')",description:"The software constructs all or part of a code segment using externally-influenced input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could modify the syntax or behavior of the intended code segment."},95:{title:"Improper Neutralization of Directives in Dynamically Evaluated Code ('Eval Injection')",description:"The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes code syntax before using the input in a dynamic evaluation call (e.g. eval)."},96:{title:"Improper Neutralization of Directives in Statically Saved Code ('Static Code Injection')",description:"The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes code syntax before inserting the input into an executable resource, such as a library, configuration file, or template."},97:{title:"Improper Neutralization of Server-Side Includes (SSI) Within a Web Page",description:"The software generates a web page, but does not neutralize or incorrectly neutralizes user-controllable input that could be interpreted as a server-side include (SSI) directive."},98:{title:"Improper Control of Filename for Include/Require Statement in PHP Program ('PHP Remote File Inclusion')",description:"The PHP application receives input from an upstream component, but it does not restrict or incorrectly restricts the input before its usage in require, include, or similar functions."},99:{title:"Improper Control of Resource Identifiers ('Resource Injection')",description:"The software receives input from an upstream component, but it does not restrict or incorrectly restricts the input before it is used as an identifier for a resource that may be outside the intended sphere of control."},102:{title:"Struts: Duplicate Validation Forms",description:"The application uses multiple validation forms with the same name, which might cause the Struts Validator to validate a form that the programmer does not expect."},103:{title:"Struts: Incomplete validate() Method Definition",description:"The application has a validator form that either does not define a validate() method, or defines a validate() method but does not call super.validate()."},104:{title:"Struts: Form Bean Does Not Extend Validation Class",description:"If a form bean does not extend an ActionForm subclass of the Validator framework, it can expose the application to other weaknesses related to insufficient input validation."},105:{title:"Struts: Form Field Without Validator",description:"The application has a form field that is not validated by a corresponding validation form, which can introduce other weaknesses related to insufficient input validation."},106:{title:"Struts: Plug-in Framework not in Use",description:"When an application does not use an input validation framework such as the Struts Validator, there is a greater risk of introducing weaknesses related to insufficient input validation."},107:{title:"Struts: Unused Validation Form",description:"An unused validation form indicates that validation logic is not up-to-date."},108:{title:"Struts: Unvalidated Action Form",description:"Every Action Form must have a corresponding validation form."},109:{title:"Struts: Validator Turned Off",description:"Automatic filtering via a Struts bean has been turned off, which disables the Struts Validator and custom validation logic. This exposes the application to other weaknesses related to insufficient input validation."},110:{title:"Struts: Validator Without Form Field",description:"Validation fields that do not appear in forms they are associated with indicate that the validation logic is out of date."},111:{title:"Direct Use of Unsafe JNI",description:"When a Java application uses the Java Native Interface (JNI) to call code written in another programming language, it can expose the application to weaknesses in that code, even if those weaknesses cannot occur in Java."},112:{title:"Missing XML Validation",description:"The software accepts XML from an untrusted source but does not validate the XML against the proper schema."},113:{title:"Improper Neutralization of CRLF Sequences in HTTP Headers ('HTTP Response Splitting')",description:"The software receives data from an upstream component, but does not neutralize or incorrectly neutralizes CR and LF characters before the data is included in outgoing HTTP headers."},114:{title:"Process Control",description:"Executing commands or loading libraries from an untrusted source or in an untrusted environment can cause an application to execute malicious commands (and payloads) on behalf of an attacker."},115:{title:"Misinterpretation of Input",description:"The software misinterprets an input, whether from an attacker or another product, in a security-relevant fashion."},116:{title:"Improper Encoding or Escaping of Output",description:"The software prepares a structured message for communication with another component, but encoding or escaping of the data is either missing or done incorrectly. As a result, the intended structure of the message is not preserved."},117:{title:"Improper Output Neutralization for Logs",description:"The software does not neutralize or incorrectly neutralizes output that is written to logs."},118:{title:"Incorrect Access of Indexable Resource ('Range Error')",description:"The software does not restrict or incorrectly restricts operations within the boundaries of a resource that is accessed using an index or pointer, such as memory or files."},119:{title:"Improper Restriction of Operations within the Bounds of a Memory Buffer",description:"The software performs operations on a memory buffer, but it can read from or write to a memory location that is outside of the intended boundary of the buffer."},120:{title:"Buffer Copy without Checking Size of Input ('Classic Buffer Overflow')",description:"The program copies an input buffer to an output buffer without verifying that the size of the input buffer is less than the size of the output buffer, leading to a buffer overflow."},121:{title:"Stack-based Buffer Overflow",description:"A stack-based buffer overflow condition is a condition where the buffer being overwritten is allocated on the stack (i.e., is a local variable or, rarely, a parameter to a function)."},122:{title:"Heap-based Buffer Overflow",description:"A heap overflow condition is a buffer overflow, where the buffer that can be overwritten is allocated in the heap portion of memory, generally meaning that the buffer was allocated using a routine such as malloc()."},123:{title:"Write-what-where Condition",description:"Any condition where the attacker has the ability to write an arbitrary value to an arbitrary location, often as the result of a buffer overflow."},124:{title:"Buffer Underwrite ('Buffer Underflow')",description:"The software writes to a buffer using an index or pointer that references a memory location prior to the beginning of the buffer."},125:{title:"Out-of-bounds Read",description:"The software reads data past the end, or before the beginning, of the intended buffer."},126:{title:"Buffer Over-read",description:"The software reads from a buffer using buffer access mechanisms such as indexes or pointers that reference memory locations after the targeted buffer."},127:{title:"Buffer Under-read",description:"The software reads from a buffer using buffer access mechanisms such as indexes or pointers that reference memory locations prior to the targeted buffer."},128:{title:"Wrap-around Error",description:"Wrap around errors occur whenever a value is incremented past the maximum value for its type and therefore wraps around to a very small, negative, or undefined value."},129:{title:"Improper Validation of Array Index",description:"The product uses untrusted input when calculating or using an array index, but the product does not validate or incorrectly validates the index to ensure the index references a valid position within the array."},130:{title:"Improper Handling of Length Parameter Inconsistency ",description:"The software parses a formatted message or structure, but it does not handle or incorrectly handles a length field that is inconsistent with the actual length of the associated data."},131:{title:"Incorrect Calculation of Buffer Size",description:"The software does not correctly calculate the size to be used when allocating a buffer, which could lead to a buffer overflow."},134:{title:"Use of Externally-Controlled Format String",description:"The software uses a function that accepts a format string as an argument, but the format string originates from an external source."},135:{title:"Incorrect Calculation of Multi-Byte String Length",description:"The software does not correctly calculate the length of strings that can contain wide or multi-byte characters."},138:{title:"Improper Neutralization of Special Elements",description:"The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could be interpreted as control elements or syntactic markers when they are sent to a downstream component."},140:{title:"Improper Neutralization of Delimiters",description:"The software does not neutralize or incorrectly neutralizes delimiters."},141:{title:"Improper Neutralization of Parameter/Argument Delimiters",description:"The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could be interpreted as parameter or argument delimiters when they are sent to a downstream component."},142:{title:"Improper Neutralization of Value Delimiters",description:"The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could be interpreted as value delimiters when they are sent to a downstream component."},143:{title:"Improper Neutralization of Record Delimiters",description:"The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could be interpreted as record delimiters when they are sent to a downstream component."},144:{title:"Improper Neutralization of Line Delimiters",description:"The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could be interpreted as line delimiters when they are sent to a downstream component."},145:{title:"Improper Neutralization of Section Delimiters",description:"The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could be interpreted as section delimiters when they are sent to a downstream component."},146:{title:"Improper Neutralization of Expression/Command Delimiters",description:"The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could be interpreted as expression or command delimiters when they are sent to a downstream component."},147:{title:"Improper Neutralization of Input Terminators",description:"The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could be interpreted as input terminators when they are sent to a downstream component."},148:{title:"Improper Neutralization of Input Leaders",description:"The application does not properly handle when a leading character or sequence (leader) is missing or malformed, or if multiple leaders are used when only one should be allowed."},149:{title:"Improper Neutralization of Quoting Syntax",description:"Quotes injected into an application can be used to compromise a system. As data are parsed, an injected/absent/duplicate/malformed use of quotes may cause the process to take unexpected actions."},150:{title:"Improper Neutralization of Escape, Meta, or Control Sequences",description:"The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could be interpreted as escape, meta, or control character sequences when they are sent to a downstream component."},151:{title:"Improper Neutralization of Comment Delimiters",description:"The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could be interpreted as comment delimiters when they are sent to a downstream component."},152:{title:"Improper Neutralization of Macro Symbols",description:"The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could be interpreted as macro symbols when they are sent to a downstream component."},153:{title:"Improper Neutralization of Substitution Characters",description:"The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could be interpreted as substitution characters when they are sent to a downstream component."},154:{title:"Improper Neutralization of Variable Name Delimiters",description:"The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could be interpreted as variable name delimiters when they are sent to a downstream component."},155:{title:"Improper Neutralization of Wildcards or Matching Symbols",description:"The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could be interpreted as wildcards or matching symbols when they are sent to a downstream component."},156:{title:"Improper Neutralization of Whitespace",description:"The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could be interpreted as whitespace when they are sent to a downstream component."},157:{title:"Failure to Sanitize Paired Delimiters",description:"The software does not properly handle the characters that are used to mark the beginning and ending of a group of entities, such as parentheses, brackets, and braces."},158:{title:"Improper Neutralization of Null Byte or NUL Character",description:"The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes NUL characters or null bytes when they are sent to a downstream component."},159:{title:"Failure to Sanitize Special Element",description:"Weaknesses in this attack-focused category do not properly filter and interpret special elements in user-controlled input which could cause adverse effect on the software behavior and integrity."},160:{title:"Improper Neutralization of Leading Special Elements",description:"The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes leading special elements that could be interpreted in unexpected ways when they are sent to a downstream component."},161:{title:"Improper Neutralization of Multiple Leading Special Elements",description:"The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes multiple leading special elements that could be interpreted in unexpected ways when they are sent to a downstream component."},162:{title:"Improper Neutralization of Trailing Special Elements",description:"The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes trailing special elements that could be interpreted in unexpected ways when they are sent to a downstream component."},163:{title:"Improper Neutralization of Multiple Trailing Special Elements",description:"The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes multiple trailing special elements that could be interpreted in unexpected ways when they are sent to a downstream component."},164:{title:"Improper Neutralization of Internal Special Elements",description:"The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes internal special elements that could be interpreted in unexpected ways when they are sent to a downstream component."},165:{title:"Improper Neutralization of Multiple Internal Special Elements",description:"The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes multiple internal special elements that could be interpreted in unexpected ways when they are sent to a downstream component."},166:{title:"Improper Handling of Missing Special Element",description:"The software receives input from an upstream component, but it does not handle or incorrectly handles when an expected special element is missing."},167:{title:"Improper Handling of Additional Special Element",description:"The software receives input from an upstream component, but it does not handle or incorrectly handles when an additional unexpected special element is missing."},168:{title:"Improper Handling of Inconsistent Special Elements",description:"The software does not handle when an inconsistency exists between two or more special characters or reserved words."},170:{title:"Improper Null Termination",description:"The software does not terminate or incorrectly terminates a string or array with a null character or equivalent terminator."},172:{title:"Encoding Error",description:"The software does not properly encode or decode the data, resulting in unexpected values."},173:{title:"Improper Handling of Alternate Encoding",description:"The software does not properly handle when an input uses an alternate encoding that is valid for the control sphere to which the input is being sent."},174:{title:"Double Decoding of the Same Data",description:"The software decodes the same input twice, which can limit the effectiveness of any protection mechanism that occurs in between the decoding operations."},175:{title:"Improper Handling of Mixed Encoding",description:"The software does not properly handle when the same input uses several different (mixed) encodings."},176:{title:"Improper Handling of Unicode Encoding",description:"The software does not properly handle when an input contains Unicode encoding."},177:{title:"Improper Handling of URL Encoding (Hex Encoding)",description:"The software does not properly handle when all or part of an input has been URL encoded."},178:{title:"Improper Handling of Case Sensitivity",description:"The software does not properly account for differences in case sensitivity when accessing or determining the properties of a resource, leading to inconsistent results."},179:{title:"Incorrect Behavior Order: Early Validation",description:"The software validates input before applying protection mechanisms that modify the input, which could allow an attacker to bypass the validation via dangerous inputs that only arise after the modification."},180:{title:"Incorrect Behavior Order: Validate Before Canonicalize",description:"The software validates input before it is canonicalized, which prevents the software from detecting data that becomes invalid after the canonicalization step."},181:{title:"Incorrect Behavior Order: Validate Before Filter",description:"The software validates data before it has been filtered, which prevents the software from detecting data that becomes invalid after the filtering step."},182:{title:"Collapse of Data into Unsafe Value",description:"The software filters data in a way that causes it to be reduced or collapsed into an unsafe value that violates an expected security property."},183:{title:"Permissive Whitelist",description:"An application uses a whitelist of acceptable values, but the whitelist includes at least one unsafe value, leading to resultant weaknesses."},184:{title:"Incomplete Blacklist",description:"An application uses a blacklist of prohibited values, but the blacklist is incomplete."},185:{title:"Incorrect Regular Expression",description:"The software specifies a regular expression in a way that causes data to be improperly matched or compared."},186:{title:"Overly Restrictive Regular Expression",description:"A regular expression is overly restrictive, which prevents dangerous values from being detected."},187:{title:"Partial String Comparison",description:"The software performs a comparison that only examines a portion of a factor before determining whether there is a match, such as a substring, leading to resultant weaknesses."},188:{title:"Reliance on Data/Memory Layout",description:"The software makes invalid assumptions about how protocol data or memory is organized at a lower level, resulting in unintended program behavior."},190:{title:"Integer Overflow or Wraparound",description:"The software performs a calculation that can produce an integer overflow or wraparound, when the logic assumes that the resulting value will always be larger than the original value. This can introduce other weaknesses when the calculation is used for resource management or execution control."},191:{title:"Integer Underflow (Wrap or Wraparound)",description:"The product subtracts one value from another, such that the result is less than the minimum allowable integer value, which produces a value that is not equal to the correct result."},192:{title:"Integer Coercion Error",description:"Integer coercion refers to a set of flaws pertaining to the type casting, extension, or truncation of primitive data types."},193:{title:"Off-by-one Error",description:"A product calculates or uses an incorrect maximum or minimum value that is 1 more, or 1 less, than the correct value."},194:{title:"Unexpected Sign Extension",description:"The software performs an operation on a number that causes it to be sign extended when it is transformed into a larger data type. When the original number is negative, this can produce unexpected values that lead to resultant weaknesses."},195:{title:"Signed to Unsigned Conversion Error",description:"The software uses a signed primitive and performs a cast to an unsigned primitive, which can produce an unexpected value if the value of the signed primitive can not be represented using an unsigned primitive."},196:{title:"Unsigned to Signed Conversion Error",description:"The software uses an unsigned primitive and performs a cast to a signed primitive, which can produce an unexpected value if the value of the unsigned primitive can not be represented using a signed primitive."},197:{title:"Numeric Truncation Error",description:"Truncation errors occur when a primitive is cast to a primitive of a smaller size and data is lost in the conversion."},198:{title:"Use of Incorrect Byte Ordering",description:"The software receives input from an upstream component, but it does not account for byte ordering (e.g. big-endian and little-endian) when processing the input, causing an incorrect number or value to be used."},200:{title:"Information Exposure",description:"An information exposure is the intentional or unintentional disclosure of information to an actor that is not explicitly authorized to have access to that information."},201:{title:"Information Exposure Through Sent Data",description:"The accidental exposure of sensitive information through sent data refers to the transmission of data which are either sensitive in and of itself or useful in the further exploitation of the system through standard data channels."},202:{title:"Exposure of Sensitive Data Through Data Queries",description:"When trying to keep information confidential, an attacker can often infer some of the information by using statistics."},203:{title:"Information Exposure Through Discrepancy",description:"The product behaves differently or sends different responses in a way that exposes security-relevant information about the state of the product, such as whether a particular operation was successful or not."},204:{title:"Response Discrepancy Information Exposure",description:"The software provides different responses to incoming requests in a way that allows an actor to determine system state information that is outside of that actor's control sphere."},205:{title:"Information Exposure Through Behavioral Discrepancy",description:"The product's actions indicate important differences based on (1) the internal state of the product or (2) differences from other products in the same class."},206:{title:"Information Exposure of Internal State Through Behavioral Inconsistency",description:"Two separate operations in a product cause the product to behave differently in a way that is observable to an attacker and reveals security-relevant information about the internal state of the product, such as whether a particular operation was successful or not."},207:{title:"Information Exposure Through an External Behavioral Inconsistency",description:"The product behaves differently than other products like it, in a way that is observable to an attacker and exposes security-relevant information about which product is being used."},208:{title:"Information Exposure Through Timing Discrepancy",description:"Two separate operations in a product require different amounts of time to complete, in a way that is observable to an actor and reveals security-relevant information about the state of the product, such as whether a particular operation was successful or not."},209:{title:"Information Exposure Through an Error Message",description:"The software generates an error message that includes sensitive information about its environment, users, or associated data."},210:{title:"Information Exposure Through Self-generated Error Message",description:"The software identifies an error condition and creates its own diagnostic or error messages that contain sensitive information."},211:{title:"Information Exposure Through Externally-Generated Error Message",description:"The software performs an operation that triggers an external diagnostic or error message that is not directly generated by the software, such as an error generated by the programming language interpreter that the software uses. The error can contain sensitive system information."},212:{title:"Improper Cross-boundary Removal of Sensitive Data",description:"The software uses a resource that contains sensitive data, but it does not properly remove that data before it stores, transfers, or shares the resource with actors in another control sphere."},213:{title:"Intentional Information Exposure",description:"A product's design or configuration explicitly requires the publication of information that could be regarded as sensitive by an administrator."},214:{title:"Information Exposure Through Process Environment",description:"A process is invoked with sensitive arguments, environment variables, or other elements that can be seen by other processes on the operating system."},215:{title:"Information Exposure Through Debug Information",description:"The application contains debugging code that can expose sensitive information to untrusted parties."},216:{title:"Containment Errors (Container Errors)",description:"This tries to cover various problems in which improper data are included within a container."},219:{title:"Sensitive Data Under Web Root",description:"The application stores sensitive data under the web document root with insufficient access control, which might make it accessible to untrusted parties."},220:{title:"Sensitive Data Under FTP Root",description:"The application stores sensitive data under the FTP document root with insufficient access control, which might make it accessible to untrusted parties."},221:{title:"Information Loss or Omission",description:"The software does not record, or improperly records, security-relevant information that leads to an incorrect decision or hampers later analysis."},222:{title:"Truncation of Security-relevant Information",description:"The application truncates the display, recording, or processing of security-relevant information in a way that can obscure the source or nature of an attack."},223:{title:"Omission of Security-relevant Information",description:"The application does not record or display information that would be important for identifying the source or nature of an attack, or determining if an action is safe."},224:{title:"Obscured Security-relevant Information by Alternate Name",description:"The software records security-relevant information according to an alternate name of the affected entity, instead of the canonical name."},226:{title:"Sensitive Information Uncleared Before Release",description:"The software does not fully clear previously used information in a data structure, file, or other resource, before making that resource available to a party in another control sphere."},228:{title:"Improper Handling of Syntactically Invalid Structure",description:"The product does not handle or incorrectly handles input that is not syntactically well-formed with respect to the associated specification."},229:{title:"Improper Handling of Values",description:"The software does not properly handle when the expected number of values for parameters, fields, or arguments is not provided in input, or if those values are undefined."},230:{title:"Improper Handling of Missing Values",description:"The software does not handle or incorrectly handles when a parameter, field, or argument name is specified, but the associated value is missing, i.e. it is empty, blank, or null."},231:{title:"Improper Handling of Extra Values",description:"The software does not handle or incorrectly handles when more values are provided than expected."},232:{title:"Improper Handling of Undefined Values",description:"The software does not handle or incorrectly handles when a value is not defined or supported for the associated parameter, field, or argument name."},233:{title:"Improper Handling of Parameters",description:"The software does not properly handle when the expected number of parameters, fields, or arguments is not provided in input, or if those parameters are undefined."},234:{title:"Failure to Handle Missing Parameter",description:"If too few arguments are sent to a function, the function will still pop the expected number of arguments from the stack. Potentially, a variable number of arguments could be exhausted in a function as well."},235:{title:"Improper Handling of Extra Parameters",description:"The software does not handle or incorrectly handles when the number of parameters, fields, or arguments with the same name exceeds the expected amount."},236:{title:"Improper Handling of Undefined Parameters",description:"The software does not handle or incorrectly handles when a particular parameter, field, or argument name is not defined or supported by the product."},237:{title:"Improper Handling of Structural Elements",description:"The software does not handle or incorrectly handles inputs that are related to complex structures."},238:{title:"Improper Handling of Incomplete Structural Elements",description:"The software does not handle or incorrectly handles when a particular structural element is not completely specified."},239:{title:"Failure to Handle Incomplete Element",description:"The software does not properly handle when a particular element is not completely specified."},240:{title:"Improper Handling of Inconsistent Structural Elements",description:"The software does not handle or incorrectly handles when two or more structural elements should be consistent, but are not."},241:{title:"Improper Handling of Unexpected Data Type",description:"The software does not handle or incorrectly handles when a particular element is not the expected type, e.g. it expects a digit (0-9) but is provided with a letter (A-Z)."},242:{title:"Use of Inherently Dangerous Function",description:"The program calls a function that can never be guaranteed to work safely."},243:{title:"Creation of chroot Jail Without Changing Working Directory",description:"The program uses the chroot() system call to create a jail, but does not change the working directory afterward. This does not prevent access to files outside of the jail."},244:{title:"Improper Clearing of Heap Memory Before Release ('Heap Inspection')",description:"Using realloc() to resize buffers that store sensitive information can leave the sensitive information exposed to attack, because it is not removed from memory."},245:{title:"J2EE Bad Practices: Direct Management of Connections",description:"The J2EE application directly manages connections, instead of using the container's connection management facilities."},246:{title:"J2EE Bad Practices: Direct Use of Sockets",description:"The J2EE application directly uses sockets instead of using framework method calls."},248:{title:"Uncaught Exception",description:"An exception is thrown from a function, but it is not caught."},250:{title:"Execution with Unnecessary Privileges",description:"The software performs an operation at a privilege level that is higher than the minimum level required, which creates new weaknesses or amplifies the consequences of other weaknesses."},252:{title:"Unchecked Return Value",description:"The software does not check the return value from a method or function, which can prevent it from detecting unexpected states and conditions."},253:{title:"Incorrect Check of Function Return Value",description:"The software incorrectly checks a return value from a function, which prevents the software from detecting errors or exceptional conditions."},256:{title:"Unprotected Storage of Credentials",description:"Storing a password in plaintext may result in a system compromise."},257:{title:"Storing Passwords in a Recoverable Format",description:"The storage of passwords in a recoverable format makes them subject to password reuse attacks by malicious users. In fact, it should be noted that recoverable encrypted passwords provide no significant benefit over plaintext passwords since they are subject not only to reuse by malicious attackers but also by malicious insiders. If a system administrator can recover a password directly, or use a brute force search on the available information, the administrator can use the password on other accounts."},258:{title:"Empty Password in Configuration File",description:"Using an empty string as a password is insecure."},259:{title:"Use of Hard-coded Password",description:"The software contains a hard-coded password, which it uses for its own inbound authentication or for outbound communication to external components."},260:{title:"Password in Configuration File",description:"The software stores a password in a configuration file that might be accessible to actors who do not know the password."},261:{title:"Weak Cryptography for Passwords",description:"Obscuring a password with a trivial encoding does not protect the password."},262:{title:"Not Using Password Aging",description:"If no mechanism is in place for managing password aging, users will have no incentive to update passwords in a timely manner."},263:{title:"Password Aging with Long Expiration",description:"Allowing password aging to occur unchecked can result in the possibility of diminished password integrity."},266:{title:"Incorrect Privilege Assignment",description:"A product incorrectly assigns a privilege to a particular actor, creating an unintended sphere of control for that actor."},267:{title:"Privilege Defined With Unsafe Actions",description:"A particular privilege, role, capability, or right can be used to perform unsafe actions that were not intended, even when it is assigned to the correct entity."},268:{title:"Privilege Chaining",description:"Two distinct privileges, roles, capabilities, or rights can be combined in a way that allows an entity to perform unsafe actions that would not be allowed without that combination."},269:{title:"Improper Privilege Management",description:"The software does not properly assign, modify, track, or check privileges for an actor, creating an unintended sphere of control for that actor."},270:{title:"Privilege Context Switching Error",description:"The software does not properly manage privileges while it is switching between different contexts that have different privileges or spheres of control."},271:{title:"Privilege Dropping / Lowering Errors",description:"The software does not drop privileges before passing control of a resource to an actor that does not have those privileges."},272:{title:"Least Privilege Violation",description:"The elevated privilege level required to perform operations such as chroot() should be dropped immediately after the operation is performed."},273:{title:"Improper Check for Dropped Privileges",description:"The software attempts to drop privileges but does not check or incorrectly checks to see if the drop succeeded."},274:{title:"Improper Handling of Insufficient Privileges",description:"The software does not handle or incorrectly handles when it has insufficient privileges to perform an operation, leading to resultant weaknesses."},276:{title:"Incorrect Default Permissions",description:"The software, upon installation, sets incorrect permissions for an object that exposes it to an unintended actor."},277:{title:"Insecure Inherited Permissions",description:"A product defines a set of insecure permissions that are inherited by objects that are created by the program."},278:{title:"Insecure Preserved Inherited Permissions",description:"A product inherits a set of insecure permissions for an object, e.g. when copying from an archive file, without user awareness or involvement."},279:{title:"Incorrect Execution-Assigned Permissions",description:"While it is executing, the software sets the permissions of an object in a way that violates the intended permissions that have been specified by the user."},280:{title:"Improper Handling of Insufficient Permissions or Privileges ",description:"The application does not handle or incorrectly handles when it has insufficient privileges to access resources or functionality as specified by their permissions. This may cause it to follow unexpected code paths that may leave the application in an invalid state."},281:{title:"Improper Preservation of Permissions",description:"The software does not preserve permissions or incorrectly preserves permissions when copying, restoring, or sharing objects, which can cause them to have less restrictive permissions than intended."},282:{title:"Improper Ownership Management",description:"The software assigns the wrong ownership, or does not properly verify the ownership, of an object or resource."},283:{title:"Unverified Ownership",description:"The software does not properly verify that a critical resource is owned by the proper entity."},284:{title:"Improper Access Control",description:"The software does not restrict or incorrectly restricts access to a resource from an unauthorized actor."},285:{title:"Improper Authorization",description:"The software does not perform or incorrectly performs an authorization check when an actor attempts to access a resource or perform an action."},286:{title:"Incorrect User Management",description:"The software does not properly manage a user within its environment."},287:{title:"Improper Authentication",description:"When an actor claims to have a given identity, the software does not prove or insufficiently proves that the claim is correct."},288:{title:"Authentication Bypass Using an Alternate Path or Channel",description:"A product requires authentication, but the product has an alternate path or channel that does not require authentication."},289:{title:"Authentication Bypass by Alternate Name",description:"The software performs authentication based on the name of a resource being accessed, or the name of the actor performing the access, but it does not properly check all possible names for that resource or actor."},290:{title:"Authentication Bypass by Spoofing",description:"This attack-focused weakness is caused by improperly implemented authentication schemes that are subject to spoofing attacks."},291:{title:"Reliance on IP Address for Authentication",description:"The software uses an IP address for authentication."},293:{title:"Using Referer Field for Authentication",description:"The referer field in HTTP requests can be easily modified and, as such, is not a valid means of message integrity checking."},294:{title:"Authentication Bypass by Capture-replay",description:"A capture-replay flaw exists when the design of the software makes it possible for a malicious user to sniff network traffic and bypass authentication by replaying it to the server in question to the same effect as the original message (or with minor changes)."},295:{title:"Improper Certificate Validation",description:"The software does not validate, or incorrectly validates, a certificate."},296:{title:"Improper Following of a Certificate's Chain of Trust",description:"The software does not follow, or incorrectly follows, the chain of trust for a certificate back to a trusted root certificate, resulting in incorrect trust of any resource that is associated with that certificate."},297:{title:"Improper Validation of Certificate with Host Mismatch",description:"The software communicates with a host that provides a certificate, but the software does not properly ensure that the certificate is actually associated with that host."},298:{title:"Improper Validation of Certificate Expiration",description:"A certificate expiration is not validated or is incorrectly validated, so trust may be assigned to certificates that have been abandoned due to age."},299:{title:"Improper Check for Certificate Revocation",description:"The software does not check or incorrectly checks the revocation status of a certificate, which may cause it to use a certificate that has been compromised."},300:{title:"Channel Accessible by Non-Endpoint ('Man-in-the-Middle')",description:"The product does not adequately verify the identity of actors at both ends of a communication channel, or does not adequately ensure the integrity of the channel, in a way that allows the channel to be accessed or influenced by an actor that is not an endpoint."},301:{title:"Reflection Attack in an Authentication Protocol",description:"Simple authentication protocols are subject to reflection attacks if a malicious user can use the target machine to impersonate a trusted user."},302:{title:"Authentication Bypass by Assumed-Immutable Data",description:"The authentication scheme or implementation uses key data elements that are assumed to be immutable, but can be controlled or modified by the attacker."},303:{title:"Incorrect Implementation of Authentication Algorithm",description:"The requirements for the software dictate the use of an established authentication algorithm, but the implementation of the algorithm is incorrect."},304:{title:"Missing Critical Step in Authentication",description:"The software implements an authentication technique, but it skips a step that weakens the technique."},305:{title:"Authentication Bypass by Primary Weakness",description:"The authentication algorithm is sound, but the implemented mechanism can be bypassed as the result of a separate weakness that is primary to the authentication error."},306:{title:"Missing Authentication for Critical Function",description:"The software does not perform any authentication for functionality that requires a provable user identity or consumes a significant amount of resources."},307:{title:"Improper Restriction of Excessive Authentication Attempts",description:"The software does not implement sufficient measures to prevent multiple failed authentication attempts within in a short time frame, making it more susceptible to brute force attacks."},308:{title:"Use of Single-factor Authentication",description:"The use of single-factor authentication can lead to unnecessary risk of compromise when compared with the benefits of a dual-factor authentication scheme."},309:{title:"Use of Password System for Primary Authentication",description:"The use of password systems as the primary means of authentication may be subject to several flaws or shortcomings, each reducing the effectiveness of the mechanism."},311:{title:"Missing Encryption of Sensitive Data",description:"The software does not encrypt sensitive or critical information before storage or transmission."},312:{title:"Cleartext Storage of Sensitive Information",description:"The application stores sensitive information in cleartext within a resource that might be accessible to another control sphere."},313:{title:"Cleartext Storage in a File or on Disk",description:"The application stores sensitive information in cleartext in a file, or on disk."},314:{title:"Cleartext Storage in the Registry",description:"The application stores sensitive information in cleartext in the registry."},315:{title:"Cleartext Storage of Sensitive Information in a Cookie",description:"The application stores sensitive information in cleartext in a cookie."},316:{title:"Cleartext Storage of Sensitive Information in Memory",description:"The application stores sensitive information in cleartext in memory."},317:{title:"Cleartext Storage of Sensitive Information in GUI",description:"The application stores sensitive information in cleartext within the GUI."},318:{title:"Cleartext Storage of Sensitive Information in Executable",description:"The application stores sensitive information in cleartext in an executable."},319:{title:"Cleartext Transmission of Sensitive Information",description:"The software transmits sensitive or security-critical data in cleartext in a communication channel that can be sniffed by unauthorized actors."},321:{title:"Use of Hard-coded Cryptographic Key",description:"The use of a hard-coded cryptographic key significantly increases the possibility that encrypted data may be recovered."},322:{title:"Key Exchange without Entity Authentication",description:"The software performs a key exchange with an actor without verifying the identity of that actor."},323:{title:"Reusing a Nonce, Key Pair in Encryption",description:"Nonces should be used for the present occasion and only once."},324:{title:"Use of a Key Past its Expiration Date",description:"The product uses a cryptographic key or password past its expiration date, which diminishes its safety significantly by increasing the timing window for cracking attacks against that key."},325:{title:"Missing Required Cryptographic Step",description:"The software does not implement a required step in a cryptographic algorithm, resulting in weaker encryption than advertised by that algorithm."},326:{title:"Inadequate Encryption Strength",description:"The software stores or transmits sensitive data using an encryption scheme that is theoretically sound, but is not strong enough for the level of protection required."},327:{title:"Use of a Broken or Risky Cryptographic Algorithm",description:"The use of a broken or risky cryptographic algorithm is an unnecessary risk that may result in the exposure of sensitive information."},328:{title:"Reversible One-Way Hash",description:"The product uses a hashing algorithm that produces a hash value that can be used to determine the original input, or to find an input that can produce the same hash, more efficiently than brute force techniques."},329:{title:"Not Using a Random IV with CBC Mode",description:"Not using a random initialization Vector (IV) with Cipher Block Chaining (CBC) Mode causes algorithms to be susceptible to dictionary attacks."},330:{title:"Use of Insufficiently Random Values",description:"The software may use insufficiently random numbers or values in a security context that depends on unpredictable numbers."},331:{title:"Insufficient Entropy",description:"The software uses an algorithm or scheme that produces insufficient entropy, leaving patterns or clusters of values that are more likely to occur than others."},332:{title:"Insufficient Entropy in PRNG",description:"The lack of entropy available for, or used by, a Pseudo-Random Number Generator (PRNG) can be a stability and security threat."},333:{title:"Improper Handling of Insufficient Entropy in TRNG",description:"True random number generators (TRNG) generally have a limited source of entropy and therefore can fail or block."},334:{title:"Small Space of Random Values",description:"The number of possible random values is smaller than needed by the product, making it more susceptible to brute force attacks."},335:{title:"Incorrect Usage of Seeds in Pseudo-Random Number Generator (PRNG)",description:"The software uses a Pseudo-Random Number Generator (PRNG) that does not correctly manage seeds."},336:{title:"Same Seed in Pseudo-Random Number Generator (PRNG)",description:"A Pseudo-Random Number Generator (PRNG) uses the same seed each time the product is initialized."},337:{title:"Predictable Seed in Pseudo-Random Number Generator (PRNG)",description:"A Pseudo-Random Number Generator (PRNG) is initialized from a predictable seed, such as the process ID or system time."},338:{title:"Use of Cryptographically Weak Pseudo-Random Number Generator (PRNG)",description:"The product uses a Pseudo-Random Number Generator (PRNG) in a security context, but the PRNG's algorithm is not cryptographically strong."},339:{title:"Small Seed Space in PRNG",description:"A PRNG uses a relatively small space of seeds."},340:{title:"Predictability Problems",description:"Weaknesses in this category are related to schemes that generate numbers or identifiers that are more predictable than required by the application."},341:{title:"Predictable from Observable State",description:"A number or object is predictable based on observations that the attacker can make about the state of the system or network, such as time, process ID, etc."},342:{title:"Predictable Exact Value from Previous Values",description:"An exact value or random number can be precisely predicted by observing previous values."},343:{title:"Predictable Value Range from Previous Values",description:"The software's random number generator produces a series of values which, when observed, can be used to infer a relatively small range of possibilities for the next value that could be generated."},344:{title:"Use of Invariant Value in Dynamically Changing Context",description:"The product uses a constant value, name, or reference, but this value can (or should) vary across different environments."},345:{title:"Insufficient Verification of Data Authenticity",description:"The software does not sufficiently verify the origin or authenticity of data, in a way that causes it to accept invalid data."},346:{title:"Origin Validation Error",description:"The software does not properly verify that the source of data or communication is valid."},347:{title:"Improper Verification of Cryptographic Signature",description:"The software does not verify, or incorrectly verifies, the cryptographic signature for data."},348:{title:"Use of Less Trusted Source",description:"The software has two different sources of the same data or information, but it uses the source that has less support for verification, is less trusted, or is less resistant to attack."},349:{title:"Acceptance of Extraneous Untrusted Data With Trusted Data",description:"The software, when processing trusted data, accepts any untrusted data that is also included with the trusted data, treating the untrusted data as if it were trusted."},350:{title:"Reliance on Reverse DNS Resolution for a Security-Critical Action",description:"The software performs reverse DNS resolution on an IP address to obtain the hostname and make a security decision, but it does not properly ensure that the IP address is truly associated with the hostname."},351:{title:"Insufficient Type Distinction",description:"The software does not properly distinguish between different types of elements in a way that leads to insecure behavior."},352:{title:"Cross-Site Request Forgery (CSRF)",description:"The web application does not, or can not, sufficiently verify whether a well-formed, valid, consistent request was intentionally provided by the user who submitted the request."},353:{title:"Missing Support for Integrity Check",description:"The software uses a transmission protocol that does not include a mechanism for verifying the integrity of the data during transmission, such as a checksum."},354:{title:"Improper Validation of Integrity Check Value",description:"The software does not validate or incorrectly validates the integrity check values or checksums of a message. This may prevent it from detecting if the data has been modified or corrupted in transmission."},356:{title:"Product UI does not Warn User of Unsafe Actions",description:"The software's user interface does not warn the user before undertaking an unsafe action on behalf of that user. This makes it easier for attackers to trick users into inflicting damage to their system."},357:{title:"Insufficient UI Warning of Dangerous Operations",description:"The user interface provides a warning to a user regarding dangerous or sensitive operations, but the warning is not noticeable enough to warrant attention."},358:{title:"Improperly Implemented Security Check for Standard",description:"The software does not implement or incorrectly implements one or more security-relevant checks as specified by the design of a standardized algorithm, protocol, or technique."},359:{title:"Exposure of Private Information ('Privacy Violation')",description:"The software does not properly prevent private data (such as credit card numbers) from being accessed by actors who either (1) are not explicitly authorized to access the data or (2) do not have the implicit consent of the people to which the data is related."},360:{title:"Trust of System Event Data",description:"Security based on event locations are insecure and can be spoofed."},362:{title:"Concurrent Execution using Shared Resource with Improper Synchronization ('Race Condition')",description:"The program contains a code sequence that can run concurrently with other code, and the code sequence requires temporary, exclusive access to a shared resource, but a timing window exists in which the shared resource can be modified by another code sequence that is operating concurrently."},363:{title:"Race Condition Enabling Link Following",description:"The software checks the status of a file or directory before accessing it, which produces a race condition in which the file can be replaced with a link before the access is performed, causing the software to access the wrong file."},364:{title:"Signal Handler Race Condition",description:"The software uses a signal handler that introduces a race condition."},365:{title:"Race Condition in Switch",description:"The code contains a switch statement in which the switched variable can be modified while the switch is still executing, resulting in unexpected behavior."},366:{title:"Race Condition within a Thread",description:"If two threads of execution use a resource simultaneously, there exists the possibility that resources may be used while invalid, in turn making the state of execution undefined."},367:{title:"Time-of-check Time-of-use (TOCTOU) Race Condition",description:"The software checks the state of a resource before using that resource, but the resource's state can change between the check and the use in a way that invalidates the results of the check. This can cause the software to perform invalid actions when the resource is in an unexpected state."},368:{title:"Context Switching Race Condition",description:"A product performs a series of non-atomic actions to switch between contexts that cross privilege or other security boundaries, but a race condition allows an attacker to modify or misrepresent the product's behavior during the switch."},369:{title:"Divide By Zero",description:"The product divides a value by zero."},370:{title:"Missing Check for Certificate Revocation after Initial Check",description:"The software does not check the revocation status of a certificate after its initial revocation check, which can cause the software to perform privileged actions even after the certificate is revoked at a later time."},372:{title:"Incomplete Internal State Distinction",description:"The software does not properly determine which state it is in, causing it to assume it is in state X when in fact it is in state Y, causing it to perform incorrect operations in a security-relevant manner."},374:{title:"Passing Mutable Objects to an Untrusted Method",description:"The program sends non-cloned mutable data as an argument to a method or function."},375:{title:"Returning a Mutable Object to an Untrusted Caller",description:"Sending non-cloned mutable data as a return value may result in that data being altered or deleted by the calling function."},377:{title:"Insecure Temporary File",description:"Creating and using insecure temporary files can leave application and system data vulnerable to attack."},378:{title:"Creation of Temporary File With Insecure Permissions",description:"Opening temporary files without appropriate measures or controls can leave the file, its contents and any function that it impacts vulnerable to attack."},379:{title:"Creation of Temporary File in Directory with Incorrect Permissions",description:"The software creates a temporary file in a directory whose permissions allow unintended actors to determine the file's existence or otherwise access that file."},382:{title:"J2EE Bad Practices: Use of System.exit()",description:"A J2EE application uses System.exit(), which also shuts down its container."},383:{title:"J2EE Bad Practices: Direct Use of Threads",description:"Thread management in a Web application is forbidden in some circumstances and is always highly error prone."},384:{title:"Session Fixation",description:"Authenticating a user, or otherwise establishing a new user session, without invalidating any existing session identifier gives an attacker the opportunity to steal authenticated sessions."},385:{title:"Covert Timing Channel",description:"Covert timing channels convey information by modulating some aspect of system behavior over time, so that the program receiving the information can observe system behavior and infer protected information."},386:{title:"Symbolic Name not Mapping to Correct Object",description:"A constant symbolic reference to an object is used, even though the reference can resolve to a different object over time."},390:{title:"Detection of Error Condition Without Action",description:"The software detects a specific error, but takes no actions to handle the error."},391:{title:"Unchecked Error Condition",description:"Ignoring exceptions and other error conditions may allow an attacker to induce unexpected behavior unnoticed."},392:{title:"Missing Report of Error Condition",description:"The software encounters an error but does not provide a status code or return value to indicate that an error has occurred."},393:{title:"Return of Wrong Status Code",description:"A function or operation returns an incorrect return value or status code that does not indicate an error, but causes the product to modify its behavior based on the incorrect result."},394:{title:"Unexpected Status Code or Return Value",description:"The software does not properly check when a function or operation returns a value that is legitimate for the function, but is not expected by the software."},395:{title:"Use of NullPointerException Catch to Detect NULL Pointer Dereference",description:"Catching NullPointerException should not be used as an alternative to programmatic checks to prevent dereferencing a null pointer."},396:{title:"Declaration of Catch for Generic Exception",description:"Catching overly broad exceptions promotes complex error handling code that is more likely to contain security vulnerabilities."},397:{title:"Declaration of Throws for Generic Exception",description:"Throwing overly broad exceptions promotes complex error handling code that is more likely to contain security vulnerabilities."},400:{title:"Uncontrolled Resource Consumption ('Resource Exhaustion')",description:"The software does not properly restrict the size or amount of resources that are requested or influenced by an actor, which can be used to consume more resources than intended."},401:{title:"Improper Release of Memory Before Removing Last Reference ('Memory Leak')",description:"The software does not sufficiently track and release allocated memory after it has been used, which slowly consumes remaining memory."},402:{title:"Transmission of Private Resources into a New Sphere ('Resource Leak')",description:"The software makes resources available to untrusted parties when those resources are only intended to be accessed by the software."},403:{title:"Exposure of File Descriptor to Unintended Control Sphere ('File Descriptor Leak')",description:"A process does not close sensitive file descriptors before invoking a child process, which allows the child to perform unauthorized I/O operations using those descriptors."},404:{title:"Improper Resource Shutdown or Release",description:"The program does not release or incorrectly releases a resource before it is made available for re-use."},405:{title:"Asymmetric Resource Consumption (Amplification)",description:"Software that does not appropriately monitor or control resource consumption can lead to adverse system performance."},406:{title:"Insufficient Control of Network Message Volume (Network Amplification)",description:"The software does not sufficiently monitor or control transmitted network traffic volume, so that an actor can cause the software to transmit more traffic than should be allowed for that actor."},407:{title:"Algorithmic Complexity",description:"An algorithm in a product has an inefficient worst-case computational complexity that may be detrimental to system performance and can be triggered by an attacker, typically using crafted manipulations that ensure that the worst case is being reached."},408:{title:"Incorrect Behavior Order: Early Amplification",description:"The software allows an entity to perform a legitimate but expensive operation before authentication or authorization has taken place."},409:{title:"Improper Handling of Highly Compressed Data (Data Amplification)",description:"The software does not handle or incorrectly handles a compressed input with a very high compression ratio that produces a large output."},410:{title:"Insufficient Resource Pool",description:"The software's resource pool is not large enough to handle peak demand, which allows an attacker to prevent others from accessing the resource by using a (relatively) large number of requests for resources."},412:{title:"Unrestricted Externally Accessible Lock",description:"The software properly checks for the existence of a lock, but the lock can be externally controlled or influenced by an actor that is outside of the intended sphere of control."},413:{title:"Improper Resource Locking",description:"The software does not lock or does not correctly lock a resource when the software must have exclusive access to the resource."},414:{title:"Missing Lock Check",description:"A product does not check to see if a lock is present before performing sensitive operations on a resource."},415:{title:"Double Free",description:"The product calls free() twice on the same memory address, potentially leading to modification of unexpected memory locations."},416:{title:"Use After Free",description:"Referencing memory after it has been freed can cause a program to crash, use unexpected values, or execute code."},419:{title:"Unprotected Primary Channel",description:"The software uses a primary channel for administration or restricted functionality, but it does not properly protect the channel."},420:{title:"Unprotected Alternate Channel",description:"The software protects a primary channel, but it does not use the same level of protection for an alternate channel."},421:{title:"Race Condition During Access to Alternate Channel",description:"The product opens an alternate channel to communicate with an authorized user, but the channel is accessible to other actors."},422:{title:"Unprotected Windows Messaging Channel ('Shatter')",description:"The software does not properly verify the source of a message in the Windows Messaging System while running at elevated privileges, creating an alternate channel through which an attacker can directly send a message to the product."},424:{title:"Improper Protection of Alternate Path",description:"The product does not sufficiently protect all possible paths that a user can take to access restricted functionality or resources."},425:{title:"Direct Request ('Forced Browsing')",description:"The web application does not adequately enforce appropriate authorization on all restricted URLs, scripts, or files."},426:{title:"Untrusted Search Path",description:"The application searches for critical resources using an externally-supplied search path that can point to resources that are not under the application's direct control."},427:{title:"Uncontrolled Search Path Element",description:"The product uses a fixed or controlled search path to find resources, but one or more locations in that path can be under the control of unintended actors."},428:{title:"Unquoted Search Path or Element",description:"The product uses a search path that contains an unquoted element, in which the element contains whitespace or other separators. This can cause the product to access resources in a parent path."},430:{title:"Deployment of Wrong Handler",description:"The wrong handler is assigned to process an object."},431:{title:"Missing Handler",description:"A handler is not available or implemented."},432:{title:"Dangerous Signal Handler not Disabled During Sensitive Operations",description:"The application uses a signal handler that shares state with other signal handlers, but it does not properly mask or prevent those signal handlers from being invoked while the original signal handler is still running."},433:{title:"Unparsed Raw Web Content Delivery",description:"The software stores raw content or supporting code under the web document root with an extension that is not specifically handled by the server."},434:{title:"Unrestricted Upload of File with Dangerous Type",description:"The software allows the attacker to upload or transfer files of dangerous types that can be automatically processed within the product's environment."},435:{title:"Improper Interaction Between Multiple Correctly-Behaving Entities",description:"An interaction error occurs when two entities have correct behavior when running independently of each other, but when they are integrated as components in a larger system or process, they introduce incorrect behaviors that may cause resultant weaknesses."},436:{title:"Interpretation Conflict",description:"Product A handles inputs or steps differently than Product B, which causes A to perform incorrect actions based on its perception of B's state."},437:{title:"Incomplete Model of Endpoint Features",description:"A product acts as an intermediary or monitor between two or more endpoints, but it does not have a complete model of an endpoint's features, behaviors, or state, potentially causing the product to perform incorrect actions based on this incomplete model."},439:{title:"Behavioral Change in New Version or Environment",description:"A's behavior or functionality changes with a new version of A, or a new environment, which is not known (or manageable) by B."},440:{title:"Expected Behavior Violation",description:"A feature, API, or function being used by a product behaves differently than the product expects."},441:{title:"Unintended Proxy or Intermediary ('Confused Deputy')",description:"The software receives a request, message, or directive from an upstream component, but the software does not sufficiently preserve the original source of the request before forwarding the request to an external actor that is outside of the software's control sphere. This causes the software to appear to be the source of the request, leading it to act as a proxy or other intermediary between the upstream component and the external actor."},444:{title:"Inconsistent Interpretation of HTTP Requests ('HTTP Request Smuggling')",description:"When malformed or abnormal HTTP requests are interpreted by one or more entities in the data flow between the user and the web server, such as a proxy or firewall, they can be interpreted inconsistently, allowing the attacker to smuggle a request to one device without the other device being aware of it."},446:{title:"UI Discrepancy for Security Feature",description:"The user interface does not correctly enable or configure a security feature, but the interface provides feedback that causes the user to believe that the feature is in a secure state."},447:{title:"Unimplemented or Unsupported Feature in UI",description:"A UI function for a security feature appears to be supported and gives feedback to the user that suggests that it is supported, but the underlying functionality is not implemented."},448:{title:"Obsolete Feature in UI",description:"A UI function is obsolete and the product does not warn the user."},449:{title:"The UI Performs the Wrong Action",description:"The UI performs the wrong action with respect to the user's request."},450:{title:"Multiple Interpretations of UI Input",description:"The UI has multiple interpretations of user input but does not prompt the user when it selects the less secure interpretation."},451:{title:"User Interface (UI) Misrepresentation of Critical Information",description:"The user interface (UI) does not properly represent critical information to the user, allowing the information - or its source - to be obscured or spoofed. This is often a component in phishing attacks."},453:{title:"Insecure Default Variable Initialization",description:"The software, by default, initializes an internal variable with an insecure or less secure value than is possible."},454:{title:"External Initialization of Trusted Variables or Data Stores",description:"The software initializes critical internal variables or data stores using inputs that can be modified by untrusted actors."},455:{title:"Non-exit on Failed Initialization",description:"The software does not exit or otherwise modify its operation when security-relevant errors occur during initialization, such as when a configuration file has a format error, which can cause the software to execute in a less secure fashion than intended by the administrator."},456:{title:"Missing Initialization of a Variable",description:"The software does not initialize critical variables, which causes the execution environment to use unexpected values."},457:{title:"Use of Uninitialized Variable",description:"The code uses a variable that has not been initialized, leading to unpredictable or unintended results."},459:{title:"Incomplete Cleanup",description:"The software does not properly clean up and remove temporary or supporting resources after they have been used."},460:{title:"Improper Cleanup on Thrown Exception",description:"The product does not clean up its state or incorrectly cleans up its state when an exception is thrown, leading to unexpected state or control flow."},462:{title:"Duplicate Key in Associative List (Alist)",description:"Duplicate keys in associative lists can lead to non-unique keys being mistaken for an error."},463:{title:"Deletion of Data Structure Sentinel",description:"The accidental deletion of a data-structure sentinel can cause serious programming logic problems."},464:{title:"Addition of Data Structure Sentinel",description:"The accidental addition of a data-structure sentinel can cause serious programming logic problems."},466:{title:"Return of Pointer Value Outside of Expected Range",description:"A function can return a pointer to memory that is outside of the buffer that the pointer is expected to reference."},467:{title:"Use of sizeof() on a Pointer Type",description:"The code calls sizeof() on a malloced pointer type, which always returns the wordsize/8. This can produce an unexpected result if the programmer intended to determine how much memory has been allocated."},468:{title:"Incorrect Pointer Scaling",description:"In C and C++, one may often accidentally refer to the wrong memory due to the semantics of when math operations are implicitly scaled."},469:{title:"Use of Pointer Subtraction to Determine Size",description:"The application subtracts one pointer from another in order to determine size, but this calculation can be incorrect if the pointers do not exist in the same memory chunk."},470:{title:"Use of Externally-Controlled Input to Select Classes or Code ('Unsafe Reflection')",description:"The application uses external input with reflection to select which classes or code to use, but it does not sufficiently prevent the input from selecting improper classes or code."},471:{title:"Modification of Assumed-Immutable Data (MAID)",description:"The software does not properly protect an assumed-immutable element from being modified by an attacker."},472:{title:"External Control of Assumed-Immutable Web Parameter",description:"The web application does not sufficiently verify inputs that are assumed to be immutable but are actually externally controllable, such as hidden form fields."},473:{title:"PHP External Variable Modification",description:"A PHP application does not properly protect against the modification of variables from external sources, such as query parameters or cookies. This can expose the application to numerous weaknesses that would not exist otherwise."},474:{title:"Use of Function with Inconsistent Implementations",description:"The code uses a function that has inconsistent implementations across operating systems and versions."},475:{title:"Undefined Behavior for Input to API",description:"The behavior of this function is undefined unless its control parameter is set to a specific value."},476:{title:"NULL Pointer Dereference",description:"A NULL pointer dereference occurs when the application dereferences a pointer that it expects to be valid, but is NULL, typically causing a crash or exit."},477:{title:"Use of Obsolete Function",description:"The code uses deprecated or obsolete functions, which suggests that the code has not been actively reviewed or maintained."},478:{title:"Missing Default Case in Switch Statement",description:"The code does not have a default case in a switch statement, which might lead to complex logical errors and resultant weaknesses."},479:{title:"Signal Handler Use of a Non-reentrant Function",description:"The program defines a signal handler that calls a non-reentrant function."},480:{title:"Use of Incorrect Operator",description:"The programmer accidentally uses the wrong operator, which changes the application logic in security-relevant ways."},481:{title:"Assigning instead of Comparing",description:"The code uses an operator for assignment when the intention was to perform a comparison."},482:{title:"Comparing instead of Assigning",description:"The code uses an operator for comparison when the intention was to perform an assignment."},483:{title:"Incorrect Block Delimitation",description:"The code does not explicitly delimit a block that is intended to contain 2 or more statements, creating a logic error."},484:{title:"Omitted Break Statement in Switch",description:"The program omits a break statement within a switch or similar construct, causing code associated with multiple conditions to execute. This can cause problems when the programmer only intended to execute code associated with one condition."},486:{title:"Comparison of Classes by Name",description:"The program compares classes by name, which can cause it to use the wrong class when multiple classes can have the same name."},487:{title:"Reliance on Package-level Scope",description:"Java packages are not inherently closed; therefore, relying on them for code security is not a good practice."},488:{title:"Exposure of Data Element to Wrong Session",description:"The product does not sufficiently enforce boundaries between the states of different sessions, causing data to be provided to, or used by, the wrong session."},489:{title:"Leftover Debug Code",description:"The application can be deployed with active debugging code that can create unintended entry points."},491:{title:"Public cloneable() Method Without Final ('Object Hijack')",description:"A class has a cloneable() method that is not declared final, which allows an object to be created without calling the constructor. This can cause the object to be in an unexpected state."},492:{title:"Use of Inner Class Containing Sensitive Data",description:"Inner classes are translated into classes that are accessible at package scope and may expose code that the programmer intended to keep private to attackers."},493:{title:"Critical Public Variable Without Final Modifier",description:"The product has a critical public variable that is not final, which allows the variable to be modified to contain unexpected values."},494:{title:"Download of Code Without Integrity Check",description:"The product downloads source code or an executable from a remote location and executes the code without sufficiently verifying the origin and integrity of the code."},495:{title:"Private Array-Typed Field Returned From A Public Method",description:"The product has a method that is declared public, but returns a reference to a private array, which could then be modified in unexpected ways."},496:{title:"Public Data Assigned to Private Array-Typed Field",description:"Assigning public data to a private array is equivalent to giving public access to the array."},497:{title:"Exposure of System Data to an Unauthorized Control Sphere",description:"Exposing system data or debugging information helps an adversary learn about the system and form an attack plan."},498:{title:"Cloneable Class Containing Sensitive Information",description:"The code contains a class with sensitive data, but the class is cloneable. The data can then be accessed by cloning the class."},499:{title:"Serializable Class Containing Sensitive Data",description:"The code contains a class with sensitive data, but the class does not explicitly deny serialization. The data can be accessed by serializing the class through another class."},500:{title:"Public Static Field Not Marked Final",description:"An object contains a public static field that is not marked final, which might allow it to be modified in unexpected ways."},501:{title:"Trust Boundary Violation",description:"The product mixes trusted and untrusted data in the same data structure or structured message."},502:{title:"Deserialization of Untrusted Data",description:"The application deserializes untrusted data without sufficiently verifying that the resulting data will be valid."},506:{title:"Embedded Malicious Code",description:"The application contains code that appears to be malicious in nature."},507:{title:"Trojan Horse",description:"The software appears to contain benign or useful functionality, but it also contains code that is hidden from normal operation that violates the intended security policy of the user or the system administrator."},508:{title:"Non-Replicating Malicious Code",description:"Non-replicating malicious code only resides on the target system or software that is attacked; it does not attempt to spread to other systems."},509:{title:"Replicating Malicious Code (Virus or Worm)",description:"Replicating malicious code, including viruses and worms, will attempt to attack other systems once it has successfully compromised the target system or software."},510:{title:"Trapdoor",description:"A trapdoor is a hidden piece of code that responds to a special input, allowing its user access to resources without passing through the normal security enforcement mechanism."},511:{title:"Logic/Time Bomb",description:"The software contains code that is designed to disrupt the legitimate operation of the software (or its environment) when a certain time passes, or when a certain logical condition is met."},512:{title:"Spyware",description:"The software collects personally identifiable information about a human user or the user's activities, but the software accesses this information using other resources besides itself, and it does not require that user's explicit approval or direct input into the software."},514:{title:"Covert Channel",description:"A covert channel is a path that can be used to transfer information in a way not intended by the system's designers."},515:{title:"Covert Storage Channel",description:"A covert storage channel transfers information through the setting of bits by one program and the reading of those bits by another. What distinguishes this case from that of ordinary operation is that the bits are used to convey encoded information."},520:{title:".NET Misconfiguration: Use of Impersonation",description:"Allowing a .NET application to run at potentially escalated levels of access to the underlying operating and file systems can be dangerous and result in various forms of attacks."},521:{title:"Weak Password Requirements",description:"The product does not require that users should have strong passwords, which makes it easier for attackers to compromise user accounts."},522:{title:"Insufficiently Protected Credentials",description:"This weakness occurs when the application transmits or stores authentication credentials and uses an insecure method that is susceptible to unauthorized interception and/or retrieval."},523:{title:"Unprotected Transport of Credentials",description:"Login pages not using adequate measures to protect the user name and password while they are in transit from the client to the server."},524:{title:"Information Exposure Through Caching",description:"The application uses a cache to maintain a pool of objects, threads, connections, pages, or passwords to minimize the time it takes to access them or the resources to which they connect. If implemented improperly, these caches can allow access to unauthorized information or cause a denial of service vulnerability."},525:{title:"Information Exposure Through Browser Caching",description:"For each web page, the application should have an appropriate caching policy specifying the extent to which the page and its form fields should be cached."},526:{title:"Information Exposure Through Environmental Variables",description:"Environmental variables may contain sensitive information about a remote server."},527:{title:"Exposure of CVS Repository to an Unauthorized Control Sphere",description:"The product stores a CVS repository in a directory or other container that is accessible to actors outside of the intended control sphere."},528:{title:"Exposure of Core Dump File to an Unauthorized Control Sphere",description:"The product generates a core dump file in a directory that is accessible to actors outside of the intended control sphere."},529:{title:"Exposure of Access Control List Files to an Unauthorized Control Sphere",description:"The product stores access control list files in a directory or other container that is accessible to actors outside of the intended control sphere."},530:{title:"Exposure of Backup File to an Unauthorized Control Sphere",description:"A backup file is stored in a directory that is accessible to actors outside of the intended control sphere."},531:{title:"Information Exposure Through Test Code",description:"Accessible test applications can pose a variety of security risks. Since developers or administrators rarely consider that someone besides themselves would even know about the existence of these applications, it is common for them to contain sensitive information or functions."},532:{title:"Information Exposure Through Log Files",description:"Information written to log files can be of a sensitive nature and give valuable guidance to an attacker or expose sensitive user information."},535:{title:"Information Exposure Through Shell Error Message",description:"A command shell error message indicates that there exists an unhandled exception in the web application code. In many cases, an attacker can leverage the conditions that cause these errors in order to gain unauthorized access to the system."},536:{title:"Information Exposure Through Servlet Runtime Error Message",description:"A servlet error message indicates that there exists an unhandled exception in your web application code and may provide useful information to an attacker."},537:{title:"Information Exposure Through Java Runtime Error Message",description:"In many cases, an attacker can leverage the conditions that cause unhandled exception errors in order to gain unauthorized access to the system."},538:{title:"File and Directory Information Exposure",description:"The product stores sensitive information in files or directories that are accessible to actors outside of the intended control sphere."},539:{title:"Information Exposure Through Persistent Cookies",description:"Persistent cookies are cookies that are stored on the browser's hard drive. This can cause security and privacy issues depending on the information stored in the cookie and how it is accessed."},540:{title:"Information Exposure Through Source Code",description:"Source code on a web server often contains sensitive information and should generally not be accessible to users."},541:{title:"Information Exposure Through Include Source Code",description:"If an include file source is accessible, the file can contain usernames and passwords, as well as sensitive information pertaining to the application and system."},543:{title:"Use of Singleton Pattern Without Synchronization in a Multithreaded Context",description:"The software uses the singleton pattern when creating a resource within a multithreaded environment."},544:{title:"Missing Standardized Error Handling Mechanism",description:"The software does not use a standardized method for handling errors throughout the code, which might introduce inconsistent error handling and resultant weaknesses."},546:{title:"Suspicious Comment",description:"The code contains comments that suggest the presence of bugs, incomplete functionality, or weaknesses."},547:{title:"Use of Hard-coded, Security-relevant Constants",description:"The program uses hard-coded constants instead of symbolic names for security-critical values, which increases the likelihood of mistakes during code maintenance or security policy change."},548:{title:"Information Exposure Through Directory Listing",description:"A directory listing is inappropriately exposed, yielding potentially sensitive information to attackers."},549:{title:"Missing Password Field Masking",description:"The software does not mask passwords during entry, increasing the potential for attackers to observe and capture passwords."},550:{title:"Information Exposure Through Server Error Message",description:"Certain conditions, such as network failure, will cause a server error message to be displayed."},551:{title:"Incorrect Behavior Order: Authorization Before Parsing and Canonicalization",description:"If a web server does not fully parse requested URLs before it examines them for authorization, it may be possible for an attacker to bypass authorization protection."},552:{title:"Files or Directories Accessible to External Parties",description:"Files or directories are accessible in the environment that should not be."},553:{title:"Command Shell in Externally Accessible Directory",description:"A possible shell file exists in /cgi-bin/ or other accessible directories. This is extremely dangerous and can be used by an attacker to execute commands on the web server."},554:{title:"ASP.NET Misconfiguration: Not Using Input Validation Framework",description:"The ASP.NET application does not use an input validation framework."},555:{title:"J2EE Misconfiguration: Plaintext Password in Configuration File",description:"The J2EE application stores a plaintext password in a configuration file."},556:{title:"ASP.NET Misconfiguration: Use of Identity Impersonation",description:"Configuring an ASP.NET application to run with impersonated credentials may give the application unnecessary privileges."},558:{title:"Use of getlogin() in Multithreaded Application",description:"The application uses the getlogin() function in a multithreaded context, potentially causing it to return incorrect values."},560:{title:"Use of umask() with chmod-style Argument",description:"The product calls umask() with an incorrect argument that is specified as if it is an argument to chmod()."},561:{title:"Dead Code",description:"The software contains dead code, which can never be executed."},562:{title:"Return of Stack Variable Address",description:"A function returns the address of a stack variable, which will cause unintended program behavior, typically in the form of a crash."},563:{title:"Assignment to Variable without Use",description:"The variable's value is assigned but never used, making it a dead store."},564:{title:"SQL Injection: Hibernate",description:"Using Hibernate to execute a dynamic SQL statement built with user-controlled input can allow an attacker to modify the statement's meaning or to execute arbitrary SQL commands."},565:{title:"Reliance on Cookies without Validation and Integrity Checking",description:"The application relies on the existence or values of cookies when performing security-critical operations, but it does not properly ensure that the setting is valid for the associated user."},566:{title:"Authorization Bypass Through User-Controlled SQL Primary Key",description:"The software uses a database table that includes records that should not be accessible to an actor, but it executes a SQL statement with a primary key that can be controlled by that actor."},567:{title:"Unsynchronized Access to Shared Data in a Multithreaded Context",description:"The product does not properly synchronize shared data, such as static variables across threads, which can lead to undefined behavior and unpredictable data changes."},568:{title:"finalize() Method Without super.finalize()",description:"The software contains a finalize() method that does not call super.finalize()."},570:{title:"Expression is Always False",description:"The software contains an expression that will always evaluate to false."},571:{title:"Expression is Always True",description:"The software contains an expression that will always evaluate to true."},572:{title:"Call to Thread run() instead of start()",description:"The program calls a thread's run() method instead of calling start(), which causes the code to run in the thread of the caller instead of the callee."},573:{title:"Improper Following of Specification by Caller",description:"The software does not follow or incorrectly follows the specifications as required by the implementation language, environment, framework, protocol, or platform."},574:{title:"EJB Bad Practices: Use of Synchronization Primitives",description:"The program violates the Enterprise JavaBeans (EJB) specification by using thread synchronization primitives."},575:{title:"EJB Bad Practices: Use of AWT Swing",description:"The program violates the Enterprise JavaBeans (EJB) specification by using AWT/Swing."},576:{title:"EJB Bad Practices: Use of Java I/O",description:"The program violates the Enterprise JavaBeans (EJB) specification by using the java.io package."},577:{title:"EJB Bad Practices: Use of Sockets",description:"The program violates the Enterprise JavaBeans (EJB) specification by using sockets."},578:{title:"EJB Bad Practices: Use of Class Loader",description:"The program violates the Enterprise JavaBeans (EJB) specification by using the class loader."},579:{title:"J2EE Bad Practices: Non-serializable Object Stored in Session",description:"The application stores a non-serializable object as an HttpSession attribute, which can hurt reliability."},580:{title:"clone() Method Without super.clone()",description:"The software contains a clone() method that does not call super.clone() to obtain the new object."},581:{title:"Object Model Violation: Just One of Equals and Hashcode Defined",description:"The software does not maintain equal hashcodes for equal objects."},582:{title:"Array Declared Public, Final, and Static",description:"The program declares an array public, final, and static, which is not sufficient to prevent the array's contents from being modified."},583:{title:"finalize() Method Declared Public",description:"The program violates secure coding principles for mobile code by declaring a finalize() method public."},584:{title:"Return Inside Finally Block",description:"The code has a return statement inside a finally block, which will cause any thrown exception in the try block to be discarded."},585:{title:"Empty Synchronized Block",description:"The software contains an empty synchronized block."},586:{title:"Explicit Call to Finalize()",description:"The software makes an explicit call to the finalize() method from outside the finalizer."},587:{title:"Assignment of a Fixed Address to a Pointer",description:"The software sets a pointer to a specific address other than NULL or 0."},588:{title:"Attempt to Access Child of a Non-structure Pointer",description:"Casting a non-structure type to a structure type and accessing a field can lead to memory access errors or data corruption."},589:{title:"Call to Non-ubiquitous API",description:"The software uses an API function that does not exist on all versions of the target platform. This could cause portability problems or inconsistencies that allow denial of service or other consequences."},590:{title:"Free of Memory not on the Heap",description:"The application calls free() on a pointer to memory that was not allocated using associated heap allocation functions such as malloc(), calloc(), or realloc()."},591:{title:"Sensitive Data Storage in Improperly Locked Memory",description:"The application stores sensitive data in memory that is not locked, or that has been incorrectly locked, which might cause the memory to be written to swap files on disk by the virtual memory manager. This can make the data more accessible to external actors."},593:{title:"Authentication Bypass: OpenSSL CTX Object Modified after SSL Objects are Created",description:"The software modifies the SSL context after connection creation has begun."},594:{title:"J2EE Framework: Saving Unserializable Objects to Disk",description:"When the J2EE container attempts to write unserializable objects to disk there is no guarantee that the process will complete successfully."},595:{title:"Comparison of Object References Instead of Object Contents",description:"The program compares object references instead of the contents of the objects themselves, preventing it from detecting equivalent objects."},597:{title:"Use of Wrong Operator in String Comparison",description:"The product uses the wrong operator when comparing a string, such as using == when the equals() method should be used instead."},598:{title:"Information Exposure Through Query Strings in GET Request",description:"The web application uses the GET method to process requests that contain sensitive information, which can expose that information through the browser's history, Referers, web logs, and other sources."},599:{title:"Missing Validation of OpenSSL Certificate",description:"The software uses OpenSSL and trusts or uses a certificate without using the SSL_get_verify_result() function to ensure that the certificate satisfies all necessary security requirements."},600:{title:"Uncaught Exception in Servlet ",description:"The Servlet does not catch all exceptions, which may reveal sensitive debugging information."},601:{title:"URL Redirection to Untrusted Site ('Open Redirect')",description:"A web application accepts a user-controlled input that specifies a link to an external site, and uses that link in a Redirect. This simplifies phishing attacks."},602:{title:"Client-Side Enforcement of Server-Side Security",description:"The software is composed of a server that relies on the client to implement a mechanism that is intended to protect the server."},603:{title:"Use of Client-Side Authentication",description:"A client/server product performs authentication within client code but not in server code, allowing server-side authentication to be bypassed via a modified client that omits the authentication check."},605:{title:"Multiple Binds to the Same Port",description:"When multiple sockets are allowed to bind to the same port, other services on that port may be stolen or spoofed."},606:{title:"Unchecked Input for Loop Condition",description:"The product does not properly check inputs that are used for loop conditions, potentially leading to a denial of service because of excessive looping."},607:{title:"Public Static Final Field References Mutable Object",description:"A public or protected static final field references a mutable object, which allows the object to be changed by malicious code, or accidentally from another package."},608:{title:"Struts: Non-private Field in ActionForm Class",description:"An ActionForm class contains a field that has not been declared private, which can be accessed without using a setter or getter."},609:{title:"Double-Checked Locking",description:"The program uses double-checked locking to access a resource without the overhead of explicit synchronization, but the locking is insufficient."},610:{title:"Externally Controlled Reference to a Resource in Another Sphere",description:"The product uses an externally controlled name or reference that resolves to a resource that is outside of the intended control sphere."},611:{title:"Improper Restriction of XML External Entity Reference ('XXE')",description:"The software processes an XML document that can contain XML entities with URIs that resolve to documents outside of the intended sphere of control, causing the product to embed incorrect documents into its output."},612:{title:"Information Exposure Through Indexing of Private Data",description:"The product performs an indexing routine against private documents, but does not sufficiently verify that the actors who can access the index also have the privileges to access the private documents."},613:{title:"Insufficient Session Expiration",description:"According to WASC, Insufficient Session Expiration is when a web site permits an attacker to reuse old session credentials or session IDs for authorization."},614:{title:"Sensitive Cookie in HTTPS Session Without 'Secure' Attribute",description:"The Secure attribute for sensitive cookies in HTTPS sessions is not set, which could cause the user agent to send those cookies in plaintext over an HTTP session."},615:{title:"Information Exposure Through Comments",description:"While adding general comments is very useful, some programmers tend to leave important data, such as: filenames related to the web application, old links or links which were not meant to be browsed by users, old code fragments, etc."},616:{title:"Incomplete Identification of Uploaded File Variables (PHP)",description:"The PHP application uses an old method for processing uploaded files by referencing the four global variables that are set for each file (e.g. $varname, $varname_size, $varname_name, $varname_type). These variables could be overwritten by attackers, causing the application to process unauthorized files."},617:{title:"Reachable Assertion",description:"The product contains an assert() or similar statement that can be triggered by an attacker, which leads to an application exit or other behavior that is more severe than necessary."},618:{title:"Exposed Unsafe ActiveX Method",description:"An ActiveX control is intended for use in a web browser, but it exposes dangerous methods that perform actions that are outside of the browser's security model (e.g. the zone or domain)."},619:{title:"Dangling Database Cursor ('Cursor Injection')",description:"If a database cursor is not closed properly, then it could become accessible to other users while retaining the same privileges that were originally assigned, leaving the cursor dangling."},620:{title:"Unverified Password Change",description:"When setting a new password for a user, the product does not require knowledge of the original password, or using another form of authentication."},621:{title:"Variable Extraction Error",description:"The product uses external input to determine the names of variables into which information is extracted, without verifying that the names of the specified variables are valid. This could cause the program to overwrite unintended variables."},622:{title:"Improper Validation of Function Hook Arguments",description:"A product adds hooks to user-accessible API functions, but does not properly validate the arguments. This could lead to resultant vulnerabilities."},623:{title:"Unsafe ActiveX Control Marked Safe For Scripting",description:"An ActiveX control is intended for restricted use, but it has been marked as safe-for-scripting."},624:{title:"Executable Regular Expression Error",description:"The product uses a regular expression that either (1) contains an executable component with user-controlled inputs, or (2) allows a user to enable execution by inserting pattern modifiers."},625:{title:"Permissive Regular Expression",description:"The product uses a regular expression that does not sufficiently restrict the set of allowed values."},626:{title:"Null Byte Interaction Error (Poison Null Byte)",description:"The product does not properly handle null bytes or NUL characters when passing data between different representations or components."},627:{title:"Dynamic Variable Evaluation",description:"In a language where the user can influence the name of a variable at runtime, if the variable names are not controlled, an attacker can read or write to arbitrary variables, or access arbitrary functions."},628:{title:"Function Call with Incorrectly Specified Arguments",description:"The product calls a function, procedure, or routine with arguments that are not correctly specified, leading to always-incorrect behavior and resultant weaknesses."},636:{title:"Not Failing Securely ('Failing Open')",description:"When the product encounters an error condition or failure, its design requires it to fall back to a state that is less secure than other options that are available, such as selecting the weakest encryption algorithm or using the most permissive access control restrictions."},637:{title:"Unnecessary Complexity in Protection Mechanism (Not Using 'Economy of Mechanism')",description:"The software uses a more complex mechanism than necessary, which could lead to resultant weaknesses when the mechanism is not correctly understood, modeled, configured, implemented, or used."},638:{title:"Not Using Complete Mediation",description:"The software does not perform access checks on a resource every time the resource is accessed by an entity, which can create resultant weaknesses if that entity's rights or privileges change over time."},639:{title:"Authorization Bypass Through User-Controlled Key",description:"The system's authorization functionality does not prevent one user from gaining access to another user's data or record by modifying the key value identifying the data."},640:{title:"Weak Password Recovery Mechanism for Forgotten Password",description:"The software contains a mechanism for users to recover or change their passwords without knowing the original password, but the mechanism is weak."},641:{title:"Improper Restriction of Names for Files and Other Resources",description:"The application constructs the name of a file or other resource using input from an upstream component, but it does not restrict or incorrectly restricts the resulting name."},642:{title:"External Control of Critical State Data",description:"The software stores security-critical state information about its users, or the software itself, in a location that is accessible to unauthorized actors."},643:{title:"Improper Neutralization of Data within XPath Expressions ('XPath Injection')",description:"The software uses external input to dynamically construct an XPath expression used to retrieve data from an XML database, but it does not neutralize or incorrectly neutralizes that input. This allows an attacker to control the structure of the query."},644:{title:"Improper Neutralization of HTTP Headers for Scripting Syntax",description:"The application does not neutralize or incorrectly neutralizes web scripting syntax in HTTP headers that can be used by web browser components that can process raw headers, such as Flash."},645:{title:"Overly Restrictive Account Lockout Mechanism",description:"The software contains an account lockout protection mechanism, but the mechanism is too restrictive and can be triggered too easily, which allows attackers to deny service to legitimate users by causing their accounts to be locked out."},646:{title:"Reliance on File Name or Extension of Externally-Supplied File",description:"The software allows a file to be uploaded, but it relies on the file name or extension of the file to determine the appropriate behaviors. This could be used by attackers to cause the file to be misclassified and processed in a dangerous fashion."},647:{title:"Use of Non-Canonical URL Paths for Authorization Decisions",description:"The software defines policy namespaces and makes authorization decisions based on the assumption that a URL is canonical. This can allow a non-canonical URL to bypass the authorization."},648:{title:"Incorrect Use of Privileged APIs",description:"The application does not conform to the API requirements for a function call that requires extra privileges. This could allow attackers to gain privileges by causing the function to be called incorrectly."},649:{title:"Reliance on Obfuscation or Encryption of Security-Relevant Inputs without Integrity Checking",description:"The software uses obfuscation or encryption of inputs that should not be mutable by an external actor, but the software does not use integrity checks to detect if those inputs have been modified."},650:{title:"Trusting HTTP Permission Methods on the Server Side",description:"The server contains a protection mechanism that assumes that any URI that is accessed using HTTP GET will not cause a state change to the associated resource. This might allow attackers to bypass intended access restrictions and conduct resource modification and deletion attacks, since some applications allow GET to modify state."},651:{title:"Information Exposure Through WSDL File",description:"The Web services architecture may require exposing a Web Service Definition Language (WSDL) file that contains information on the publicly accessible services and how callers of these services should interact with them (e.g. what parameters they expect and what types they return)."},652:{title:"Improper Neutralization of Data within XQuery Expressions ('XQuery Injection')",description:"The software uses external input to dynamically construct an XQuery expression used to retrieve data from an XML database, but it does not neutralize or incorrectly neutralizes that input. This allows an attacker to control the structure of the query."},653:{title:"Insufficient Compartmentalization",description:"The product does not sufficiently compartmentalize functionality or processes that require different privilege levels, rights, or permissions."},654:{title:"Reliance on a Single Factor in a Security Decision",description:"A protection mechanism relies exclusively, or to a large extent, on the evaluation of a single condition or the integrity of a single object or entity in order to make a decision about granting access to restricted resources or functionality."},655:{title:"Insufficient Psychological Acceptability",description:"The software has a protection mechanism that is too difficult or inconvenient to use, encouraging non-malicious users to disable or bypass the mechanism, whether by accident or on purpose."},656:{title:"Reliance on Security Through Obscurity",description:"The software uses a protection mechanism whose strength depends heavily on its obscurity, such that knowledge of its algorithms or key data is sufficient to defeat the mechanism."},657:{title:"Violation of Secure Design Principles",description:"The product violates well-established principles for secure design."},662:{title:"Improper Synchronization",description:"The software attempts to use a shared resource in an exclusive manner, but does not prevent or incorrectly prevents use of the resource by another thread or process."},663:{title:"Use of a Non-reentrant Function in a Concurrent Context",description:"The software calls a non-reentrant function in a concurrent context in which a competing code sequence (e.g. thread or signal handler) may have an opportunity to call the same function or otherwise influence its state."},664:{title:"Improper Control of a Resource Through its Lifetime",description:"The software does not maintain or incorrectly maintains control over a resource throughout its lifetime of creation, use, and release."},665:{title:"Improper Initialization",description:"The software does not initialize or incorrectly initializes a resource, which might leave the resource in an unexpected state when it is accessed or used."},666:{title:"Operation on Resource in Wrong Phase of Lifetime",description:"The software performs an operation on a resource at the wrong phase of the resource's lifecycle, which can lead to unexpected behaviors."},667:{title:"Improper Locking",description:"The software does not properly acquire a lock on a resource, or it does not properly release a lock on a resource, leading to unexpected resource state changes and behaviors."},668:{title:"Exposure of Resource to Wrong Sphere",description:"The product exposes a resource to the wrong control sphere, providing unintended actors with inappropriate access to the resource."},669:{title:"Incorrect Resource Transfer Between Spheres",description:"The product does not properly transfer a resource/behavior to another sphere, or improperly imports a resource/behavior from another sphere, in a manner that provides unintended control over that resource."},670:{title:"Always-Incorrect Control Flow Implementation",description:"The code contains a control flow path that does not reflect the algorithm that the path is intended to implement, leading to incorrect behavior any time this path is navigated."},671:{title:"Lack of Administrator Control over Security",description:"The product uses security features in a way that prevents the product's administrator from tailoring security settings to reflect the environment in which the product is being used. This introduces resultant weaknesses or prevents it from operating at a level of security that is desired by the administrator."},672:{title:"Operation on a Resource after Expiration or Release",description:"The software uses, accesses, or otherwise operates on a resource after that resource has been expired, released, or revoked."},673:{title:"External Influence of Sphere Definition",description:"The product does not prevent the definition of control spheres from external actors."},674:{title:"Uncontrolled Recursion",description:"The product does not properly control the amount of recursion that takes place, which consumes excessive resources, such as allocated memory or the program stack."},675:{title:"Duplicate Operations on Resource",description:"The product performs the same operation on a resource two or more times, when the operation should only be applied once."},676:{title:"Use of Potentially Dangerous Function",description:"The program invokes a potentially dangerous function that could introduce a vulnerability if it is used incorrectly, but the function can also be used safely."},680:{title:"Integer Overflow to Buffer Overflow",description:"The product performs a calculation to determine how much memory to allocate, but an integer overflow can occur that causes less memory to be allocated than expected, leading to a buffer overflow."},681:{title:"Incorrect Conversion between Numeric Types",description:"When converting from one data type to another, such as long to integer, data can be omitted or translated in a way that produces unexpected values. If the resulting values are used in a sensitive context, then dangerous behaviors may occur."},682:{title:"Incorrect Calculation",description:"The software performs a calculation that generates incorrect or unintended results that are later used in security-critical decisions or resource management."},683:{title:"Function Call With Incorrect Order of Arguments",description:"The software calls a function, procedure, or routine, but the caller specifies the arguments in an incorrect order, leading to resultant weaknesses."},684:{title:"Incorrect Provision of Specified Functionality",description:"The code does not function according to its published specifications, potentially leading to incorrect usage."},685:{title:"Function Call With Incorrect Number of Arguments",description:"The software calls a function, procedure, or routine, but the caller specifies too many arguments, or too few arguments, which may lead to undefined behavior and resultant weaknesses."},686:{title:"Function Call With Incorrect Argument Type",description:"The software calls a function, procedure, or routine, but the caller specifies an argument that is the wrong data type, which may lead to resultant weaknesses."},687:{title:"Function Call With Incorrectly Specified Argument Value",description:"The software calls a function, procedure, or routine, but the caller specifies an argument that contains the wrong value, which may lead to resultant weaknesses."},688:{title:"Function Call With Incorrect Variable or Reference as Argument",description:"The software calls a function, procedure, or routine, but the caller specifies the wrong variable or reference as one of the arguments, which may lead to undefined behavior and resultant weaknesses."},689:{title:"Permission Race Condition During Resource Copy",description:"The product, while copying or cloning a resource, does not set the resource's permissions or access control until the copy is complete, leaving the resource exposed to other spheres while the copy is taking place."},690:{title:"Unchecked Return Value to NULL Pointer Dereference",description:"The product does not check for an error after calling a function that can return with a NULL pointer if the function fails, which leads to a resultant NULL pointer dereference."},691:{title:"Insufficient Control Flow Management",description:"The code does not sufficiently manage its control flow during execution, creating conditions in which the control flow can be modified in unexpected ways."},692:{title:"Incomplete Blacklist to Cross-Site Scripting",description:"The product uses a blacklist-based protection mechanism to defend against XSS attacks, but the blacklist is incomplete, allowing XSS variants to succeed."},693:{title:"Protection Mechanism Failure",description:"The product does not use or incorrectly uses a protection mechanism that provides sufficient defense against directed attacks against the product."},694:{title:"Use of Multiple Resources with Duplicate Identifier",description:"The software uses multiple resources that can have the same identifier, in a context in which unique identifiers are required."},695:{title:"Use of Low-Level Functionality",description:"The software uses low-level functionality that is explicitly prohibited by the framework or specification under which the software is supposed to operate."},696:{title:"Incorrect Behavior Order",description:"The software performs multiple related behaviors, but the behaviors are performed in the wrong order in ways which may produce resultant weaknesses."},697:{title:"Incorrect Comparison",description:"The software compares two entities in a security-relevant context, but the comparison is incorrect, which may lead to resultant weaknesses."},698:{title:"Execution After Redirect (EAR)",description:"The web application sends a redirect to another location, but instead of exiting, it executes additional code."},703:{title:"Improper Check or Handling of Exceptional Conditions",description:"The software does not properly anticipate or handle exceptional conditions that rarely occur during normal operation of the software."},704:{title:"Incorrect Type Conversion or Cast",description:"The software does not correctly convert an object, resource, or structure from one type to a different type."},705:{title:"Incorrect Control Flow Scoping",description:"The software does not properly return control flow to the proper location after it has completed a task or detected an unusual condition."},706:{title:"Use of Incorrectly-Resolved Name or Reference",description:"The software uses a name or reference to access a resource, but the name/reference resolves to a resource that is outside of the intended control sphere."},707:{title:"Improper Enforcement of Message or Data Structure",description:"The software does not enforce or incorrectly enforces that structured messages or data are well-formed before being read from an upstream component or sent to a downstream component."},708:{title:"Incorrect Ownership Assignment",description:"The software assigns an owner to a resource, but the owner is outside of the intended control sphere."},710:{title:"Improper Adherence to Coding Standards",description:"The software does not follow certain coding rules for development, which can lead to resultant weaknesses or increase the severity of the associated vulnerabilities."},732:{title:"Incorrect Permission Assignment for Critical Resource",description:"The software specifies permissions for a security-critical resource in a way that allows that resource to be read or modified by unintended actors."},733:{title:"Compiler Optimization Removal or Modification of Security-critical Code",description:"The developer builds a security-critical protection mechanism into the software, but the compiler optimizes the program such that the mechanism is removed or modified."},749:{title:"Exposed Dangerous Method or Function",description:"The software provides an Applications Programming Interface (API) or similar interface for interaction with external actors, but the interface includes a dangerous method or function that is not properly restricted."},754:{title:"Improper Check for Unusual or Exceptional Conditions",description:"The software does not check or improperly checks for unusual or exceptional conditions that are not expected to occur frequently during day to day operation of the software."},755:{title:"Improper Handling of Exceptional Conditions",description:"The software does not handle or incorrectly handles an exceptional condition."},756:{title:"Missing Custom Error Page",description:"The software does not return custom error pages to the user, possibly exposing sensitive information."},757:{title:"Selection of Less-Secure Algorithm During Negotiation ('Algorithm Downgrade')",description:"A protocol or its implementation supports interaction between multiple actors and allows those actors to negotiate which algorithm should be used as a protection mechanism such as encryption or authentication, but it does not select the strongest algorithm that is available to both parties."},758:{title:"Reliance on Undefined, Unspecified, or Implementation-Defined Behavior",description:"The software uses an API function, data structure, or other entity in a way that relies on properties that are not always guaranteed to hold for that entity."},759:{title:"Use of a One-Way Hash without a Salt",description:"The software uses a one-way cryptographic hash against an input that should not be reversible, such as a password, but the software does not also use a salt as part of the input."},760:{title:"Use of a One-Way Hash with a Predictable Salt",description:"The software uses a one-way cryptographic hash against an input that should not be reversible, such as a password, but the software uses a predictable salt as part of the input."},761:{title:"Free of Pointer not at Start of Buffer",description:"The application calls free() on a pointer to a memory resource that was allocated on the heap, but the pointer is not at the start of the buffer."},762:{title:"Mismatched Memory Management Routines",description:"The application attempts to return a memory resource to the system, but it calls a release function that is not compatible with the function that was originally used to allocate that resource."},763:{title:"Release of Invalid Pointer or Reference",description:"The application attempts to return a memory resource to the system, but calls the wrong release function or calls the appropriate release function incorrectly."},764:{title:"Multiple Locks of a Critical Resource",description:"The software locks a critical resource more times than intended, leading to an unexpected state in the system."},765:{title:"Multiple Unlocks of a Critical Resource",description:"The software unlocks a critical resource more times than intended, leading to an unexpected state in the system."},766:{title:"Critical Variable Declared Public",description:"The software declares a critical variable or field to be public when intended security policy requires it to be private."},767:{title:"Access to Critical Private Variable via Public Method",description:"The software defines a public method that reads or modifies a private variable."},768:{title:"Incorrect Short Circuit Evaluation",description:"The software contains a conditional statement with multiple logical expressions in which one of the non-leading expressions may produce side effects. This may lead to an unexpected state in the program after the execution of the conditional, because short-circuiting logic may prevent the side effects from occurring."},769:{title:"Uncontrolled File Descriptor Consumption",description:"The software does not properly limit the number of open file descriptors that it uses."},770:{title:"Allocation of Resources Without Limits or Throttling",description:"The software allocates a reusable resource or group of resources on behalf of an actor without imposing any restrictions on how many resources can be allocated, in violation of the intended security policy for that actor."},771:{title:"Missing Reference to Active Allocated Resource",description:"The software does not properly maintain a reference to a resource that has been allocated, which prevents the resource from being reclaimed."},772:{title:"Missing Release of Resource after Effective Lifetime",description:"The software does not release a resource after its effective lifetime has ended, i.e., after the resource is no longer needed."},773:{title:"Missing Reference to Active File Descriptor or Handle",description:"The software does not properly maintain references to a file descriptor or handle, which prevents that file descriptor/handle from being reclaimed."},774:{title:"Allocation of File Descriptors or Handles Without Limits or Throttling",description:"The software allocates file descriptors or handles on behalf of an actor without imposing any restrictions on how many descriptors can be allocated, in violation of the intended security policy for that actor."},775:{title:"Missing Release of File Descriptor or Handle after Effective Lifetime",description:"The software does not release a file descriptor or handle after its effective lifetime has ended, i.e., after the file descriptor/handle is no longer needed."},776:{title:"Improper Restriction of Recursive Entity References in DTDs ('XML Entity Expansion')",description:"The software uses XML documents and allows their structure to be defined with a Document Type Definition (DTD), but it does not properly control the number of recursive definitions of entities."},777:{title:"Regular Expression without Anchors",description:"The software uses a regular expression to perform neutralization, but the regular expression is not anchored and may allow malicious or malformed data to slip through."},778:{title:"Insufficient Logging",description:"When a security-critical event occurs, the software either does not record the event or omits important details about the event when logging it."},779:{title:"Logging of Excessive Data",description:"The software logs too much information, making log files hard to process and possibly hindering recovery efforts or forensic analysis after an attack."},780:{title:"Use of RSA Algorithm without OAEP",description:"The software uses the RSA algorithm but does not incorporate Optimal Asymmetric Encryption Padding (OAEP), which might weaken the encryption."},781:{title:"Improper Address Validation in IOCTL with METHOD_NEITHER I/O Control Code",description:"The software defines an IOCTL that uses METHOD_NEITHER for I/O, but it does not validate or incorrectly validates the addresses that are provided."},782:{title:"Exposed IOCTL with Insufficient Access Control",description:"The software implements an IOCTL with functionality that should be restricted, but it does not properly enforce access control for the IOCTL."},783:{title:"Operator Precedence Logic Error",description:"The program uses an expression in which operator precedence causes incorrect logic to be used."},784:{title:"Reliance on Cookies without Validation and Integrity Checking in a Security Decision",description:"The application uses a protection mechanism that relies on the existence or values of a cookie, but it does not properly ensure that the cookie is valid for the associated user."},785:{title:"Use of Path Manipulation Function without Maximum-sized Buffer",description:"The software invokes a function for normalizing paths or file names, but it provides an output buffer that is smaller than the maximum possible size, such as PATH_MAX."},786:{title:"Access of Memory Location Before Start of Buffer",description:"The software reads or writes to a buffer using an index or pointer that references a memory location prior to the beginning of the buffer."},787:{title:"Out-of-bounds Write",description:"The software writes data past the end, or before the beginning, of the intended buffer."},788:{title:"Access of Memory Location After End of Buffer",description:"The software reads or writes to a buffer using an index or pointer that references a memory location after the end of the buffer."},789:{title:"Uncontrolled Memory Allocation",description:"The product allocates memory based on an untrusted size value, but it does not validate or incorrectly validates the size, allowing arbitrary amounts of memory to be allocated."},790:{title:"Improper Filtering of Special Elements",description:"The software receives data from an upstream component, but does not filter or incorrectly filters special elements before sending it to a downstream component."},791:{title:"Incomplete Filtering of Special Elements",description:"The software receives data from an upstream component, but does not completely filter special elements before sending it to a downstream component."},792:{title:"Incomplete Filtering of One or More Instances of Special Elements",description:"The software receives data from an upstream component, but does not completely filter one or more instances of special elements before sending it to a downstream component."},793:{title:"Only Filtering One Instance of a Special Element",description:"The software receives data from an upstream component, but only filters a single instance of a special element before sending it to a downstream component."},794:{title:"Incomplete Filtering of Multiple Instances of Special Elements",description:"The software receives data from an upstream component, but does not filter all instances of a special element before sending it to a downstream component."},795:{title:"Only Filtering Special Elements at a Specified Location",description:"The software receives data from an upstream component, but only accounts for special elements at a specified location, thereby missing remaining special elements that may exist before sending it to a downstream component."},796:{title:"Only Filtering Special Elements Relative to a Marker",description:"The software receives data from an upstream component, but only accounts for special elements positioned relative to a marker (e.g. at the beginning/end of a string; the second argument), thereby missing remaining special elements that may exist before sending it to a downstream component."},797:{title:"Only Filtering Special Elements at an Absolute Position",description:"The software receives data from an upstream component, but only accounts for special elements at an absolute position (e.g. byte number 10), thereby missing remaining special elements that may exist before sending it to a downstream component."},798:{title:"Use of Hard-coded Credentials",description:"The software contains hard-coded credentials, such as a password or cryptographic key, which it uses for its own inbound authentication, outbound communication to external components, or encryption of internal data."},799:{title:"Improper Control of Interaction Frequency",description:"The software does not properly limit the number or frequency of interactions that it has with an actor, such as the number of incoming requests."},804:{title:"Guessable CAPTCHA",description:"The software uses a CAPTCHA challenge, but the challenge can be guessed or automatically recognized by a non-human actor."},805:{title:"Buffer Access with Incorrect Length Value",description:"The software uses a sequential operation to read or write a buffer, but it uses an incorrect length value that causes it to access memory that is outside of the bounds of the buffer."},806:{title:"Buffer Access Using Size of Source Buffer",description:"The software uses the size of a source buffer when reading from or writing to a destination buffer, which may cause it to access memory that is outside of the bounds of the buffer."},807:{title:"Reliance on Untrusted Inputs in a Security Decision",description:"The application uses a protection mechanism that relies on the existence or values of an input, but the input can be modified by an untrusted actor in a way that bypasses the protection mechanism."},820:{title:"Missing Synchronization",description:"The software utilizes a shared resource in a concurrent manner but does not attempt to synchronize access to the resource."},821:{title:"Incorrect Synchronization",description:"The software utilizes a shared resource in a concurrent manner but it does not correctly synchronize access to the resource."},822:{title:"Untrusted Pointer Dereference",description:"The program obtains a value from an untrusted source, converts this value to a pointer, and dereferences the resulting pointer."},823:{title:"Use of Out-of-range Pointer Offset",description:"The program performs pointer arithmetic on a valid pointer, but it uses an offset that can point outside of the intended range of valid memory locations for the resulting pointer."},824:{title:"Access of Uninitialized Pointer",description:"The program accesses or uses a pointer that has not been initialized."},825:{title:"Expired Pointer Dereference",description:"The program dereferences a pointer that contains a location for memory that was previously valid, but is no longer valid."},826:{title:"Premature Release of Resource During Expected Lifetime",description:"The program releases a resource that is still intended to be used by the program itself or another actor."},827:{title:"Improper Control of Document Type Definition",description:"The software does not restrict a reference to a Document Type Definition (DTD) to the intended control sphere. This might allow attackers to reference arbitrary DTDs, possibly causing the software to expose files, consume excessive system resources, or execute arbitrary http requests on behalf of the attacker."},828:{title:"Signal Handler with Functionality that is not Asynchronous-Safe",description:"The software defines a signal handler that contains code sequences that are not asynchronous-safe, i.e., the functionality is not reentrant, or it can be interrupted."},829:{title:"Inclusion of Functionality from Untrusted Control Sphere",description:"The software imports, requires, or includes executable functionality (such as a library) from a source that is outside of the intended control sphere."},830:{title:"Inclusion of Web Functionality from an Untrusted Source",description:"The software includes web functionality (such as a web widget) from another domain, which causes it to operate within the domain of the software, potentially granting total access and control of the software to the untrusted source."},831:{title:"Signal Handler Function Associated with Multiple Signals",description:"The software defines a function that is used as a handler for more than one signal."},832:{title:"Unlock of a Resource that is not Locked",description:"The software attempts to unlock a resource that is not locked."},833:{title:"Deadlock",description:"The software contains multiple threads or executable segments that are waiting for each other to release a necessary lock, resulting in deadlock."},834:{title:"Excessive Iteration",description:"The software performs an iteration or loop without sufficiently limiting the number of times that the loop is executed."},835:{title:"Loop with Unreachable Exit Condition ('Infinite Loop')",description:"The program contains an iteration or loop with an exit condition that cannot be reached, i.e., an infinite loop."},836:{title:"Use of Password Hash Instead of Password for Authentication",description:"The software records password hashes in a data store, receives a hash of a password from a client, and compares the supplied hash to the hash obtained from the data store."},837:{title:"Improper Enforcement of a Single, Unique Action",description:"The software requires that an actor should only be able to perform an action once, or to have only one unique action, but the software does not enforce or improperly enforces this restriction."},838:{title:"Inappropriate Encoding for Output Context",description:"The software uses or specifies an encoding when generating output to a downstream component, but the specified encoding is not the same as the encoding that is expected by the downstream component."},839:{title:"Numeric Range Comparison Without Minimum Check",description:"The program checks a value to ensure that it is less than or equal to a maximum, but it does not also verify that the value is greater than or equal to the minimum."},841:{title:"Improper Enforcement of Behavioral Workflow",description:"The software supports a session in which more than one behavior must be performed by an actor, but it does not properly ensure that the actor performs the behaviors in the required sequence."},842:{title:"Placement of User into Incorrect Group",description:"The software or the administrator places a user into an incorrect group."},843:{title:"Access of Resource Using Incompatible Type ('Type Confusion')",description:"The program allocates or initializes a resource such as a pointer, object, or variable using one type, but it later accesses that resource using a type that is incompatible with the original type."},862:{title:"Missing Authorization",description:"The software does not perform an authorization check when an actor attempts to access a resource or perform an action."},863:{title:"Incorrect Authorization",description:"The software performs an authorization check when an actor attempts to access a resource or perform an action, but it does not correctly perform the check. This allows attackers to bypass intended access restrictions."},908:{title:"Use of Uninitialized Resource",description:"The software uses a resource that has not been properly initialized."},909:{title:"Missing Initialization of Resource",description:"The software does not initialize a critical resource."},910:{title:"Use of Expired File Descriptor",description:"The software uses or accesses a file descriptor after it has been closed."},911:{title:"Improper Update of Reference Count",description:"The software uses a reference count to manage a resource, but it does not update or incorrectly updates the reference count."},912:{title:"Hidden Functionality",description:"The software contains functionality that is not documented, not part of the specification, and not accessible through an interface or command sequence that is obvious to the software's users or administrators."},913:{title:"Improper Control of Dynamically-Managed Code Resources",description:"The software does not properly restrict reading from or writing to dynamically-managed code resources such as variables, objects, classes, attributes, functions, or executable instructions or statements."},914:{title:"Improper Control of Dynamically-Identified Variables",description:"The software does not properly restrict reading from or writing to dynamically-identified variables."},915:{title:"Improperly Controlled Modification of Dynamically-Determined Object Attributes",description:"The software receives input from an upstream component that specifies multiple attributes, properties, or fields that are to be initialized or updated in an object, but it does not properly control which attributes can be modified."},916:{title:"Use of Password Hash With Insufficient Computational Effort",description:"The software generates a hash for a password, but it uses a scheme that does not provide a sufficient level of computational effort that would make password cracking attacks infeasible or expensive."},917:{title:"Improper Neutralization of Special Elements used in an Expression Language Statement ('Expression Language Injection')",description:"The software constructs all or part of an expression language (EL) statement in a Java Server Page (JSP) using externally-influenced input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could modify the intended EL statement before it is executed."},918:{title:"Server-Side Request Forgery (SSRF)",description:"The web server receives a URL or similar request from an upstream component and retrieves the contents of this URL, but it does not sufficiently ensure that the request is being sent to the expected destination."},920:{title:"Improper Restriction of Power Consumption",description:"The software operates in an environment in which power is a limited resource that cannot be automatically replenished, but the software does not properly restrict the amount of power that its operation consumes."},921:{title:"Storage of Sensitive Data in a Mechanism without Access Control",description:"The software stores sensitive information in a file system or device that does not have built-in access control."},922:{title:"Insecure Storage of Sensitive Information",description:"The software stores sensitive information without properly limiting read or write access by unauthorized actors."},923:{title:"Improper Restriction of Communication Channel to Intended Endpoints",description:"The software establishes a communication channel to (or from) an endpoint for privileged or protected operations, but it does not properly ensure that it is communicating with the correct endpoint."},924:{title:"Improper Enforcement of Message Integrity During Transmission in a Communication Channel",description:"The software establishes a communication channel with an endpoint and receives a message from that endpoint, but it does not sufficiently ensure that the message was not modified during transmission."},925:{title:"Improper Verification of Intent by Broadcast Receiver",description:"The Android application uses a Broadcast Receiver that receives an Intent but does not properly verify that the Intent came from an authorized source."},926:{title:"Improper Export of Android Application Components",description:"The Android application exports a component for use by other applications, but does not properly restrict which applications can launch the component or access the data it contains."},927:{title:"Use of Implicit Intent for Sensitive Communication",description:"The Android application uses an implicit intent for transmitting sensitive data to other applications."},939:{title:"Improper Authorization in Handler for Custom URL Scheme",description:"The software uses a handler for a custom URL scheme, but it does not properly restrict which actors can invoke the handler using the scheme."},940:{title:"Improper Verification of Source of a Communication Channel",description:"The software establishes a communication channel to handle an incoming request that has been initiated by an actor, but it does not properly verify that the request is coming from the expected origin."},941:{title:"Incorrectly Specified Destination in a Communication Channel",description:"The software creates a communication channel to initiate an outgoing request to an actor, but it does not correctly specify the intended destination for that actor."},942:{title:"Overly Permissive Cross-domain Whitelist",description:"The software uses a cross-domain policy file that includes domains that should not be trusted."},943:{title:"Improper Neutralization of Special Elements in Data Query Logic",description:"The application generates a query intended to access or manipulate data in a data store such as a database, but it does not neutralize or incorrectly neutralizes special elements that can modify the intended logic of the query."},1004:{title:"Sensitive Cookie Without 'HttpOnly' Flag",description:"The software uses a cookie to store sensitive information, but the cookie is not marked with the HttpOnly flag."},1007:{title:"Insufficient Visual Distinction of Homoglyphs Presented to User",description:"The software displays information or identifiers to a user, but the display mechanism does not make it easy for the user to distinguish between visually similar or identical glyphs (homoglyphs), which may cause the user to misinterpret a glyph and perform an unintended, insecure action."},1021:{title:"Improper Restriction of Rendered UI Layers or Frames",description:"The web application does not restrict or incorrectly restricts frame objects or UI layers that belong to another application or domain, which can lead to user confusion about which interface the user is interacting with."},1022:{title:"Use of Web Link to Untrusted Target with window.opener Access",description:"The web application produces links to untrusted external sites outside of its sphere of control, but it does not properly prevent the external site from modifying security-critical properties of the window.opener object, such as the location property."},1023:{title:"Incomplete Comparison with Missing Factors",description:"The software performs a comparison between entities that must consider multiple factors or characteristics of each entity, but the comparison does not include one or more of these factors. This can lead to resultant weaknesses, e.g. by operating on the wrong object."},1024:{title:"Comparison of Incompatible Types",description:"The software performs a comparison between two entities, but the entities are of different, incompatible types that cannot be guaranteed to provide correct results when they are directly compared."},1025:{title:"Comparison Using Wrong Factors",description:"The software performs a comparison between two entities, but the comparison examines the wrong factors or characteristics of the entities, which can lead to incorrect results and resultant weaknesses."},1037:{title:"Processor Optimization Removal or Modification of Security-critical Code",description:"The developer builds a security-critical protection mechanism into the software, but the processor optimizes the execution of the program such that the mechanism is removed or modified."},1038:{title:"Insecure Automated Optimizations",description:"The product uses a mechanism that automatically optimizes code, e.g. to improve a characteristic such as performance, but the optimizations can have an unintended side effect that might violate an intended security assumption."},1039:{title:"Automated Recognition Mechanism with Inadequate Detection or Handling of Adversarial Input Perturbations",description:"The product uses an automated mechanism such as machine learning to recognize complex data inputs (e.g. image or audio) as a particular concept or category, but it does not properly detect or handle inputs that have been modified or constructed in a way that causes the mechanism to detect a different, incorrect concept."},unknown:{title:"No CWE associated"}},sonarsourceSecurity:{"sql-injection":{title:"SQL Injection"},rce:{title:"Code Injection (RCE)"},"object-injection":{title:"Object Injection"},"command-injection":{title:"Command Injection"},"path-traversal-injection":{title:"Path Traversal Injection"},"ldap-injection":{title:"LDAP Injection"},"xpath-injection":{title:"XPath Injection"},"expression-lang-injection":{title:"Expression Language Injection"},"log-injection":{title:"Log Injection"},xxe:{title:"XML External Entity (XXE)"},xss:{title:"Cross-Site Scripting (XSS)"},dos:{title:"Denial of Service (DoS)"},ssrf:{title:"Server-Side Request Forgery (SSRF)"},csrf:{title:"Cross-Site Request Forgery (CSRF)"},"http-response-splitting":{title:"HTTP Response Splitting"},"open-redirect":{title:"Open Redirect"},"weak-cryptography":{title:"Weak Cryptography"},auth:{title:"Authentication"},"insecure-conf":{title:"Insecure Configuration"},"file-manipulation":{title:"File Manipulation"},others:{title:"Others"}}}}}]);
//# sourceMappingURL=383.1614590212146.chunk.js.map