/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import org.mozilla.jss.netscape.security.util.ASN1CharStrConvMap;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.AVAValueConverter;

public class DirStrConverter
implements AVAValueConverter {
    private static byte[] DefEncodingOrder = new byte[]{12, 19, 20, 28};

    public static synchronized void setDefEncodingOrder(byte[] defEncodingOrder) {
        DefEncodingOrder = defEncodingOrder;
    }

    @Override
    public DerValue getValue(String ds) throws IOException {
        return this.getValue(ds, DefEncodingOrder);
    }

    @Override
    public DerValue getValue(String valueString, byte[] tags) throws IOException {
        if (tags == null || tags.length == 0) {
            tags = DefEncodingOrder;
        }
        for (int i = 0; i < tags.length; ++i) {
            try {
                CharsetEncoder encoder = ASN1CharStrConvMap.getDefault().getEncoder(tags[i]);
                if (encoder == null) continue;
                CharBuffer charBuffer = CharBuffer.wrap(valueString.toCharArray());
                ByteBuffer byteBuffer = encoder.encode(charBuffer);
                return new DerValue(tags[i], byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit());
            }
            catch (CharacterCodingException e) {
                // empty catch block
            }
        }
        throw new IOException("Cannot convert the directory string value to a ASN.1 type");
    }

    @Override
    public DerValue getValue(byte[] berByteStream) throws IOException {
        DerValue value = new DerValue(berByteStream);
        return value;
    }

    @Override
    public String getAsString(DerValue avaValue) throws IOException {
        return avaValue.getASN1CharString();
    }
}

