/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.primitive;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.spec.IvParameterSpec;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.IllegalBlockSizeException;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.KeyWrapper;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.PBEKeyGenParams;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.PBEParameter;
import org.mozilla.jss.pkix.primitive.PrivateKeyInfo;
import org.mozilla.jss.util.Password;

public class EncryptedPrivateKeyInfo
implements ASN1Value {
    private AlgorithmIdentifier encryptionAlgorithm;
    private OCTET_STRING encryptedData;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public AlgorithmIdentifier getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public OCTET_STRING getEncryptedData() {
        return this.encryptedData;
    }

    public EncryptedPrivateKeyInfo(AlgorithmIdentifier encryptionAlgorithm, OCTET_STRING encryptedData) {
        if (encryptionAlgorithm == null || encryptedData == null) {
            throw new IllegalArgumentException("EncryptedPrivateKeyInfo parameter is null");
        }
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.encryptedData = encryptedData;
        this.sequence = new SEQUENCE();
        this.sequence.addElement(encryptionAlgorithm);
        this.sequence.addElement(encryptedData);
    }

    public static EncryptedPrivateKeyInfo createPBE(PBEAlgorithm pbeAlg, Password password, byte[] salt, int iterationCount, KeyGenerator.CharToByteConverter charToByteConverter, PrivateKeyInfo pki) throws NotInitializedException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, TokenException, CharConversionException {
        try {
            CryptoManager cman = CryptoManager.getInstance();
            CryptoToken token = cman.getInternalCryptoToken();
            KeyGenerator kg = token.getKeyGenerator(pbeAlg);
            PBEKeyGenParams pbekgParams = new PBEKeyGenParams(password, salt, iterationCount);
            if (charToByteConverter != null) {
                kg.setCharToByteConverter(charToByteConverter);
            }
            kg.initialize(pbekgParams);
            SymmetricKey key = kg.generate();
            EncryptionAlgorithm encAlg = pbeAlg.getEncryptionAlg();
            IVParameterSpec params = null;
            Class<?>[] paramClasses = encAlg.getParameterClasses();
            for (int i = 0; i < paramClasses.length; ++i) {
                if (!paramClasses[i].equals(IvParameterSpec.class)) continue;
                params = new IVParameterSpec(kg.generatePBE_IV());
                break;
            }
            Cipher cipher = token.getCipherContext(encAlg);
            cipher.initEncrypt(key, params);
            byte[] encrypted = cipher.doFinal(Cipher.pad(ASN1Util.encode(pki), encAlg.getBlockSize()));
            PBEParameter pbeParam = new PBEParameter(salt, iterationCount);
            AlgorithmIdentifier encAlgID = new AlgorithmIdentifier(pbeAlg.toOID(), pbeParam);
            EncryptedPrivateKeyInfo epki = new EncryptedPrivateKeyInfo(encAlgID, new OCTET_STRING(encrypted));
            return epki;
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException("IllegalBlockSizeException in EncryptedContentInfo.createPBE: " + e.getMessage(), e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException("BadPaddingException in EncryptedContentInfo.createPBE: " + e.getMessage(), e);
        }
    }

    public static EncryptedPrivateKeyInfo createPBES2(int saltLen, int kdfIterations, EncryptionAlgorithm encAlg, Password pwd, KeyGenerator.CharToByteConverter charToByteConverter, PrivateKeyInfo privateKeyInfo) throws NotInitializedException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, TokenException, CharConversionException {
        if (encAlg == null) {
            throw new IllegalArgumentException("encAlg cannot be null");
        }
        if (pwd == null) {
            throw new IllegalArgumentException("pwd cannot be null");
        }
        if (privateKeyInfo == null) {
            throw new IllegalArgumentException("privateKeyInfo cannot be null");
        }
        if (kdfIterations < 1) {
            kdfIterations = 2000;
        }
        if (saltLen < 1) {
            saltLen = 16;
        }
        try {
            SecureRandom random = new SecureRandom();
            byte[] salt = new byte[saltLen];
            random.nextBytes(salt);
            CryptoManager cm = CryptoManager.getInstance();
            CryptoToken token = cm.getInternalCryptoToken();
            KeyGenerator kg = token.getKeyGenerator(PBEAlgorithm.PBE_PKCS5_PBKDF2);
            PBEKeyGenParams pbekgParams = new PBEKeyGenParams(pwd.getChars(), salt, kdfIterations, encAlg);
            if (charToByteConverter != null) {
                kg.setCharToByteConverter(charToByteConverter);
            }
            kg.initialize(pbekgParams);
            SymmetricKey sk = kg.generate();
            byte[] iv = new byte[encAlg.getBlockSize()];
            random.nextBytes(iv);
            Cipher cipher = token.getCipherContext(encAlg);
            cipher.initEncrypt(sk, new IVParameterSpec(iv));
            byte[] encData = cipher.doFinal(ASN1Util.encode(privateKeyInfo));
            SEQUENCE paramsKdf = new SEQUENCE();
            paramsKdf.addElement(new OCTET_STRING(salt));
            paramsKdf.addElement(new INTEGER(kdfIterations));
            paramsKdf.addElement(new INTEGER(sk.getLength()));
            AlgorithmIdentifier algIdKdf = new AlgorithmIdentifier(PBEAlgorithm.PBE_PKCS5_PBKDF2.toOID(), paramsKdf);
            AlgorithmIdentifier algIdEnc = new AlgorithmIdentifier(encAlg.toOID(), new OCTET_STRING(iv));
            SEQUENCE paramsPBES2 = new SEQUENCE();
            paramsPBES2.addElement(algIdKdf);
            paramsPBES2.addElement(algIdEnc);
            AlgorithmIdentifier algIdPBES2 = new AlgorithmIdentifier(PBEAlgorithm.PBE_PKCS5_PBES2.toOID(), paramsPBES2);
            return new EncryptedPrivateKeyInfo(algIdPBES2, new OCTET_STRING(encData));
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException("IllegalBlockSizeException in EncryptedContentInfo.createPBES2: " + e.getMessage(), e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException("BadPaddingException in EncryptedContentInfo.createPBES2: " + e.getMessage(), e);
        }
    }

    public static EncryptedPrivateKeyInfo createPBE(PBEAlgorithm pbeAlg, Password password, byte[] salt, int iterationCount, KeyGenerator.CharToByteConverter charToByteConverter, PrivateKey pri, CryptoToken token) throws NotInitializedException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, TokenException, CharConversionException {
        try {
            KeyGenerator kg = token.getKeyGenerator(pbeAlg);
            PBEKeyGenParams pbekgParams = new PBEKeyGenParams(password, salt, iterationCount);
            if (charToByteConverter != null) {
                kg.setCharToByteConverter(charToByteConverter);
            }
            kg.initialize(pbekgParams);
            kg.temporaryKeys(true);
            SymmetricKey key = kg.generate();
            EncryptionAlgorithm encAlg = pbeAlg.getEncryptionAlg();
            IVParameterSpec params = null;
            Class<?>[] paramClasses = encAlg.getParameterClasses();
            for (int i = 0; i < paramClasses.length; ++i) {
                if (!paramClasses[i].equals(IvParameterSpec.class)) continue;
                params = new IVParameterSpec(kg.generatePBE_IV());
                break;
            }
            KeyWrapper wrapper = token.getKeyWrapper(KeyWrapAlgorithm.fromOID(encAlg.toOID()));
            wrapper.initWrap(key, params);
            byte[] encrypted = wrapper.wrap(pri);
            PBEParameter pbeParam = new PBEParameter(salt, iterationCount);
            AlgorithmIdentifier encAlgID = new AlgorithmIdentifier(pbeAlg.toOID(), pbeParam);
            EncryptedPrivateKeyInfo epki = new EncryptedPrivateKeyInfo(encAlgID, new OCTET_STRING(encrypted));
            return epki;
        }
        catch (Exception e) {
            System.out.println("createPBE: exception:" + e.toString());
            throw new RuntimeException("Exception in EncryptedPrivateKeyInfo.createPBE: " + e.getMessage(), e);
        }
    }

    public PrivateKeyInfo decrypt(Password pass, KeyGenerator.CharToByteConverter charToByteConverter) throws NotInitializedException, NoSuchAlgorithmException, InvalidBERException, InvalidKeyException, InvalidAlgorithmParameterException, TokenException, IllegalBlockSizeException, BadPaddingException, CharConversionException {
        PBEParameter pbeParams;
        AlgorithmIdentifier algid = this.encryptionAlgorithm;
        KeyGenAlgorithm kgAlg = KeyGenAlgorithm.fromOID(algid.getOID());
        if (!(kgAlg instanceof PBEAlgorithm)) {
            throw new NoSuchAlgorithmException("KeyGenAlgorithm is not a PBE algorithm");
        }
        ASN1Value params = algid.getParameters();
        if (params == null) {
            throw new InvalidAlgorithmParameterException("PBE algorithms require parameters");
        }
        if (params instanceof PBEParameter) {
            pbeParams = (PBEParameter)params;
        } else {
            byte[] encodedParams = ASN1Util.encode(params);
            pbeParams = (PBEParameter)ASN1Util.decode(PBEParameter.getTemplate(), encodedParams);
        }
        PBEKeyGenParams kgp = new PBEKeyGenParams(pass, pbeParams.getSalt(), pbeParams.getIterations());
        CryptoToken token = CryptoManager.getInstance().getInternalCryptoToken();
        KeyGenerator kg = token.getKeyGenerator(kgAlg);
        if (charToByteConverter != null) {
            kg.setCharToByteConverter(charToByteConverter);
        }
        kg.initialize(kgp);
        SymmetricKey key = kg.generate();
        EncryptionAlgorithm encAlg = ((PBEAlgorithm)kgAlg).getEncryptionAlg();
        IVParameterSpec algParams = null;
        Class<?>[] paramClasses = encAlg.getParameterClasses();
        for (int i = 0; i < paramClasses.length; ++i) {
            if (!paramClasses[i].equals(IvParameterSpec.class)) continue;
            algParams = new IVParameterSpec(kg.generatePBE_IV());
            break;
        }
        Cipher cipher = token.getCipherContext(encAlg);
        cipher.initDecrypt(key, algParams);
        byte[] decrypted = Cipher.unPad(cipher.doFinal(this.encryptedData.toByteArray()));
        return (PrivateKeyInfo)ASN1Util.decode(PrivateKeyInfo.getTemplate(), decrypted);
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.sequence.encode(ostream);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addElement(OCTET_STRING.getTemplate());
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            return new EncryptedPrivateKeyInfo((AlgorithmIdentifier)seq.elementAt(0), (OCTET_STRING)seq.elementAt(1));
        }
    }
}

