/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.profile;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.netscape.certsrv.util.JSONSerializer;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProfileDataInfo
implements JSONSerializer {
    protected String profileURL;
    protected String profileId;
    protected String profileName;
    protected String profileDescription;

    public String getProfileURL() {
        return this.profileURL;
    }

    public void setProfileURL(String profileURL) {
        this.profileURL = profileURL;
    }

    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getProfileDescription() {
        return this.profileDescription;
    }

    public void setProfileDescription(String profileDescription) {
        this.profileDescription = profileDescription;
    }

    public int hashCode() {
        return Objects.hash(this.profileDescription, this.profileId, this.profileName, this.profileURL);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProfileDataInfo other = (ProfileDataInfo)obj;
        return Objects.equals(this.profileDescription, other.profileDescription) && Objects.equals(this.profileId, other.profileId) && Objects.equals(this.profileName, other.profileName) && Objects.equals(this.profileURL, other.profileURL);
    }

    public Element toDOM(Document document) {
        Element profileDataInfoElement = document.createElement("ProfileDataInfo");
        if (this.profileURL != null) {
            Element profileURLElement = document.createElement("profileURL");
            profileURLElement.appendChild(document.createTextNode(this.profileURL));
            profileDataInfoElement.appendChild(profileURLElement);
        }
        if (this.profileId != null) {
            Element profileIdElement = document.createElement("profileId");
            profileIdElement.appendChild(document.createTextNode(this.profileId));
            profileDataInfoElement.appendChild(profileIdElement);
        }
        if (this.profileName != null) {
            Element profileNameElement = document.createElement("profileName");
            profileNameElement.appendChild(document.createTextNode(this.profileName));
            profileDataInfoElement.appendChild(profileNameElement);
        }
        if (this.profileDescription != null) {
            Element profileDescriptionElement = document.createElement("profileDescription");
            profileDescriptionElement.appendChild(document.createTextNode(this.profileDescription));
            profileDataInfoElement.appendChild(profileDescriptionElement);
        }
        return profileDataInfoElement;
    }

    public static ProfileDataInfo fromDOM(Element profileDataInfoElement) {
        NodeList profileDescriptionList;
        NodeList profileNameList;
        NodeList profileIdList;
        ProfileDataInfo profileDataInfo = new ProfileDataInfo();
        NodeList profileURLList = profileDataInfoElement.getElementsByTagName("profileURL");
        if (profileURLList.getLength() > 0) {
            profileDataInfo.setProfileURL(profileURLList.item(0).getTextContent());
        }
        if ((profileIdList = profileDataInfoElement.getElementsByTagName("profileId")).getLength() > 0) {
            profileDataInfo.setProfileId(profileIdList.item(0).getTextContent());
        }
        if ((profileNameList = profileDataInfoElement.getElementsByTagName("profileName")).getLength() > 0) {
            profileDataInfo.setProfileName(profileNameList.item(0).getTextContent());
        }
        if ((profileDescriptionList = profileDataInfoElement.getElementsByTagName("profileDescription")).getLength() > 0) {
            profileDataInfo.setProfileDescription(profileDescriptionList.item(0).getTextContent());
        }
        return profileDataInfo;
    }

    public String toXML() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element profileParameterElement = this.toDOM(document);
        document.appendChild(profileParameterElement);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource domSource = new DOMSource(document);
        StringWriter sw = new StringWriter();
        StreamResult streamResult = new StreamResult(sw);
        transformer.transform(domSource, streamResult);
        return sw.toString();
    }

    public static ProfileDataInfo fromXML(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        Element profileParameterElement = document.getDocumentElement();
        return ProfileDataInfo.fromDOM(profileParameterElement);
    }
}

