/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.csadmin;

import com.netscape.certsrv.base.SecurityDomainSessionTable;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.base.UserInfo;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmsutil.xml.XMLObject;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class TokenAuthenticate
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(TokenAuthenticate.class);
    private static final long serialVersionUID = -9098593390260940853L;
    private static final String SUCCESS = "0";

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
    }

    @Override
    protected void process(CMSRequest cmsReq) throws Exception {
        HttpServletRequest httpReq = cmsReq.getHttpReq();
        HttpServletResponse httpResp = cmsReq.getHttpResp();
        CMSEngine engine = this.getCMSEngine();
        EngineConfig config = engine.getConfig();
        String sessionId = httpReq.getParameter("sessionID");
        logger.debug("TokenAuthentication: sessionId=" + sessionId);
        String givenHost = httpReq.getParameter("hostname");
        logger.debug("TokenAuthentication: givenHost=" + givenHost);
        boolean checkIP = false;
        try {
            checkIP = config.getBoolean("securitydomain.checkIP", false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SecurityDomainSessionTable table = engine.getSecurityDomainSessionTable();
        String uid = "";
        String gid = "";
        logger.debug("TokenAuthentication: checking session in the session table");
        if (table == null) {
            logger.error("TokenAuthentication: session table is null");
            this.outputError(httpResp, "Error: session table is null");
            return;
        }
        if (table.sessionExists(sessionId)) {
            String hostname;
            logger.debug("TokenAuthentication: found session");
            if (checkIP && !(hostname = table.getIP(sessionId)).equals(givenHost)) {
                logger.error("TokenAuthentication: hostname=" + hostname + " and givenHost=" + givenHost + " are different");
                logger.error("TokenAuthenticate authenticate failed, wrong hostname.");
                this.outputError(httpResp, "Error: Failed Authentication");
                return;
            }
        } else {
            logger.error("TokenAuthentication: session not found");
            logger.error("TokenAuthentication authenticate failed, session id does not exist.");
            this.outputError(httpResp, "Error: Failed Authentication");
            return;
        }
        uid = table.getUID(sessionId);
        gid = table.getGroup(sessionId);
        logger.debug("TokenAuthenticate successfully authenticate");
        try {
            XMLObject xmlObj = null;
            xmlObj = new XMLObject();
            Node root = xmlObj.createRoot("XMLResponse");
            xmlObj.addItemToContainer(root, "Status", SUCCESS);
            xmlObj.addItemToContainer(root, "uid", uid);
            xmlObj.addItemToContainer(root, "gid", gid);
            byte[] cb = xmlObj.toByteArray();
            this.outputResult(httpResp, "application/xml", cb);
        }
        catch (Exception e) {
            logger.warn("Failed to send the XML output");
        }
    }

    @Override
    protected void renderResult(CMSRequest cmsReq) throws IOException {
    }

    @Override
    protected Locale getLocale(HttpServletRequest req) {
        Locale locale = null;
        String lang = req.getHeader("accept-language");
        locale = lang == null ? Locale.getDefault() : new Locale(UserInfo.getUserLanguage(lang), UserInfo.getUserCountry(lang));
        return locale;
    }
}

