/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.request;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.DBAttrMapper;
import com.netscape.certsrv.dbs.IDBObj;
import com.netscape.certsrv.request.RequestId;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.dbs.BigIntegerMapper;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestIdMapper
extends DBAttrMapper {
    public static Logger logger = LoggerFactory.getLogger(RequestIdMapper.class);
    protected static final Vector<String> mAttrs = new Vector();

    @Override
    public Enumeration<String> getSupportedLDAPAttributeNames() {
        return mAttrs.elements();
    }

    @Override
    public void mapObjectToLDAPAttributeSet(IDBObj parent, String name, Object obj, LDAPAttributeSet attrs) throws EBaseException {
        if (obj == null) {
            throw new EBaseException(CMS.getUserMessage("CMS_DBS_SERIALIZE_FAILED", name));
        }
        RequestId rid = (RequestId)obj;
        logger.debug("RequestIdMapper: Mapping " + name + " to requestId");
        String v = BigIntegerMapper.BigIntegerToDB(new BigInteger(rid.toString()));
        attrs.add(new LDAPAttribute("requestId", v));
    }

    @Override
    public void mapLDAPAttributeSetToObject(LDAPAttributeSet attrs, String name, IDBObj parent) throws EBaseException {
        LDAPAttribute attr = attrs.getAttribute("requestId");
        if (attr == null) {
            throw new EBaseException("Missing LDAP attribute: requestId");
        }
        String value = (String)attr.getStringValues().nextElement();
        parent.set(name, new RequestId(BigIntegerMapper.BigIntegerFromDB(value).toString()));
    }

    @Override
    public String mapSearchFilter(String name, String op, String value) throws EBaseException {
        String v;
        try {
            v = BigIntegerMapper.BigIntegerToDB(new BigInteger(value));
        }
        catch (NumberFormatException e) {
            v = value;
        }
        return "requestId" + op + v;
    }

    static {
        mAttrs.add("requestId");
    }
}

