/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.core.policy;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.apps.CMS;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import org.dogtagpki.legacy.policy.IGeneralNameUtil;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.DNSName;
import org.mozilla.jss.netscape.security.x509.EDIPartyName;
import org.mozilla.jss.netscape.security.x509.GeneralName;
import org.mozilla.jss.netscape.security.x509.GeneralNameInterface;
import org.mozilla.jss.netscape.security.x509.IPAddressName;
import org.mozilla.jss.netscape.security.x509.InvalidIPAddressException;
import org.mozilla.jss.netscape.security.x509.OIDName;
import org.mozilla.jss.netscape.security.x509.RFC822Name;
import org.mozilla.jss.netscape.security.x509.URIName;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralNameUtil
implements IGeneralNameUtil {
    public static Logger logger = LoggerFactory.getLogger(GeneralNameUtil.class);
    static final String DOT = ".";

    public static GeneralName form_GeneralNameAsConstraints(String generalNameChoice, String value) throws EBaseException {
        try {
            if (generalNameChoice.equalsIgnoreCase("iPAddress")) {
                StringTokenizer st = new StringTokenizer(value, ",");
                String ip = st.nextToken();
                String netmask = null;
                if (st.hasMoreTokens()) {
                    netmask = st.nextToken();
                }
                return new GeneralName((GeneralNameInterface)new IPAddressName(ip, netmask));
            }
            return GeneralNameUtil.form_GeneralName(generalNameChoice, value);
        }
        catch (InvalidIPAddressException e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_IP_ADDR", value));
        }
    }

    public static GeneralName form_GeneralName(String generalNameChoice, String value) throws EBaseException {
        GeneralName generalName;
        DerValue derVal;
        RFC822Name generalNameI;
        block16: {
            generalNameI = null;
            derVal = null;
            generalName = null;
            try {
                if (generalNameChoice.equalsIgnoreCase("otherName")) {
                    byte[] val = Utils.base64decode((String)value);
                    derVal = new DerValue((InputStream)new ByteArrayInputStream(val));
                    logger.trace("otherName formed");
                    break block16;
                }
                if (generalNameChoice.equalsIgnoreCase("rfc822Name")) {
                    generalNameI = new RFC822Name(value);
                    logger.trace("rfc822Name formed ");
                    break block16;
                }
                if (generalNameChoice.equalsIgnoreCase("dNSName")) {
                    generalNameI = new DNSName(value);
                    logger.trace("dnsName formed");
                    break block16;
                }
                if (generalNameChoice.equalsIgnoreCase("directoryName")) {
                    generalNameI = new X500Name(value);
                    logger.trace("X500Name formed");
                    break block16;
                }
                if (generalNameChoice.equalsIgnoreCase("ediPartyName")) {
                    generalNameI = new EDIPartyName(value);
                    logger.trace("ediPartyName formed");
                    break block16;
                }
                if (generalNameChoice.equalsIgnoreCase("URL")) {
                    generalNameI = new URIName(value);
                    logger.trace("url formed");
                    break block16;
                }
                if (generalNameChoice.equalsIgnoreCase("iPAddress")) {
                    generalNameI = new IPAddressName(value);
                    logger.trace("ipaddress formed");
                    break block16;
                }
                if (generalNameChoice.equalsIgnoreCase("OID")) {
                    ObjectIdentifier oid;
                    try {
                        oid = new ObjectIdentifier(value);
                    }
                    catch (Exception e) {
                        throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_VALUE_FOR_TYPE", generalNameChoice, "value must be a valid OID in the form n.n.n.n"));
                    }
                    generalNameI = new OIDName(oid);
                    logger.trace("oidname formed");
                    break block16;
                }
                throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_ATTR_VALUE", "generalNameChoice", "value must be one of: otherName, rfc822Name, dNSName, directoryName, ediPartyName, URL, iPAddress, or OID."));
            }
            catch (IOException e) {
                logger.error("GeneralNameUtil: " + e.getMessage(), (Throwable)e);
                throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_VALUE_FOR_TYPE", generalNameChoice, e.toString()));
            }
            catch (InvalidIPAddressException e) {
                logger.error("GeneralNameUtil: " + e.getMessage(), (Throwable)e);
                throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_IP_ADDR", value));
            }
            catch (RuntimeException e) {
                logger.error("GeneralNameUtil: " + e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        try {
            generalName = generalNameI != null ? new GeneralName((GeneralNameInterface)generalNameI) : new GeneralName(derVal);
            logger.trace("general name formed");
            return generalName;
        }
        catch (IOException e) {
            logger.error("GeneralNameUtil: " + e.getMessage(), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INTERNAL_ERROR", "Could not form GeneralName. Error: " + e));
        }
    }

    public static String check_GeneralNameChoice(String generalNameChoice) throws EBaseException {
        String theGeneralNameChoice = null;
        if (generalNameChoice.equalsIgnoreCase("otherName")) {
            theGeneralNameChoice = "otherName";
        } else if (generalNameChoice.equalsIgnoreCase("rfc822Name")) {
            theGeneralNameChoice = "rfc822Name";
        } else if (generalNameChoice.equalsIgnoreCase("dNSName")) {
            theGeneralNameChoice = "dNSName";
        } else if (generalNameChoice.equalsIgnoreCase("directoryName")) {
            theGeneralNameChoice = "directoryName";
        } else if (generalNameChoice.equalsIgnoreCase("ediPartyName")) {
            theGeneralNameChoice = "ediPartyName";
        } else if (generalNameChoice.equalsIgnoreCase("URL")) {
            theGeneralNameChoice = "URL";
        } else if (generalNameChoice.equalsIgnoreCase("iPAddress")) {
            theGeneralNameChoice = "iPAddress";
        } else if (generalNameChoice.equalsIgnoreCase("OID")) {
            theGeneralNameChoice = "OID";
        } else {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_ATTR_VALUE", "generalNameChoice=" + generalNameChoice, "value must be one of: otherName, rfc822Name, dNSName, directoryName, ediPartyName, URL, iPAddress, OID."));
        }
        return theGeneralNameChoice;
    }
}

