/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.cli;

import javax.ws.rs.ProcessingException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CLIException;
import org.dogtagpki.util.logging.PKILogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKIServerCLI
extends CLI {
    public static Logger logger = LoggerFactory.getLogger(PKIServerCLI.class);

    public PKIServerCLI() throws Exception {
        super("pki-server", "PKI server management commands");
        this.addModule("ca", "org.dogtagpki.server.ca.cli.CACLI");
        this.addModule("kra", "org.dogtagpki.server.kra.cli.KRACLI");
        this.addModule("ocsp", "org.dogtagpki.server.ocsp.cli.OCSPCLI");
        this.addModule("tks", "org.dogtagpki.server.tks.cli.TKSCLI");
        this.addModule("tps", "org.dogtagpki.server.tps.cli.TPSCLI");
        this.createOptions();
    }

    public String getFullModuleName(String moduleName) {
        return moduleName;
    }

    public void createOptions() throws Exception {
        Option option = new Option("d", true, "NSS database location");
        option.setArgName("database");
        this.options.addOption(option);
        option = new Option("f", true, "NSS database password configuration");
        option.setArgName("password config");
        this.options.addOption(option);
        this.options.addOption("v", "verbose", false, "Run in verbose mode.");
        this.options.addOption(null, "debug", false, "Run in debug mode.");
        this.options.addOption(null, "help", false, "Show help message.");
    }

    public void printHelp() throws Exception {
        formatter.printHelp(this.name + " [OPTIONS..] <command> [ARGS..]", this.options);
        System.out.println();
        super.printHelp();
    }

    public void execute(String[] args) throws Exception {
        CommandLine cmd = parser.parse(this.options, args, true);
        if (cmd.hasOption("debug")) {
            PKILogger.setLevel((PKILogger.LogLevel)PKILogger.LogLevel.DEBUG);
        } else if (cmd.hasOption("verbose")) {
            PKILogger.setLevel((PKILogger.LogLevel)PKILogger.LogLevel.INFO);
        }
        CharSequence[] cmdArgs = cmd.getArgs();
        logger.info("Command: " + String.join((CharSequence)" ", cmdArgs));
        super.execute((String[])cmdArgs);
    }

    public static void handleException(Throwable t) {
        if (logger.isInfoEnabled()) {
            t.printStackTrace(System.err);
        } else if (t.getClass() == Exception.class) {
            System.err.println("ERROR: " + t.getMessage());
        } else if (t instanceof UnrecognizedOptionException) {
            System.err.println(t.getMessage());
        } else if (t instanceof ProcessingException) {
            t = t.getCause();
            System.err.println(t.getClass().getSimpleName() + ": " + t.getMessage());
        } else {
            System.err.println(t.getClass().getSimpleName() + ": " + t.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            PKIServerCLI cli = new PKIServerCLI();
            cli.execute(args);
        }
        catch (CLIException e) {
            String message = e.getMessage();
            if (message != null) {
                System.err.println("ERROR: " + message);
            }
            System.exit(e.getCode());
        }
        catch (Throwable t) {
            PKIServerCLI.handleException(t);
            System.exit(-1);
        }
    }
}

