/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps;

import java.io.IOException;
import org.dogtagpki.server.tps.dbs.TokenRecord;
import org.dogtagpki.server.tps.main.ExternalRegAttrs;
import org.dogtagpki.server.tps.processor.TPSEnrollProcessor;
import org.dogtagpki.server.tps.processor.TPSPinResetProcessor;
import org.dogtagpki.server.tps.processor.TPSProcessor;
import org.dogtagpki.tps.TPSConnection;
import org.dogtagpki.tps.main.TPSException;
import org.dogtagpki.tps.msg.BeginOpMsg;
import org.dogtagpki.tps.msg.EndOpMsg;
import org.dogtagpki.tps.msg.TPSMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPSSession {
    public static Logger logger = LoggerFactory.getLogger(TPSSession.class);
    private TPSConnection connection;
    private String ipAddress;
    private TokenRecord tokenRecord;
    private ExternalRegAttrs extRegAttrs;

    public TPSSession(TPSConnection conn, String ip) {
        if (conn == null) {
            throw new NullPointerException("TPSSession incoming connection is null!");
        }
        logger.debug("TPSSession constructor conn: " + conn);
        this.connection = conn;
        if (ip == null) {
            logger.debug("TPSSession constructor remote ipAddress null");
        } else {
            logger.debug("TPSSession constructor remote ipAddress: " + this.getIpAddress());
        }
        this.setIpAddress(ip);
    }

    public TPSConnection getConnection() {
        return this.connection;
    }

    public TPSMessage read() throws IOException {
        TPSMessage message = null;
        logger.debug("TPSSession.read() about to call read on connection : " + this.connection);
        try {
            message = this.connection.read();
            logger.debug("TPSSession.read() message created");
        }
        catch (IOException e) {
            logger.error("TPSSession.process: Exception reading from the client: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        return message;
    }

    public void write(TPSMessage msg) throws IOException {
        try {
            this.connection.write(msg);
        }
        catch (Exception e) {
            logger.error("Exception writing to client: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void process() throws IOException {
        EndOpMsg.TPSStatus status = EndOpMsg.TPSStatus.STATUS_NO_ERROR;
        logger.debug("In TPSSession.process()");
        TPSMessage firstMsg = this.read();
        TPSMessage.MsgType msg_type = firstMsg.getType();
        TPSMessage.OpType op_type = firstMsg.getOpType();
        if (msg_type != TPSMessage.MsgType.MSG_BEGIN_OP) {
            throw new IOException("Wrong first message type read in TPSSession.process!");
        }
        int result = 1;
        BeginOpMsg beginOp = (BeginOpMsg)firstMsg;
        try {
            switch (op_type) {
                case OP_FORMAT: {
                    result = 0;
                    TPSProcessor processor = new TPSProcessor(this);
                    processor.process(beginOp);
                    break;
                }
                case OP_ENROLL: {
                    result = 0;
                    TPSEnrollProcessor enrollProcessor = new TPSEnrollProcessor(this);
                    enrollProcessor.process(beginOp);
                    break;
                }
                case OP_RENEW: {
                    break;
                }
                case OP_RESET_PIN: {
                    result = 0;
                    TPSPinResetProcessor pinResetProcessor = new TPSPinResetProcessor(this);
                    pinResetProcessor.process(beginOp);
                    break;
                }
                case OP_UNBLOCK: {
                    break;
                }
                case OP_UNDEFINED: {
                    break;
                }
            }
        }
        catch (TPSException e) {
            logger.warn("TPSSession.process: Message processing failed: " + e.getMessage(), (Throwable)e);
            status = e.getStatus();
            result = 1;
        }
        catch (IOException e) {
            logger.error("TPSSession.process: IO error happened during processing: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        EndOpMsg endOp = new EndOpMsg(firstMsg.getOpType(), result, status);
        this.write((TPSMessage)endOp);
        logger.debug("TPSSession.process: leaving: result: " + result + " status: " + status);
    }

    public TokenRecord getTokenRecord() {
        return this.tokenRecord;
    }

    public void setTokenRecord(TokenRecord tokenRecord) {
        this.tokenRecord = tokenRecord;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    private void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setExternalRegAttrs(ExternalRegAttrs erAttrs) {
        this.extRegAttrs = erAttrs;
    }

    public ExternalRegAttrs getExternalRegAttrs() {
        return this.extRegAttrs;
    }
}

