/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.rest;

import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.ForbiddenException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.tps.authenticator.AuthenticatorCollection;
import com.netscape.certsrv.tps.authenticator.AuthenticatorData;
import com.netscape.certsrv.tps.authenticator.AuthenticatorResource;
import com.netscape.cms.servlet.base.SubsystemService;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.logging.Auditor;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.server.tps.TPSEngine;
import org.dogtagpki.server.tps.TPSSubsystem;
import org.dogtagpki.server.tps.config.AuthenticatorDatabase;
import org.dogtagpki.server.tps.config.AuthenticatorRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticatorService
extends SubsystemService
implements AuthenticatorResource {
    public static Logger logger = LoggerFactory.getLogger(AuthenticatorService.class);

    public AuthenticatorService() {
        logger.debug("AuthenticatorService.<init>()");
    }

    public AuthenticatorData createAuthenticatorData(AuthenticatorRecord authenticatorRecord) throws UnsupportedEncodingException {
        String authenticatorID = authenticatorRecord.getID();
        AuthenticatorData authenticatorData = new AuthenticatorData();
        authenticatorData.setID(authenticatorID);
        authenticatorData.setStatus(authenticatorRecord.getStatus());
        authenticatorData.setProperties(authenticatorRecord.getProperties());
        authenticatorID = URLEncoder.encode(authenticatorID, "UTF-8");
        return authenticatorData;
    }

    public AuthenticatorRecord createAuthenticatorRecord(AuthenticatorData authenticatorData) {
        AuthenticatorRecord authenticatorRecord = new AuthenticatorRecord();
        authenticatorRecord.setID(authenticatorData.getID());
        authenticatorRecord.setStatus(authenticatorData.getStatus());
        authenticatorRecord.setProperties(authenticatorData.getProperties());
        return authenticatorRecord;
    }

    public Response findAuthenticators(String filter, Integer start, Integer size) {
        logger.debug("AuthenticatorService.findAuthenticators()");
        if (filter != null && filter.length() < 3) {
            throw new BadRequestException("Filter is too short.");
        }
        start = start == null ? 0 : start;
        size = size == null ? 20 : size;
        TPSEngine engine = TPSEngine.getInstance();
        try {
            int i;
            TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
            AuthenticatorDatabase database = subsystem.getAuthenticatorDatabase();
            Iterator<AuthenticatorRecord> authenticators = database.findRecords(filter).iterator();
            AuthenticatorCollection response = new AuthenticatorCollection();
            for (i = 0; i < start && authenticators.hasNext(); ++i) {
                authenticators.next();
            }
            while (i < start + size && authenticators.hasNext()) {
                response.addEntry((Object)this.createAuthenticatorData(authenticators.next()));
                ++i;
            }
            while (authenticators.hasNext()) {
                authenticators.next();
                ++i;
            }
            response.setTotal(i);
            return this.createOKResponse(response);
        }
        catch (PKIException e) {
            logger.error("AuthenticatorService: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("AuthenticatorService: " + e.getMessage(), (Throwable)e);
            throw new PKIException((Throwable)e);
        }
    }

    public Response getAuthenticator(String authenticatorID) {
        if (authenticatorID == null) {
            throw new BadRequestException("Authenticator ID is null.");
        }
        logger.debug("AuthenticatorService.getAuthenticator(\"" + authenticatorID + "\")");
        TPSEngine engine = TPSEngine.getInstance();
        try {
            TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
            AuthenticatorDatabase database = subsystem.getAuthenticatorDatabase();
            return this.createOKResponse(this.createAuthenticatorData(database.getRecord(authenticatorID)));
        }
        catch (PKIException e) {
            logger.error("AuthenticatorService: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("AuthenticatorService: " + e.getMessage(), (Throwable)e);
            throw new PKIException((Throwable)e);
        }
    }

    public Response addAuthenticator(AuthenticatorData authenticatorData) {
        String method = "AuthenticatorService.addAuthenticator";
        if (authenticatorData == null) {
            this.auditConfigTokenGeneral("Failure", method, null, "Authenticator data is null.");
            throw new BadRequestException("Authenticator data is null.");
        }
        logger.debug("AuthenticatorService.addAuthenticator(\"" + authenticatorData.getID() + "\")");
        TPSEngine engine = TPSEngine.getInstance();
        try {
            TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
            AuthenticatorDatabase database = subsystem.getAuthenticatorDatabase();
            String status = authenticatorData.getStatus();
            Principal principal = this.servletRequest.getUserPrincipal();
            boolean statusChanged = false;
            if (StringUtils.isEmpty((CharSequence)status) || database.requiresApproval() && !database.canApprove(principal)) {
                status = "Disabled";
                authenticatorData.setStatus(status);
                statusChanged = true;
            }
            database.addRecord(authenticatorData.getID(), this.createAuthenticatorRecord(authenticatorData));
            authenticatorData = this.createAuthenticatorData(database.getRecord(authenticatorData.getID()));
            Map properties = authenticatorData.getProperties();
            if (statusChanged) {
                properties.put("Status", status);
            }
            this.auditTPSAuthenticatorChange("Success", method, authenticatorData.getID(), properties, null);
            String authenticatorID = URLEncoder.encode(authenticatorData.getID(), "UTF-8");
            URI uri = this.uriInfo.getBaseUriBuilder().path(AuthenticatorResource.class).path("{authenticatorID}").build(new Object[]{authenticatorID});
            return this.createCreatedResponse(authenticatorData, uri);
        }
        catch (PKIException e) {
            logger.error("AuthenticatorService: " + e.getMessage(), (Throwable)e);
            this.auditTPSAuthenticatorChange("Failure", method, authenticatorData.getID(), authenticatorData.getProperties(), e.toString());
            throw e;
        }
        catch (Exception e) {
            logger.error("AuthenticatorService: " + e.getMessage(), (Throwable)e);
            this.auditTPSAuthenticatorChange("Failure", method, authenticatorData.getID(), authenticatorData.getProperties(), e.toString());
            throw new PKIException((Throwable)e);
        }
    }

    public Response updateAuthenticator(String authenticatorID, AuthenticatorData authenticatorData) {
        String method = "uthenticatorService.updateAuthenticator";
        if (authenticatorID == null) {
            this.auditConfigTokenGeneral("Failure", method, null, "Authenticator ID is null.");
            throw new BadRequestException("Authenticator ID is null.");
        }
        if (authenticatorData == null) {
            this.auditConfigTokenGeneral("Failure", method, null, "Authenticator data is null.");
            throw new BadRequestException("Authenticator data is null.");
        }
        logger.debug("AuthenticatorService.updateAuthenticator(\"" + authenticatorID + "\")");
        TPSEngine engine = TPSEngine.getInstance();
        try {
            Map properties;
            TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
            AuthenticatorDatabase database = subsystem.getAuthenticatorDatabase();
            AuthenticatorRecord record = database.getRecord(authenticatorID);
            if (!"Disabled".equals(record.getStatus())) {
                ForbiddenException e = new ForbiddenException("Unable to update authenticator " + authenticatorID + "; authenticator not disabled");
                this.auditTPSAuthenticatorChange("Failure", method, authenticatorID, authenticatorData.getProperties(), e.toString());
                throw e;
            }
            String status = authenticatorData.getStatus();
            boolean statusChanged = false;
            if (status != null && !"Disabled".equals(status)) {
                if (!"Enabled".equals(status)) {
                    ForbiddenException e = new ForbiddenException("Invalid authenticator status: " + status);
                    this.auditTPSAuthenticatorChange("Failure", method, authenticatorID, authenticatorData.getProperties(), e.toString());
                    throw e;
                }
                Principal principal = this.servletRequest.getUserPrincipal();
                if (database.requiresApproval() && !database.canApprove(principal)) {
                    status = "Pending_Approval";
                    statusChanged = true;
                }
                record.setStatus(status);
            }
            if ((properties = authenticatorData.getProperties()) != null) {
                record.setProperties(authenticatorData.getProperties());
                if (statusChanged) {
                    properties.put("Status", status);
                }
            }
            database.updateRecord(authenticatorID, record);
            authenticatorData = this.createAuthenticatorData(database.getRecord(authenticatorID));
            this.auditTPSAuthenticatorChange("Success", method, authenticatorData.getID(), properties, null);
            return this.createOKResponse(authenticatorData);
        }
        catch (PKIException e) {
            logger.error("AuthenticatorService: " + e.getMessage(), (Throwable)e);
            this.auditTPSAuthenticatorChange("Failure", method, authenticatorID, authenticatorData.getProperties(), e.toString());
            throw e;
        }
        catch (Exception e) {
            logger.error("AuthenticatorService: " + e.getMessage(), (Throwable)e);
            this.auditTPSAuthenticatorChange("Failure", method, authenticatorID, authenticatorData.getProperties(), e.toString());
            throw new PKIException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response changeStatus(String authenticatorID, String action) {
        String method = "AuthenticatorService.changeStatus";
        HashMap<String, String> auditModParams = new HashMap<String, String>();
        if (authenticatorID == null) {
            this.auditConfigTokenGeneral("Failure", method, null, "authenticator id is null.");
            throw new BadRequestException("Authenticator ID is null.");
        }
        auditModParams.put("authenticatorID", authenticatorID);
        if (action == null) {
            this.auditConfigTokenGeneral("Failure", method, auditModParams, "action is null.");
            throw new BadRequestException("Action is null.");
        }
        auditModParams.put("Action", action);
        logger.debug("AuthenticatorService.changeStatus(\"" + authenticatorID + "\", \"" + action + "\")");
        TPSEngine engine = TPSEngine.getInstance();
        try {
            String status;
            AuthenticatorRecord record;
            AuthenticatorDatabase database;
            block20: {
                boolean canApprove;
                block21: {
                    block22: {
                        TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
                        database = subsystem.getAuthenticatorDatabase();
                        record = database.getRecord(authenticatorID);
                        status = record.getStatus();
                        Principal principal = this.servletRequest.getUserPrincipal();
                        canApprove = database.canApprove(principal);
                        if (!"Disabled".equals(status)) break block21;
                        if (!database.requiresApproval()) break block22;
                        if ("submit".equals(action) && !canApprove) {
                            status = "Pending_Approval";
                            break block20;
                        } else if ("enable".equals(action) && canApprove) {
                            status = "Enabled";
                            break block20;
                        } else {
                            BadRequestException e = new BadRequestException("Invalid action: " + action);
                            this.auditTPSAuthenticatorChange("Failure", method, authenticatorID, auditModParams, e.toString());
                            throw e;
                        }
                    }
                    if (!"enable".equals(action)) {
                        BadRequestException e = new BadRequestException("Invalid action: " + action);
                        this.auditTPSAuthenticatorChange("Failure", method, authenticatorID, auditModParams, e.toString());
                        throw e;
                    }
                    status = "Enabled";
                    break block20;
                }
                if ("Enabled".equals(status)) {
                    if (!"disable".equals(action)) {
                        BadRequestException e = new BadRequestException("Invalid action: " + action);
                        this.auditTPSAuthenticatorChange("Failure", method, authenticatorID, auditModParams, e.toString());
                        throw e;
                    }
                    status = "Disabled";
                } else {
                    if (!"Pending_Approval".equals(status)) {
                        PKIException e = new PKIException("Invalid status: " + status);
                        this.auditTPSAuthenticatorChange("Failure", method, authenticatorID, auditModParams, e.toString());
                        throw e;
                    }
                    if ("approve".equals(action) && canApprove) {
                        status = "Enabled";
                    } else if ("reject".equals(action) && canApprove) {
                        status = "Disabled";
                    } else if ("cancel".equals(action) && !canApprove) {
                        status = "Disabled";
                    } else {
                        BadRequestException e = new BadRequestException("Invalid action: " + action);
                        this.auditTPSAuthenticatorChange("Failure", method, authenticatorID, auditModParams, e.toString());
                    }
                }
            }
            record.setStatus(status);
            database.updateRecord(authenticatorID, record);
            AuthenticatorData authenticatorData = this.createAuthenticatorData(database.getRecord(authenticatorID));
            auditModParams.put("Status", status);
            this.auditTPSAuthenticatorChange("Success", method, authenticatorID, auditModParams, null);
            return this.createOKResponse(authenticatorData);
        }
        catch (PKIException e) {
            logger.error("AuthenticatorService: " + e.getMessage(), (Throwable)e);
            this.auditTPSAuthenticatorChange("Failure", method, authenticatorID, auditModParams, e.toString());
            throw e;
        }
        catch (Exception e) {
            logger.error("AuthenticatorService: " + e.getMessage(), (Throwable)e);
            this.auditTPSAuthenticatorChange("Failure", method, authenticatorID, auditModParams, e.toString());
            throw new PKIException((Throwable)e);
        }
    }

    public Response removeAuthenticator(String authenticatorID) {
        String method = "AuthenticatorService.removeAuthenticator";
        HashMap<String, String> auditModParams = new HashMap<String, String>();
        if (authenticatorID == null) {
            this.auditConfigTokenGeneral("Failure", method, null, "Authenticator ID is null.");
            throw new BadRequestException("Authenticator ID is null.");
        }
        auditModParams.put("authenticatorID", authenticatorID);
        logger.debug("AuthenticatorService.removeAuthenticator(\"" + authenticatorID + "\")");
        TPSEngine engine = TPSEngine.getInstance();
        try {
            TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
            AuthenticatorDatabase database = subsystem.getAuthenticatorDatabase();
            AuthenticatorRecord record = database.getRecord(authenticatorID);
            String status = record.getStatus();
            if (!"Disabled".equals(status)) {
                ForbiddenException e = new ForbiddenException("Unable to remove authenticator " + authenticatorID + "; authenticator not disabled");
                this.auditTPSAuthenticatorChange("Failure", method, authenticatorID, auditModParams, e.toString());
                throw e;
            }
            database.removeRecord(authenticatorID);
            this.auditTPSAuthenticatorChange("Success", method, authenticatorID, null, null);
            return this.createNoContentResponse();
        }
        catch (PKIException e) {
            logger.error("AuthenticatorService: " + e.getMessage(), (Throwable)e);
            this.auditTPSAuthenticatorChange("Failure", method, authenticatorID, auditModParams, e.toString());
            throw e;
        }
        catch (Exception e) {
            logger.error("AuthenticatorService: " + e.getMessage(), (Throwable)e);
            this.auditTPSAuthenticatorChange("Failure", method, authenticatorID, auditModParams, e.toString());
            throw new PKIException((Throwable)e);
        }
    }

    public void auditTPSAuthenticatorChange(String status, String service, String authenticatorID, Map<String, String> params, String info) {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String msg = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_TOKEN_AUTHENTICATOR_6", (Object[])new Object[]{this.servletRequest.getUserPrincipal().getName(), status, service, authenticatorID, auditor.getParamString(params), info});
        auditor.log(msg);
    }
}

