/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.key;

import com.netscape.certsrv.authorization.EAuthzUnknownRealm;
import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.base.UnauthorizedException;
import com.netscape.certsrv.dbs.EDBRecordNotFoundException;
import com.netscape.certsrv.dbs.keydb.KeyId;
import com.netscape.certsrv.key.AsymKeyGenerationRequest;
import com.netscape.certsrv.key.KeyArchivalRequest;
import com.netscape.certsrv.key.KeyData;
import com.netscape.certsrv.key.KeyNotFoundException;
import com.netscape.certsrv.key.KeyRecoveryRequest;
import com.netscape.certsrv.key.KeyRequestInfo;
import com.netscape.certsrv.key.KeyRequestInfoCollection;
import com.netscape.certsrv.key.KeyRequestResource;
import com.netscape.certsrv.key.KeyRequestResponse;
import com.netscape.certsrv.key.KeyResource;
import com.netscape.certsrv.key.SymKeyGenerationRequest;
import com.netscape.certsrv.request.CMSRequestInfos;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cms.servlet.request.CMSRequestDAO;
import com.netscape.cmscore.authorization.AuthzSubsystem;
import com.netscape.cmscore.dbs.KeyRecord;
import com.netscape.cmscore.dbs.KeyRepository;
import com.netscape.cmscore.request.KeyRequestRepository;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.security.JssSubsystem;
import com.netscape.kra.KeyRecoveryAuthority;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.kra.KRAEngine;
import org.dogtagpki.server.kra.KRAEngineConfig;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;

public class KeyRequestDAO
extends CMSRequestDAO {
    public static final Map<String, KeyGenAlgorithm> SYMKEY_GEN_ALGORITHMS = new HashMap<String, KeyGenAlgorithm>();
    public static final Map<String, KeyPairAlgorithm> ASYMKEY_GEN_ALGORITHMS;
    private static String REQUEST_ARCHIVE_OPTIONS;
    private static String REQUEST_SECURITY_DATA;
    private static String REQUEST_SESSION_KEY;
    private static String REQUEST_ALGORITHM_OID;
    private static String REQUEST_ALGORITHM_PARAMS;
    public static final String ATTR_SERIALNO = "serialNumber";
    protected AuthzSubsystem authz;
    private KeyRepository repo;
    private KeyRecoveryAuthority kra;
    private KeyRecoveryAuthority service;

    public KeyRequestDAO() {
        KRAEngine engine = KRAEngine.getInstance();
        this.authz = engine.getAuthzSubsystem();
        this.kra = (KeyRecoveryAuthority)engine.getSubsystem("kra");
        this.repo = this.kra.getKeyRepository();
        this.requestRepository = engine.getRequestRepository();
        this.queue = engine.getRequestQueue();
        this.service = this.kra;
    }

    public KeyRequestInfoCollection listRequests(String filter, RequestId start, int pageSize, int maxResults, int maxTime, UriInfo uriInfo) throws EBaseException {
        KeyRequestInfoCollection ret = new KeyRequestInfoCollection();
        CMSRequestInfos cmsInfos = this.listCMSRequests(filter, start, pageSize, maxResults, maxTime, uriInfo);
        ret.setTotal(cmsInfos.getTotal());
        Collection cmsList = cmsInfos.getEntries();
        List list = (List)cmsList;
        ret.setEntries((Collection)list);
        return ret;
    }

    public KeyRequestInfo getRequest(RequestId id, UriInfo uriInfo, AuthToken authToken) throws EBaseException {
        Request request = this.requestRepository.readRequest(id);
        if (request == null) {
            return null;
        }
        this.authz.checkRealm(request.getRealm(), authToken, request.getExtDataInString("requestOwner"), "certServer.kra.request", "read");
        KeyRequestInfo info = this.createKeyRequestInfo(request, uriInfo);
        return info;
    }

    public RequestId createEphemeralRequestID() throws EBaseException {
        KRAEngine engine = KRAEngine.getInstance();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        SecureRandom random = jssSubsystem.getRandomNumberGenerator();
        long id = System.currentTimeMillis() * 10000L + (long)random.nextInt(10000);
        return new RequestId(id);
    }

    public KeyRequestResponse submitRequest(KeyArchivalRequest data, UriInfo uriInfo, String owner) throws EBaseException {
        String clientKeyId = data.getClientKeyId();
        String wrappedSecurityData = data.getWrappedPrivateData();
        String transWrappedSessionKey = data.getTransWrappedSessionKey();
        String algorithmOID = data.getAlgorithmOID();
        String symkeyParams = data.getSymmetricAlgorithmParams();
        String pkiArchiveOptions = data.getPKIArchiveOptions();
        String dataType = data.getDataType();
        String keyAlgorithm = data.getKeyAlgorithm();
        int keyStrength = dataType.equals("symmetricKey") ? data.getKeySize() : 0;
        String realm = data.getRealm();
        boolean keyExists = this.keyExists(clientKeyId, "active");
        if (keyExists) {
            throw new BadRequestException("Can not archive already active existing key!");
        }
        KRAEngine engine = KRAEngine.getInstance();
        KeyRequestRepository requestRepository = engine.getKeyRequestRepository();
        boolean ephemeral = this.kra.isEphemeral(realm);
        RequestId requestID = ephemeral ? this.createEphemeralRequestID() : requestRepository.createRequestID();
        Request request = requestRepository.createRequest(requestID, "securityDataEnrollment");
        if (pkiArchiveOptions != null) {
            request.setExtData(REQUEST_ARCHIVE_OPTIONS, pkiArchiveOptions);
        } else {
            request.setExtData(REQUEST_SECURITY_DATA, wrappedSecurityData);
            request.setExtData(REQUEST_SESSION_KEY, transWrappedSessionKey);
            request.setExtData(REQUEST_ALGORITHM_PARAMS, symkeyParams);
            request.setExtData(REQUEST_ALGORITHM_OID, algorithmOID);
        }
        request.setExtData("clientKeyID", clientKeyId);
        request.setExtData("dataType", dataType);
        request.setExtData("strength", keyStrength > 0 ? Integer.toString(keyStrength) : Integer.toString(0));
        if (keyAlgorithm != null) {
            request.setExtData("algorithm", keyAlgorithm);
        }
        request.setExtData("requestOwner", owner);
        if (realm != null) {
            request.setRealm(realm);
        }
        if (!this.kra.isEphemeral(realm)) {
            this.queue.processRequest(request);
            this.queue.markAsServiced(request);
        } else {
            this.kra.processSynchronousRequest(request);
        }
        return this.createKeyRequestResponse(request, uriInfo);
    }

    public Request createRecoveryRequest(KeyRecoveryRequest data, UriInfo uriInfo, String requestor, AuthToken authToken, boolean ephemeral) throws EBaseException {
        String wrapName;
        if (data == null) {
            throw new BadRequestException("Invalid request.");
        }
        if (requestor == null) {
            throw new UnauthorizedException("Recovery must be initiated by an agent");
        }
        KeyId keyId = data.getKeyId();
        KeyRecord rec = null;
        try {
            rec = this.repo.readKeyRecord(keyId.toBigInteger());
        }
        catch (EDBRecordNotFoundException e) {
            throw new KeyNotFoundException(keyId, "key not found to recover", (Throwable)e);
        }
        try {
            this.authz.checkRealm(rec.getRealm(), authToken, rec.getOwnerName(), "certServer.kra.key", "recover");
        }
        catch (EAuthzUnknownRealm e) {
            throw new UnauthorizedException("Invalid realm", (Throwable)e);
        }
        catch (EBaseException e) {
            throw new UnauthorizedException("Agent not authorized by realm", (Throwable)e);
        }
        KRAEngine engine = KRAEngine.getInstance();
        KeyRequestRepository requestRepository = engine.getKeyRequestRepository();
        RequestId requestID = ephemeral ? this.createEphemeralRequestID() : requestRepository.createRequestID();
        Request request = requestRepository.createRequest(requestID, "securityDataRecovery");
        if (rec.getRealm() != null) {
            request.setRealm(rec.getRealm());
        }
        request.setExtData(ATTR_SERIALNO, keyId.toString());
        request.setExtData("requestOwner", requestor);
        request.setExtData("approvingAgents", requestor);
        String encryptOID = data.getPaylodEncryptionOID();
        if (encryptOID != null) {
            request.setExtData("payloadEncryptionOID", encryptOID);
        }
        if ((wrapName = data.getPayloadWrappingName()) != null) {
            request.setExtData("payloadWrappingName", wrapName);
        }
        return request;
    }

    public void setTransientData(KeyRecoveryRequest data, Request request) throws EBaseException {
        Hashtable<String, Object> requestParams = this.getTransientData(request);
        String wrappedSessionKeyStr = data.getTransWrappedSessionKey();
        String wrappedPassPhraseStr = data.getSessionWrappedPassphrase();
        String nonceDataStr = data.getNonceData();
        String encryptOID = data.getPaylodEncryptionOID();
        String wrapName = data.getPayloadWrappingName();
        if (wrappedPassPhraseStr != null) {
            requestParams.put("sessionWrappedPassphrase", wrappedPassPhraseStr);
        }
        if (wrappedSessionKeyStr != null) {
            requestParams.put("transWrappedSessionKey", wrappedSessionKeyStr);
        }
        if (nonceDataStr != null) {
            requestParams.put("iv_in", nonceDataStr);
        }
        if (encryptOID != null) {
            requestParams.put("payloadEncryptionOID", encryptOID);
        }
        if (wrapName != null) {
            requestParams.put("payloadWrappingName", wrapName);
        }
    }

    public Hashtable<String, Object> getTransientData(Request request) throws EBaseException {
        KRAEngine engine = KRAEngine.getInstance();
        KeyRecoveryAuthority kra = (KeyRecoveryAuthority)engine.getSubsystem("kra");
        Hashtable<String, Object> requestParams = kra.getVolatileRequest(request.getRequestId());
        if (requestParams == null && (requestParams = kra.createVolatileRequest(request.getRequestId())) == null) {
            throw new EBaseException("Can not create Volatile params in createRecoveryRequest!");
        }
        return requestParams;
    }

    public KeyRequestResponse submitRequest(KeyRecoveryRequest data, UriInfo uriInfo, String requestor, AuthToken authToken) throws EBaseException {
        Request request = this.createRecoveryRequest(data, uriInfo, requestor, authToken, false);
        this.setTransientData(data, request);
        this.queue.processRequest(request);
        return this.createKeyRequestResponse(request, uriInfo);
    }

    public KeyRequestResponse submitAsyncKeyRecoveryRequest(KeyRecoveryRequest data, UriInfo uriInfo, String requestor, AuthToken authToken) throws EBaseException {
        if (data == null) {
            throw new BadRequestException("Invalid request.");
        }
        KeyId keyId = data.getKeyId();
        KeyRecord rec = null;
        try {
            rec = this.repo.readKeyRecord(keyId.toBigInteger());
        }
        catch (EDBRecordNotFoundException e) {
            throw new KeyNotFoundException(keyId, "key not found to recover", (Throwable)e);
        }
        String realm = rec.getRealm();
        try {
            this.authz.checkRealm(realm, authToken, rec.getOwnerName(), "certServer.kra.key", "recover");
        }
        catch (EAuthzUnknownRealm e) {
            throw new UnauthorizedException("Invalid realm", (Throwable)e);
        }
        catch (EBaseException e) {
            throw new UnauthorizedException("Agent not authorized by realm", (Throwable)e);
        }
        String b64Certificate = data.getCertificate();
        byte[] certData = Utils.base64decode((String)b64Certificate);
        String requestId = null;
        try {
            requestId = this.service.initAsyncKeyRecovery(new BigInteger(keyId.toString()), new X509CertImpl(certData), requestor, realm);
        }
        catch (EBaseException | CertificateException e) {
            e.printStackTrace();
            throw new PKIException(e.toString(), e);
        }
        Request request = null;
        try {
            request = this.requestRepository.readRequest(new RequestId(requestId));
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        return this.createCMSRequestResponse(request, uriInfo);
    }

    public KeyRequestResponse submitRequest(SymKeyGenerationRequest data, UriInfo uriInfo, String owner) throws EBaseException {
        KeyGenAlgorithm alg;
        String clientKeyId = data.getClientKeyId();
        String algName = data.getKeyAlgorithm();
        Integer keySize = data.getKeySize();
        List usages = data.getUsages();
        String transWrappedSessionKey = data.getTransWrappedSessionKey();
        String realm = data.getRealm();
        if (StringUtils.isBlank((CharSequence)clientKeyId)) {
            throw new BadRequestException("Invalid key generation request. Missing client ID");
        }
        boolean keyExists = this.keyExists(clientKeyId, "active");
        if (keyExists) {
            throw new BadRequestException("Can not archive already active existing key!");
        }
        if (keySize == null) {
            keySize = 0;
        }
        if (StringUtils.isBlank((CharSequence)algName)) {
            if (keySize != 0) {
                throw new BadRequestException("Invalid request.  Must specify key algorithm if size is specified");
            }
            algName = "AES";
            keySize = 128;
        }
        if ((alg = SYMKEY_GEN_ALGORITHMS.get(algName)) == null) {
            throw new BadRequestException("Invalid Algorithm");
        }
        if (!alg.isValidStrength(keySize.intValue())) {
            throw new BadRequestException("Invalid key size for this algorithm");
        }
        KRAEngine engine = KRAEngine.getInstance();
        KeyRequestRepository requestRepository = engine.getKeyRequestRepository();
        Request request = requestRepository.createRequest("symkeyGenRequest");
        request.setExtData("keyGenAlgorithm", algName);
        request.setExtData("keyGenSize", keySize);
        request.setExtData("strength", keySize);
        request.setExtData("algorithm", algName);
        request.setExtData("keyGenUsages", StringUtils.join((Iterable)usages, (String)","));
        request.setExtData("clientKeyID", clientKeyId);
        request.setExtData("requestOwner", owner);
        if (transWrappedSessionKey != null) {
            request.setExtData("transWrappedSessionKey", transWrappedSessionKey);
        }
        if (realm != null) {
            request.setRealm(realm);
        }
        this.queue.processRequest(request);
        this.queue.markAsServiced(request);
        return this.createKeyRequestResponse(request, uriInfo);
    }

    public KeyRequestResponse submitRequest(AsymKeyGenerationRequest data, UriInfo uriInfo, String owner) throws EBaseException {
        String[] sizes;
        String clientKeyId = data.getClientKeyId();
        String algName = data.getKeyAlgorithm();
        Integer keySize = data.getKeySize();
        List usages = data.getUsages();
        String transWrappedSessionKey = data.getTransWrappedSessionKey();
        String realm = data.getRealm();
        if (StringUtils.isBlank((CharSequence)clientKeyId)) {
            throw new BadRequestException("Invalid key generation request. Missing client ID");
        }
        KRAEngine engine = KRAEngine.getInstance();
        KRAEngineConfig cs = engine.getConfig();
        boolean keyExists = this.keyExists(clientKeyId, "active");
        if (keyExists) {
            throw new BadRequestException("Cannot archive already active existing key!");
        }
        if (StringUtils.isBlank((CharSequence)algName) && keySize != 0) {
            throw new BadRequestException("Invalid request.  Must specify key algorithm if size is specified");
        }
        KeyPairAlgorithm alg = ASYMKEY_GEN_ALGORITHMS.get(algName);
        if (alg == null) {
            throw new BadRequestException("Unsupported algorithm specified.");
        }
        if (keySize == null) {
            if (algName.equalsIgnoreCase("RSA") || algName.equalsIgnoreCase("DSA")) {
                throw new BadRequestException("Key size must be specified.");
            }
        } else if (algName.equalsIgnoreCase("RSA")) {
            int maxSize;
            int size = keySize;
            int minSize = cs.getInteger("keys.rsa.min.size", 256);
            if (minSize > (maxSize = Integer.valueOf(cs.getInteger("keys.rsa.max.size", 8192)).intValue())) {
                throw new PKIException("Incorrect size parameters stored in config file.");
            }
            if (size < minSize || size > maxSize) {
                throw new BadRequestException("Key size out of supported range - " + minSize + " - " + maxSize);
            }
            if ((size - 256) % 16 != 0) {
                throw new BadRequestException("Invalid key size specified.");
            }
        } else if (algName.equalsIgnoreCase("DSA") && !Arrays.asList(sizes = engine.getConfig().getString("keys.dsa.list", "512,768,1024").split(",")).contains(String.valueOf(keySize))) {
            throw new BadRequestException("Invalid key size specified.");
        }
        KeyRequestRepository requestRepository = engine.getKeyRequestRepository();
        Request request = requestRepository.createRequest("asymkeyGenRequest");
        request.setExtData("keyGenAlgorithm", algName);
        request.setExtData("keyGenSize", keySize);
        request.setExtData("strength", keySize);
        request.setExtData("algorithm", algName);
        request.setExtData("keyGenUsages", StringUtils.join((Iterable)usages, (String)","));
        request.setExtData("clientKeyID", clientKeyId);
        request.setExtData("requestOwner", owner);
        if (realm != null) {
            request.setRealm(realm);
        }
        if (transWrappedSessionKey != null) {
            request.setExtData("transWrappedSessionKey", transWrappedSessionKey);
        }
        this.queue.processRequest(request);
        this.queue.markAsServiced(request);
        return this.createKeyRequestResponse(request, uriInfo);
    }

    public void approveRequest(RequestId id, String requestor, AuthToken authToken) throws EBaseException {
        Request request = this.requestRepository.readRequest(id);
        this.authz.checkRealm(request.getRealm(), authToken, request.getExtDataInString("requestOwner"), "certServer.kra.requests", "execute");
        this.service.addAgentAsyncKeyRecovery(id.toString(), requestor);
    }

    public void rejectRequest(RequestId id, AuthToken authToken) throws EBaseException {
        Request request = this.requestRepository.readRequest(id);
        String realm = request.getRealm();
        this.authz.checkRealm(realm, authToken, request.getExtDataInString("requestOwner"), "certServer.kra.requests", "execute");
        request.setRequestStatus(RequestStatus.REJECTED);
        this.requestRepository.updateRequest(request);
    }

    public void cancelRequest(RequestId id, AuthToken authToken) throws EBaseException {
        Request request = this.requestRepository.readRequest(id);
        String realm = request.getRealm();
        this.authz.checkRealm(realm, authToken, request.getExtDataInString("requestOwner"), "certServer.kra.requests", "execute");
        request.setRequestStatus(RequestStatus.CANCELED);
        this.requestRepository.updateRequest(request);
    }

    private KeyRequestInfo createKeyRequestInfo(Request request, UriInfo uriInfo) {
        KeyRequestInfo ret = new KeyRequestInfo();
        RequestId requestID = request.getRequestId();
        ret.setRequestID(requestID);
        ret.setRequestType(request.getRequestType());
        ret.setRequestStatus(request.getRequestStatus());
        Path keyRequestPath = KeyRequestResource.class.getAnnotation(Path.class);
        UriBuilder reqBuilder = uriInfo.getBaseUriBuilder();
        reqBuilder.path(keyRequestPath.value() + "/" + requestID);
        ret.setRequestURL(reqBuilder.build(new Object[0]).toString());
        Path keyPath = KeyResource.class.getAnnotation(Path.class);
        String keyID = request.getExtDataInString("keyrecord");
        if (keyID != null) {
            UriBuilder keyBuilder = uriInfo.getBaseUriBuilder();
            keyBuilder.path(keyPath.value() + "/" + keyID);
            ret.setKeyURL(keyBuilder.build(new Object[0]).toString());
        }
        if (request.getRealm() != null) {
            ret.setRealm(request.getRealm());
        }
        ret.setCreationTime(request.getCreationTime());
        ret.setModificationTime(request.getModificationTime());
        return ret;
    }

    private KeyData createKeyData(Request request, UriInfo uriInfo) {
        return null;
    }

    private KeyRequestResponse createKeyRequestResponse(Request request, UriInfo uriInfo) {
        KeyRequestResponse response = new KeyRequestResponse();
        response.setRequestInfo(this.createKeyRequestInfo(request, uriInfo));
        response.setKeyData(this.createKeyData(request, uriInfo));
        return response;
    }

    public KeyRequestInfo createCMSRequestInfo(Request request, UriInfo uriInfo) {
        return this.createKeyRequestInfo(request, uriInfo);
    }

    public KeyRequestResponse createCMSRequestResponse(Request request, UriInfo uriInfo) {
        return this.createKeyRequestResponse(request, uriInfo);
    }

    private boolean keyExists(String clientKeyId, String keyStatus) throws EBaseException {
        logger.info("KeyRequestDAO: Checking for key existence");
        logger.info("KeyRequestDAO: - client key ID: " + clientKeyId);
        logger.info("KeyRequestDAO: - status: " + keyStatus);
        String filter = "(clientId=" + clientKeyId + ")";
        if (keyStatus != null) {
            filter = "(&" + filter + "(status=" + keyStatus + "))";
        }
        logger.info("KeyRequestDAO: - filter: " + filter);
        Enumeration<KeyRecord> existingKeys = this.repo.searchKeys(filter, 1, 10);
        if (existingKeys != null && existingKeys.hasMoreElements()) {
            logger.info("KeyRequestDAO: Key exists");
            return true;
        }
        logger.info("KeyRequestDAO: Key does not exist");
        return false;
    }

    static {
        SYMKEY_GEN_ALGORITHMS.put("DES", KeyGenAlgorithm.DES);
        SYMKEY_GEN_ALGORITHMS.put("DESede", KeyGenAlgorithm.DESede);
        SYMKEY_GEN_ALGORITHMS.put("DES3", KeyGenAlgorithm.DES3);
        SYMKEY_GEN_ALGORITHMS.put("RC2", KeyGenAlgorithm.RC2);
        SYMKEY_GEN_ALGORITHMS.put("RC4", KeyGenAlgorithm.RC4);
        SYMKEY_GEN_ALGORITHMS.put("AES", KeyGenAlgorithm.AES);
        ASYMKEY_GEN_ALGORITHMS = new HashMap<String, KeyPairAlgorithm>();
        ASYMKEY_GEN_ALGORITHMS.put("RSA", KeyPairAlgorithm.RSA);
        ASYMKEY_GEN_ALGORITHMS.put("DSA", KeyPairAlgorithm.DSA);
        REQUEST_ARCHIVE_OPTIONS = "req_archive_options";
        REQUEST_SECURITY_DATA = "req_security_data";
        REQUEST_SESSION_KEY = "req_session_key";
        REQUEST_ALGORITHM_OID = "req_algorithm_oid";
        REQUEST_ALGORITHM_PARAMS = "req_algorithm_params";
    }
}

