/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.authority;

import com.netscape.certsrv.authority.AuthorityClient;
import com.netscape.certsrv.authority.AuthorityData;
import com.netscape.certsrv.ca.AuthorityID;
import com.netscape.cmstools.authority.AuthorityCLI;
import com.netscape.cmstools.cli.MainCLI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;

public class AuthorityCreateCLI
extends CommandCLI {
    public AuthorityCLI authorityCLI;

    public AuthorityCreateCLI(AuthorityCLI authorityCLI) {
        super("create", "Create CAs", (CLI)authorityCLI);
        this.authorityCLI = authorityCLI;
    }

    public void createOptions() {
        Option optParent = new Option(null, "parent", true, "ID of parent CA");
        optParent.setArgName("id");
        this.options.addOption(optParent);
        Option optDesc = new Option(null, "desc", true, "Optional description");
        optDesc.setArgName("string");
        this.options.addOption(optDesc);
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <dn>", this.options);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length < 1) {
            throw new Exception("No DN specified.");
        }
        if (cmdArgs.length > 1) {
            throw new Exception("Too many arguments.");
        }
        String parentAIDString = null;
        if (cmd.hasOption("parent")) {
            parentAIDString = cmd.getOptionValue("parent");
            try {
                new AuthorityID(parentAIDString);
            }
            catch (IllegalArgumentException e) {
                throw new Exception("Bad CA ID: " + parentAIDString, e);
            }
        } else {
            throw new Exception("Must specify parent authority");
        }
        String desc = null;
        if (cmd.hasOption("desc")) {
            desc = cmd.getOptionValue("desc");
        }
        String dn = cmdArgs[0];
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        AuthorityData data = new AuthorityData(null, dn, null, parentAIDString, null, null, Boolean.valueOf(true), desc, null);
        AuthorityClient authorityClient = this.authorityCLI.getAuthorityClient();
        AuthorityData newData = authorityClient.createCA(data);
        AuthorityCLI.printAuthorityData(newData);
    }
}

