/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.client;

import com.netscape.certsrv.ca.AuthorityID;
import com.netscape.certsrv.ca.CACertClient;
import com.netscape.certsrv.ca.CAClient;
import com.netscape.certsrv.cert.CertEnrollmentRequest;
import com.netscape.certsrv.cert.CertRequestInfos;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.client.SubsystemClient;
import com.netscape.certsrv.profile.ProfileAttribute;
import com.netscape.certsrv.profile.ProfileInput;
import com.netscape.cmstools.CRMFPopClient;
import com.netscape.cmstools.ca.CACertRequestCLI;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.client.ClientCLI;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.ByteArrayOutputStream;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.ca.CASystemCertClient;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.dogtagpki.nss.NSSDatabase;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.KeyPairGeneratorSpi;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.Signature;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.pkix.crmf.CertRequest;
import org.mozilla.jss.pkix.crmf.ProofOfPossession;
import org.mozilla.jss.pkix.primitive.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCertRequestCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(ClientCertRequestCLI.class);
    public ClientCLI clientCLI;

    public ClientCertRequestCLI(ClientCLI clientCLI) {
        super("cert-request", "Request a certificate", (CLI)clientCLI);
        this.clientCLI = clientCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [Subject DN] [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "type", true, "Request type (default: pkcs10)");
        option.setArgName("request type");
        this.options.addOption(option);
        option = new Option(null, "username", true, "Username for request authentication");
        option.setArgName("username");
        this.options.addOption(option);
        option = new Option(null, "password", false, "Prompt password for request authentication");
        this.options.addOption(option);
        option = new Option(null, "attribute-encoding", false, "Enable Attribute encoding");
        this.options.addOption(option);
        option = new Option(null, "algorithm", true, "Algorithm (default: rsa)");
        option.setArgName("algorithm name");
        this.options.addOption(option);
        option = new Option(null, "length", true, "RSA key length (default: 2048)");
        option.setArgName("key length");
        this.options.addOption(option);
        option = new Option(null, "curve", true, "ECC key curve name (default: nistp256)");
        option.setArgName("curve name");
        this.options.addOption(option);
        option = new Option(null, "oaep", false, "Use OAEP key wrap algorithm.");
        this.options.addOption(option);
        option = new Option(null, "ssl-ecdh", false, "SSL certificate with ECDH ECDSA");
        this.options.addOption(option);
        option = new Option(null, "permanent", false, "Permanent");
        this.options.addOption(option);
        option = new Option(null, "sensitive", true, "Sensitive");
        option.setArgName("boolean");
        this.options.addOption(option);
        option = new Option(null, "extractable", true, "Extractable");
        option.setArgName("boolean");
        this.options.addOption(option);
        option = new Option(null, "transport", true, "PEM transport certificate");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "profile", true, "Certificate profile (RSA default: caUserCert, ECC default: caECUserCert)");
        option.setArgName("profile");
        this.options.addOption(option);
        option = new Option(null, "without-pop", false, "Do not include Proof-of-Possession in CRMF request");
        this.options.addOption(option);
        option = new Option(null, "issuer-id", true, "Authority ID (host authority if omitted)");
        option.setArgName("ID");
        this.options.addOption(option);
        option = new Option(null, "issuer-dn", true, "Authority DN (host authority if omitted)");
        option.setArgName("DN");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        PKIClient client;
        String csr;
        int extractable;
        int sensitive;
        Object subjectDN;
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length > 1) {
            throw new Exception("Too many arguments specified.");
        }
        String certRequestUsername = cmd.getOptionValue("username");
        if (cmdArgs.length == 0) {
            if (certRequestUsername == null) {
                throw new Exception("Missing subject DN or request username.");
            }
            subjectDN = "UID=" + certRequestUsername;
        } else {
            subjectDN = cmdArgs[0];
        }
        String requestType = cmd.getOptionValue("type", "pkcs10");
        boolean attributeEncoding = cmd.hasOption("attribute-encoding");
        String algorithm = cmd.getOptionValue("algorithm", "rsa");
        int length = Integer.parseInt(cmd.getOptionValue("length", "2048"));
        String curve = cmd.getOptionValue("curve", "nistp256");
        boolean sslECDH = cmd.hasOption("ssl-ecdh");
        boolean temporary = !cmd.hasOption("permanent");
        String s = cmd.getOptionValue("sensitive");
        if (s == null) {
            sensitive = -1;
        } else {
            if (!s.equalsIgnoreCase("true") && !s.equalsIgnoreCase("false")) {
                throw new IllegalArgumentException("Invalid sensitive parameter: " + s);
            }
            sensitive = Boolean.parseBoolean(s) ? 1 : 0;
        }
        s = cmd.getOptionValue("extractable");
        if (s == null) {
            extractable = -1;
        } else {
            if (!s.equalsIgnoreCase("true") && !s.equalsIgnoreCase("false")) {
                throw new IllegalArgumentException("Invalid extractable parameter: " + s);
            }
            extractable = Boolean.parseBoolean(s) ? 1 : 0;
        }
        String transportCertFilename = cmd.getOptionValue("transport");
        String profileID = cmd.getOptionValue("profile");
        if (profileID == null) {
            if (algorithm.equals("rsa")) {
                profileID = "caUserCert";
            } else if (algorithm.equals("ec")) {
                profileID = "caECUserCert";
            }
        }
        boolean withPop = !cmd.hasOption("without-pop");
        AuthorityID aid = null;
        if (cmd.hasOption("issuer-id")) {
            String aidString = cmd.getOptionValue("issuer-id");
            try {
                aid = new AuthorityID(aidString);
            }
            catch (IllegalArgumentException e) {
                throw new Exception("Invalid issuer ID: " + aidString, e);
            }
        }
        X500Name adn = null;
        if (cmd.hasOption("issuer-dn")) {
            String adnString = cmd.getOptionValue("issuer-dn");
            try {
                adn = new X500Name(adnString);
            }
            catch (IOException e) {
                throw new Exception("Invalid issuer DN: " + adnString, e);
            }
        }
        if (aid != null && adn != null) {
            throw new Exception("--issuer-id and --issuer-dn options are mutually exclusive");
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        NSSDatabase nssdb = mainCLI.getNSSDatabase();
        String password = mainCLI.config.getNSSPassword();
        if ("pkcs10".equals(requestType)) {
            if ("rsa".equals(algorithm)) {
                csr = this.generatePkcs10Request(nssdb.getDirectory(), password, algorithm, Integer.toString(length), (String)subjectDN);
            } else if ("ec".equals(algorithm)) {
                csr = this.generatePkcs10Request(nssdb.getDirectory(), password, algorithm, curve, (String)subjectDN);
            } else {
                throw new Exception("Error: Unknown algorithm: " + algorithm);
            }
            mainCLI.init();
            client = this.getClient();
        } else if ("crmf".equals(requestType)) {
            String encoded;
            mainCLI.init();
            client = this.getClient();
            boolean useOAEP = cmd.hasOption("oaep");
            if (transportCertFilename == null) {
                CASystemCertClient certClient = new CASystemCertClient(client, "ca");
                encoded = certClient.getTransportCert().getEncoded();
            } else {
                encoded = new String(Files.readAllBytes(Paths.get(transportCertFilename, new String[0])));
            }
            byte[] transportCertData = Cert.parseCertificate((String)encoded);
            CryptoManager manager = CryptoManager.getInstance();
            X509Certificate transportCert = manager.importCACertPackage(transportCertData);
            String kwAlg = CRMFPopClient.getKeyWrapAlgotihm(client);
            KeyWrapAlgorithm keyWrapAlgorithm = KeyWrapAlgorithm.fromString((String)kwAlg);
            csr = this.generateCrmfRequest(transportCert, (String)subjectDN, attributeEncoding, algorithm, length, curve, sslECDH, temporary, sensitive, extractable, withPop, keyWrapAlgorithm, useOAEP);
        } else {
            throw new Exception("Unknown request type: " + requestType);
        }
        logger.info("CSR:\n" + csr);
        CAClient caClient = new CAClient(client);
        CACertClient certClient = new CACertClient((SubsystemClient)caClient);
        logger.info("Retrieving " + profileID + " profile");
        CertEnrollmentRequest request = certClient.getEnrollmentTemplate(profileID);
        for (ProfileInput input : request.getInputs()) {
            ProfileAttribute csrAttr;
            ProfileAttribute typeAttr = input.getAttribute("cert_request_type");
            if (typeAttr != null) {
                typeAttr.setValue(requestType);
            }
            if ((csrAttr = input.getAttribute("cert_request")) == null) continue;
            csrAttr.setValue(csr);
        }
        DN dn = new DN((String)subjectDN);
        Vector rdns = dn.getRDNs();
        HashMap<String, String> subjectAttributes = new HashMap<String, String>();
        for (int i = 0; i < rdns.size(); ++i) {
            RDN rdn = (RDN)rdns.elementAt(i);
            String type = rdn.getTypes()[0].toLowerCase();
            String value = rdn.getValues()[0];
            subjectAttributes.put(type, value);
        }
        ProfileInput sn = request.getInput("Subject Name");
        if (sn != null) {
            logger.info("Subject Name:");
            for (ProfileAttribute attribute : sn.getAttributes()) {
                String name = attribute.getName();
                Object value = null;
                if (name.equals("subject")) {
                    value = subjectDN;
                } else if (name.startsWith("sn_")) {
                    value = (String)subjectAttributes.get(name.substring(3));
                } else {
                    logger.info("- " + name);
                    continue;
                }
                if (value == null) continue;
                logger.info("- " + name + ": " + (String)value);
                attribute.setValue((String)value);
            }
        }
        if (certRequestUsername != null) {
            request.setAttribute("uid", certRequestUsername);
        }
        if (cmd.hasOption("password")) {
            Console console = System.console();
            String certRequestPassword = new String(console.readPassword("Password: ", new Object[0]));
            request.setAttribute("pwd", certRequestPassword);
        }
        logger.info("Sending certificate request");
        CertRequestInfos infos = certClient.enrollRequest(request, aid, adn);
        CACertRequestCLI.printCertRequestInfos(infos);
    }

    public String generatePkcs10Request(File certDatabase, String password, String algorithm, String length, String subjectDN) throws Exception {
        File csrFile = File.createTempFile("pki-client-cert-request-", ".csr", certDatabase);
        csrFile.deleteOnExit();
        String lenOrCurve = "ec".equals(algorithm) ? "-c" : "-l";
        ArrayList<Object> command = new ArrayList<Object>();
        command.add("PKCS10Client");
        command.add("-d");
        command.add(certDatabase.getAbsolutePath());
        if (password != null) {
            command.add("-p");
            command.add(password);
        }
        command.add("-a");
        command.add(algorithm);
        command.add(lenOrCurve);
        command.add(length);
        command.add("-o");
        command.add(csrFile.getAbsolutePath());
        command.add("-n");
        command.add(subjectDN);
        try {
            this.runExternal(command);
        }
        catch (Exception e) {
            throw new Exception("Unable to generate CSR: " + e.getMessage(), e);
        }
        logger.info("CSR generated: " + csrFile);
        return new String(Files.readAllBytes(csrFile.toPath()));
    }

    public String generateCrmfRequest(X509Certificate transportCert, String subjectDN, boolean attributeEncoding, String algorithm, int length, String curve, boolean sslECDH, boolean temporary, int sensitive, int extractable, boolean withPop, KeyWrapAlgorithm keyWrapAlgorithm, boolean useOAEP) throws Exception {
        KeyPair keyPair;
        CryptoManager manager = CryptoManager.getInstance();
        CryptoToken token = manager.getThreadToken();
        CRMFPopClient client = new CRMFPopClient();
        client.setUseOAEP(useOAEP);
        Name subject = client.createName(subjectDN, attributeEncoding);
        if (algorithm.equals("rsa")) {
            usages = null;
            usagesMask = null;
            keyPair = CryptoUtil.generateRSAKeyPair((CryptoToken)token, (int)length, usages, usagesMask);
        } else if (algorithm.equals("ec")) {
            usages = null;
            usagesMask = sslECDH ? CryptoUtil.ECDH_USAGES_MASK : CryptoUtil.ECDHE_USAGES_MASK;
            keyPair = CryptoUtil.generateECCKeyPair((CryptoToken)token, (String)curve, (boolean)temporary, (int)sensitive, (int)extractable, usages, (KeyPairGeneratorSpi.Usage[])usagesMask);
        } else {
            throw new Exception("Unknown algorithm: " + algorithm);
        }
        CertRequest certRequest = client.createCertRequest(token, transportCert, algorithm, keyPair, subject, keyWrapAlgorithm);
        ProofOfPossession pop = null;
        if (withPop) {
            Signature signer = client.createSigner(token, algorithm, keyPair);
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            certRequest.encode((OutputStream)bo);
            signer.update(bo.toByteArray());
            byte[] signature = signer.sign();
            pop = client.createPop(algorithm, signature);
        }
        return client.createCRMFRequest(certRequest, pop);
    }
}

