/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.nss;

import com.netscape.certsrv.key.KeyData;
import com.netscape.certsrv.util.JSONSerializer;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.nss.NSSKeyCLI;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.io.IOUtils;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSSKeyImportCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(NSSKeyImportCLI.class);
    public NSSKeyCLI nssKeyCLI;

    public NSSKeyImportCLI(NSSKeyCLI nssKeyCLI) {
        super("import", "Import key into NSS database", (CLI)nssKeyCLI);
        this.nssKeyCLI = nssKeyCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...] <key nickname>", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "input", true, "File that contains the key to be imported");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "wrapper", true, "Nickname of the wrapper certificate");
        option.setArgName("nickname");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length < 1) {
            throw new Exception("Missing key nickname");
        }
        String nickname = cmdArgs[0];
        String inputFile = cmd.getOptionValue("input");
        String wrapperNickname = cmd.getOptionValue("wrapper");
        if (wrapperNickname == null) {
            throw new Exception("Missing wrapper certificate nickname");
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        byte[] bytes = inputFile == null ? IOUtils.toByteArray((InputStream)System.in) : Files.readAllBytes(Paths.get(inputFile, new String[0]));
        KeyData keyData = (KeyData)JSONSerializer.fromJSON((String)new String(bytes), KeyData.class);
        logger.info("Wrapped session key: " + keyData.getWrappedPrivateData());
        logger.info("Wrapped secret key: " + keyData.getAdditionalWrappedPrivateData());
        byte[] wrappedSessionKey = Utils.base64decode((String)keyData.getWrappedPrivateData());
        byte[] wrappedSecretKey = Utils.base64decode((String)keyData.getAdditionalWrappedPrivateData());
        CryptoUtil.importSharedSecret((byte[])wrappedSessionKey, (byte[])wrappedSecretKey, (String)wrapperNickname, (String)nickname);
    }
}

