/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tps.token;

import com.netscape.certsrv.tps.token.TokenClient;
import com.netscape.certsrv.tps.token.TokenData;
import com.netscape.certsrv.tps.token.TokenStatus;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.tps.token.TokenCLI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenModifyCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(TokenModifyCLI.class);
    public TokenCLI tokenCLI;

    public TokenModifyCLI(TokenCLI tokenCLI) {
        super("mod", "Modify token", (CLI)tokenCLI);
        this.tokenCLI = tokenCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <Token ID> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "user", true, "User ID");
        option.setArgName("User ID");
        this.options.addOption(option);
        option = new Option(null, "policy", true, "Policy");
        option.setArgName("Policy");
        this.options.addOption(option);
        option = new Option(null, "status", true, "Status");
        option.setArgName("Status");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String status;
        String policy;
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 1) {
            throw new Exception("No Token ID specified.");
        }
        TokenData tokenData = new TokenData();
        boolean modify = false;
        String tokenID = cmdArgs[0];
        tokenData.setID(tokenID);
        String userID = cmd.getOptionValue("user");
        if (userID != null) {
            tokenData.setUserID(userID);
            modify = true;
        }
        if ((policy = cmd.getOptionValue("policy")) != null) {
            tokenData.setPolicy(policy);
            modify = true;
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        TokenClient tokenClient = this.tokenCLI.getTokenClient();
        if (modify) {
            tokenData = tokenClient.modifyToken(tokenID, tokenData);
        }
        if ((status = cmd.getOptionValue("status")) != null) {
            tokenData = tokenClient.changeTokenStatus(tokenID, TokenStatus.valueOf((String)status));
        }
        if (!modify && status == null) {
            throw new Exception("No modifications specified.");
        }
        MainCLI.printMessage("Modified token \"" + tokenID + "\"");
        TokenCLI.printToken(tokenData);
    }
}

