/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.flex.checks.utils.Clazz;
import org.sonar.flex.checks.utils.Modifiers;

@Rule(key="S1446")
public class DynamicClassCheck
extends FlexCheck {
    @Override
    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.CLASS_DEF);
    }

    @Override
    public void visitNode(AstNode astNode) {
        if (astNode.getPreviousAstNode() != null && Modifiers.getModifiers(astNode.getPreviousAstNode()).contains(FlexKeyword.DYNAMIC)) {
            this.addIssue(MessageFormat.format("Make this \"{0}\" class non-dynamic", Clazz.getName(astNode)), astNode);
        }
    }
}

