/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonarsource.slang.api.BinaryExpressionTree;
import org.sonarsource.slang.api.BlockTree;
import org.sonarsource.slang.api.HasTextRange;
import org.sonarsource.slang.api.IfTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.api.UnaryExpressionTree;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SlangCheck;
import org.sonarsource.slang.checks.utils.ExpressionUtils;

@Rule(key="S1125")
public class BooleanLiteralCheck
implements SlangCheck {
    private static final List<BinaryExpressionTree.Operator> CONDITIONAL_BINARY_OPERATORS = Arrays.asList(BinaryExpressionTree.Operator.CONDITIONAL_AND, BinaryExpressionTree.Operator.CONDITIONAL_OR);
    private static final String MESSAGE = "Remove the unnecessary Boolean literal.";

    @Override
    public void initialize(InitContext init) {
        init.register(IfTree.class, (ctx, ifTree) -> {
            if (BooleanLiteralCheck.isIfWithMaxTwoBranches(ctx.parent(), ifTree) && !BooleanLiteralCheck.hasBlockBranch(ifTree)) {
                BooleanLiteralCheck.getBooleanLiteral(ifTree.thenBranch(), ifTree.elseBranch()).ifPresent(booleanLiteral -> ctx.reportIssue((HasTextRange)booleanLiteral, MESSAGE));
            }
        });
        init.register(BinaryExpressionTree.class, (ctx, binaryExprTree) -> {
            if (CONDITIONAL_BINARY_OPERATORS.contains((Object)binaryExprTree.operator())) {
                BooleanLiteralCheck.getBooleanLiteral(binaryExprTree.leftOperand(), binaryExprTree.rightOperand()).ifPresent(booleanLiteral -> ctx.reportIssue((HasTextRange)booleanLiteral, MESSAGE));
            }
        });
        init.register(UnaryExpressionTree.class, (ctx, unaryExprTree) -> {
            if (UnaryExpressionTree.Operator.NEGATE.equals((Object)unaryExprTree.operator())) {
                BooleanLiteralCheck.getBooleanLiteral(unaryExprTree.operand()).ifPresent(booleanLiteral -> ctx.reportIssue((HasTextRange)booleanLiteral, MESSAGE));
            }
        });
    }

    private static boolean isIfWithMaxTwoBranches(@Nullable Tree parent, IfTree ifTree) {
        boolean isElseIf = parent instanceof IfTree && ((IfTree)parent).elseBranch() == ifTree;
        boolean isIfElseIf = ifTree.elseBranch() instanceof IfTree;
        return !isElseIf && !isIfElseIf;
    }

    private static boolean hasBlockBranch(IfTree ifTree) {
        return ifTree.thenBranch() instanceof BlockTree || ifTree.elseBranch() instanceof BlockTree;
    }

    private static Optional<Tree> getBooleanLiteral(Tree ... trees) {
        return Arrays.stream(trees).map(ExpressionUtils::skipParentheses).filter(ExpressionUtils::isBooleanLiteral).findFirst();
    }
}

