/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.externalreport;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.analyzer.commons.xml.SafeStaxParserFactory;

public class CheckstyleFormatImporter {
    private static final Logger LOG = Loggers.get(CheckstyleFormatImporter.class);
    private static final Long DEFAULT_CONSTANT_DEBT_MINUTES = 5L;
    private static final QName CHECKSTYLE = new QName("checkstyle");
    private static final QName FILE = new QName("file");
    private static final QName ERROR = new QName("error");
    private static final QName NAME = new QName("name");
    private static final QName SEVERITY = new QName("severity");
    private static final QName SOURCE = new QName("source");
    private static final QName LINE = new QName("line");
    private static final QName MESSAGE = new QName("message");
    private final SensorContext context;
    protected final String linterKey;
    private int level = 0;
    @Nullable
    private InputFile inputFile = null;

    public CheckstyleFormatImporter(SensorContext context, String linterKey) {
        this.context = context;
        this.linterKey = linterKey;
    }

    public void importFile(File reportPath) {
        try (FileInputStream in = new FileInputStream(reportPath);){
            XMLEventReader reader = SafeStaxParserFactory.createXMLInputFactory().createXMLEventReader(in);
            this.level = 0;
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (event.isStartElement()) {
                    ++this.level;
                    this.onElement(event.asStartElement());
                    continue;
                }
                if (!event.isEndElement()) continue;
                --this.level;
            }
        }
        catch (IOException | RuntimeException | XMLStreamException e) {
            LOG.error("No issue information will be saved as the report file '{}' can't be read.", (Object)reportPath, (Object)e);
        }
    }

    private void onElement(StartElement element) throws IOException {
        if (this.level == 1 && !CHECKSTYLE.equals(element.getName())) {
            throw new IOException("Unexpected document root '" + element.getName().getLocalPart() + "' instead of 'checkstyle'.");
        }
        if (this.level == 2 && FILE.equals(element.getName())) {
            this.onFileElement(element);
        } else if (this.level == 3 && ERROR.equals(element.getName()) && this.inputFile != null) {
            this.onErrorElement(element);
        }
    }

    private void onFileElement(StartElement element) {
        String filePath = CheckstyleFormatImporter.getAttributeValue(element, NAME);
        if (filePath.isEmpty()) {
            this.inputFile = null;
            return;
        }
        FilePredicates predicates = this.context.fileSystem().predicates();
        this.inputFile = this.context.fileSystem().inputFile(predicates.or(predicates.hasAbsolutePath(filePath), predicates.hasRelativePath(filePath)));
        if (this.inputFile == null) {
            LOG.warn("No input file found for {}. No " + this.linterKey + " issues will be imported on this file.", (Object)filePath);
        }
    }

    private void onErrorElement(StartElement element) {
        String source = CheckstyleFormatImporter.getAttributeValue(element, SOURCE);
        String line = CheckstyleFormatImporter.getAttributeValue(element, LINE);
        String severity = CheckstyleFormatImporter.getAttributeValue(element, SEVERITY);
        String message = CheckstyleFormatImporter.getAttributeValue(element, MESSAGE);
        if (message.isEmpty()) {
            LOG.debug("Unexpected error without any message for rule: '{}'", (Object)source);
            return;
        }
        this.saveIssue(line, severity, source, message);
    }

    private void saveIssue(String line, String severity, String source, String message) {
        RuleType ruleType = this.ruleType(severity, source);
        Severity ruleSeverity = this.severity(severity);
        RuleKey ruleKey = this.createRuleKey(source, ruleType, ruleSeverity);
        NewExternalIssue newExternalIssue = this.context.newExternalIssue().type(ruleType).severity(ruleSeverity).remediationEffortMinutes(this.effort(ruleKey.rule()));
        NewIssueLocation primaryLocation = newExternalIssue.newLocation().message(message).on((InputComponent)this.inputFile);
        if (!line.isEmpty()) {
            primaryLocation.at(this.inputFile.selectLine(Integer.parseInt(line)));
        }
        newExternalIssue.at(primaryLocation).engineId(ruleKey.repository()).ruleId(ruleKey.rule()).save();
    }

    protected RuleKey createRuleKey(String source, RuleType ruleType, Severity ruleSeverity) {
        return RuleKey.of((String)this.linterKey, (String)source);
    }

    protected RuleType ruleType(@Nullable String severity, String source) {
        return "error".equals(severity) ? RuleType.BUG : RuleType.CODE_SMELL;
    }

    protected Severity severity(@Nullable String severity) {
        return "info".equals(severity) ? Severity.MINOR : Severity.MAJOR;
    }

    protected Long effort(String ruleKey) {
        return DEFAULT_CONSTANT_DEBT_MINUTES;
    }

    private static String getAttributeValue(StartElement element, QName attributeName) {
        Attribute attribute = element.getAttributeByName(attributeName);
        return attribute != null ? attribute.getValue() : "";
    }
}

