/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.plugin;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.slang.checks.utils.Language;
import org.sonarsource.slang.checks.utils.PropertyDefaultValue;
import org.sonarsource.slang.checks.utils.PropertyDefaultValues;

public class RulesDefinitionUtils {
    private RulesDefinitionUtils() {
    }

    public static void setDefaultValuesForParameters(RulesDefinition.NewRepository repository, List<Class<?>> checks, Language language) {
        for (Class<?> check : checks) {
            Rule ruleAnnotation = (Rule)AnnotationUtils.getAnnotation(check, Rule.class);
            String ruleKey = ruleAnnotation.key();
            for (Field field : check.getDeclaredFields()) {
                RuleProperty ruleProperty = field.getAnnotation(RuleProperty.class);
                PropertyDefaultValues defaultValues = field.getAnnotation(PropertyDefaultValues.class);
                if (ruleProperty == null || defaultValues == null) continue;
                String paramKey = ruleProperty.key();
                List<PropertyDefaultValue> valueForLanguage = Arrays.stream(defaultValues.value()).filter(defaultValue -> defaultValue.language() == language).collect(Collectors.toList());
                if (valueForLanguage.size() != 1) {
                    throw new IllegalStateException("Invalid @PropertyDefaultValue on " + check.getSimpleName() + " for language " + (Object)((Object)language));
                }
                valueForLanguage.forEach(defaultValue -> repository.rule(ruleKey).param(paramKey).setDefaultValue(defaultValue.defaultValue()));
            }
        }
    }
}

