/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XmlReportParser {
    private final Path xmlReportPath;
    private static final String COLUMN = " column ";

    public XmlReportParser(Path xmlReportPath) {
        this.xmlReportPath = xmlReportPath;
    }

    public List<SourceFile> parse() {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isNamespaceAware", false);
        factory.setProperty("javax.xml.stream.supportDTD", false);
        XMLStreamReader xmlStreamReaderParser = null;
        try {
            ArrayList<SourceFile> arrayList;
            block23: {
                BufferedReader reader = Files.newBufferedReader(this.xmlReportPath, StandardCharsets.UTF_8);
                try {
                    XMLStreamReader parser = xmlStreamReaderParser = factory.createXMLStreamReader(reader);
                    ArrayList<SourceFile> sourceFiles = new ArrayList<SourceFile>();
                    String packageName = null;
                    String sourceFileName = null;
                    while (true) {
                        String element;
                        int event;
                        if ((event = parser.next()) == 8) break;
                        if (event == 2) {
                            element = parser.getLocalName();
                            if (element.equals("package")) {
                                packageName = null;
                                continue;
                            }
                            if (!element.equals("sourcefile")) continue;
                            sourceFileName = null;
                            continue;
                        }
                        if (event != 1) continue;
                        element = parser.getLocalName();
                        if (element.equals("package")) {
                            packageName = XmlReportParser.getStringAttr(parser, "name", () -> "for a 'package' at line " + parser.getLocation().getLineNumber() + COLUMN + parser.getLocation().getColumnNumber());
                            continue;
                        }
                        if (element.equals("sourcefile")) {
                            if (packageName == null) {
                                throw new IllegalStateException("Invalid report: expected to find 'sourcefile' within a 'package' at line " + parser.getLocation().getLineNumber() + COLUMN + parser.getLocation().getColumnNumber());
                            }
                            sourceFileName = XmlReportParser.getStringAttr(parser, "name", () -> "for a sourcefile at line " + parser.getLocation().getLineNumber() + COLUMN + parser.getLocation().getColumnNumber());
                            sourceFiles.add(new SourceFile(packageName, sourceFileName));
                            continue;
                        }
                        if (!element.equals("line")) continue;
                        if (sourceFileName == null) {
                            throw new IllegalStateException("Invalid report: expected to find 'line' within a 'sourcefile' at line " + parser.getLocation().getLineNumber() + COLUMN + parser.getLocation().getColumnNumber());
                        }
                        SourceFile file = (SourceFile)sourceFiles.get(sourceFiles.size() - 1);
                        Supplier<String> errorCtx = () -> "for the sourcefile '" + file.name() + "' at line " + parser.getLocation().getLineNumber() + COLUMN + parser.getLocation().getColumnNumber();
                        Line line = new Line(XmlReportParser.getIntAttr(parser, "nr", errorCtx), XmlReportParser.getOptionalIntAttr(parser, "mi", errorCtx), XmlReportParser.getOptionalIntAttr(parser, "ci", errorCtx), XmlReportParser.getOptionalIntAttr(parser, "mb", errorCtx), XmlReportParser.getOptionalIntAttr(parser, "cb", errorCtx));
                        file.lines().add(line);
                    }
                    parser.close();
                    arrayList = sourceFiles;
                    if (reader == null) break block23;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | XMLStreamException e) {
                        throw new IllegalStateException("Failed to parse JaCoCo XML report: " + this.xmlReportPath.toAbsolutePath(), e);
                    }
                }
                ((Reader)reader).close();
            }
            return arrayList;
        }
        finally {
            if (xmlStreamReaderParser != null) {
                try {
                    xmlStreamReaderParser.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
    }

    private static String getStringAttr(XMLStreamReader parser, String name, Supplier<String> errorContext) {
        String value = parser.getAttributeValue(null, name);
        if (value == null) {
            throw new IllegalStateException("Invalid report: couldn't find the attribute '" + name + "' " + errorContext.get());
        }
        return value;
    }

    private static int getOptionalIntAttr(XMLStreamReader parser, String name, Supplier<String> errorContext) {
        String value = parser.getAttributeValue(null, name);
        if (value == null) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid report: failed to parse integer from the attribute '" + name + "' " + errorContext.get());
        }
    }

    private static int getIntAttr(XMLStreamReader parser, String name, Supplier<String> errorContext) {
        String value = XmlReportParser.getStringAttr(parser, name, errorContext);
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid report: failed to parse integer from the attribute '" + name + "' " + errorContext.get());
        }
    }

    static class Line {
        private int number;
        private int missedInstrs;
        private int coveredInstrs;
        private int missedBranches;
        private int coveredBranches;

        Line(int number, int mi, int ci, int mb, int cb) {
            this.number = number;
            this.missedInstrs = mi;
            this.coveredInstrs = ci;
            this.missedBranches = mb;
            this.coveredBranches = cb;
        }

        public int number() {
            return this.number;
        }

        public int missedInstrs() {
            return this.missedInstrs;
        }

        public int coveredInstrs() {
            return this.coveredInstrs;
        }

        public int missedBranches() {
            return this.missedBranches;
        }

        public int coveredBranches() {
            return this.coveredBranches;
        }
    }

    static class SourceFile {
        private String name;
        private String packageName;
        private List<Line> lines = new ArrayList<Line>();

        SourceFile(String packageName, String name) {
            this.name = name;
            this.packageName = packageName;
        }

        public String name() {
            return this.name;
        }

        public String packageName() {
            return this.packageName;
        }

        public List<Line> lines() {
            return this.lines;
        }
    }
}

