/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.cloudformation.checks.utils.XPathUtils;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.PropertyTree;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.yaml.tree.MappingTree;
import org.sonar.iac.common.yaml.tree.ScalarTree;
import org.sonar.iac.common.yaml.tree.SequenceTree;
import org.sonar.iac.common.yaml.tree.YamlTree;

@Rule(key="S5332")
public class ClearTextProtocolsCheck
extends AbstractResourceCheck {
    public static final String MESSAGE_CLEAR_TEXT = "Make sure allowing clear-text traffic is safe here.";
    public static final String MESSAGE_OMITTING_FORMAT = "Omitting \"%s\" enables clear-text traffic. Make sure it is safe here.";

    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (resource.isType("AWS::MSK::Cluster")) {
            ClearTextProtocolsCheck.checkMskCluster(ctx, resource);
        } else if (resource.isType("AWS::OpenSearchService::Domain") || resource.isType("AWS::Elasticsearch::Domain")) {
            ClearTextProtocolsCheck.checkSearchDomain(ctx, resource);
        } else if (resource.isType("AWS::ElasticLoadBalancingV2::Listener")) {
            ClearTextProtocolsCheck.checkLoadBalancingListener(ctx, resource);
        } else if (resource.isType("AWS::ECS::TaskDefinition")) {
            ClearTextProtocolsCheck.checkEcsTaskDefinition(ctx, resource);
        } else if (resource.isType("AWS::ElastiCache::ReplicationGroup")) {
            ClearTextProtocolsCheck.checkESReplicationGroup(ctx, resource);
        } else if (resource.isType("AWS::Kinesis::Stream")) {
            ClearTextProtocolsCheck.checkKinesisStream(ctx, resource);
        }
    }

    private static void checkMskCluster(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        PropertyUtils.value(resource.properties(), "EncryptionInfo", MappingTree.class).flatMap(e -> PropertyUtils.value(e, "EncryptionInTransit", MappingTree.class)).ifPresent(e -> {
            ClearTextProtocolsCheck.checkClientBroker(ctx, e);
            ClearTextProtocolsCheck.reportOnFalseProperty(ctx, e, "InCluster", MESSAGE_CLEAR_TEXT);
        });
    }

    private static void checkClientBroker(CheckContext ctx, MappingTree e) {
        PropertyUtils.value(e, "ClientBroker", ScalarTree.class).filter(clientBroker -> !"TLS".equals(clientBroker.value())).ifPresent(clientBroker -> ctx.reportIssue((HasTextRange)clientBroker, MESSAGE_CLEAR_TEXT));
    }

    private static void checkSearchDomain(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        PropertyUtils.value((Tree)resource.properties(), "NodeToNodeEncryptionOptions").ifPresentOrElse(v -> ClearTextProtocolsCheck.reportOnFalseProperty(ctx, v, "Enabled", MESSAGE_CLEAR_TEXT), () -> ClearTextProtocolsCheck.reportResource(ctx, resource, ClearTextProtocolsCheck.omittingMessage("NodeToNodeEncryptionOptions")));
        PropertyUtils.get((Tree)resource.properties(), "DomainEndpointOptions").ifPresentOrElse(v -> ClearTextProtocolsCheck.checkDomainEnforceHttp(ctx, v), () -> ClearTextProtocolsCheck.reportResource(ctx, resource, ClearTextProtocolsCheck.omittingMessage("DomainEndpointOptions")));
    }

    private static void checkDomainEnforceHttp(CheckContext ctx, PropertyTree domainEndpointOptions) {
        String enforceHTTPSKey = "EnforceHTTPS";
        if (PropertyUtils.isMissing(domainEndpointOptions.value(), enforceHTTPSKey)) {
            ctx.reportIssue(domainEndpointOptions.key(), ClearTextProtocolsCheck.omittingMessage(enforceHTTPSKey));
        }
        ClearTextProtocolsCheck.reportOnFalseProperty(ctx, domainEndpointOptions.value(), enforceHTTPSKey, MESSAGE_CLEAR_TEXT);
    }

    private static void checkLoadBalancingListener(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        Optional<Tree> rootProtocol = PropertyUtils.value((Tree)resource.properties(), "Protocol");
        if (rootProtocol.isEmpty() || !TextUtils.isValue(rootProtocol.get(), "HTTP").isTrue()) {
            return;
        }
        Optional<SequenceTree> defaultActions = PropertyUtils.value(resource.properties(), "DefaultActions", SequenceTree.class);
        if (defaultActions.isEmpty()) {
            return;
        }
        if (defaultActions.get().elements().stream().anyMatch(a -> ClearTextProtocolsCheck.isFixedResponseOrForwardAction(a) || ClearTextProtocolsCheck.isRedirectToHttpAction(a))) {
            ctx.reportIssue(rootProtocol.get(), MESSAGE_CLEAR_TEXT);
        }
    }

    private static boolean isFixedResponseOrForwardAction(YamlTree action) {
        Tree type = PropertyUtils.valueOrNull(action, "Type");
        return TextUtils.isValue(type, "fixed-response").isTrue() || TextUtils.isValue(type, "forward").isTrue();
    }

    private static boolean isRedirectToHttpAction(YamlTree action) {
        return TextUtils.isValue(PropertyUtils.valueOrNull(action, "Type"), "redirect").isTrue() && TextUtils.isValue(XPathUtils.getSingleTree(action, "/RedirectConfig/Protocol").orElse(null), "HTTP").isTrue();
    }

    private static void checkEcsTaskDefinition(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        PropertyUtils.value(resource.properties(), "Volumes", SequenceTree.class).ifPresent(volumes -> volumes.elements().forEach(v -> ClearTextProtocolsCheck.checkEcsTaskDefinitionVolume(ctx, v)));
    }

    private static void checkEcsTaskDefinitionVolume(CheckContext ctx, YamlTree volume) {
        Optional<PropertyTree> configuration = PropertyUtils.get((Tree)volume, "EFSVolumeConfiguration");
        if (configuration.isEmpty()) {
            return;
        }
        Optional<Tree> transitEncryption = PropertyUtils.value(configuration.get().value(), "TransitEncryption");
        if (transitEncryption.isPresent() && TextUtils.isValue(transitEncryption.get(), "DISABLED").isTrue()) {
            ctx.reportIssue(transitEncryption.get(), MESSAGE_CLEAR_TEXT);
        } else if (transitEncryption.isEmpty()) {
            ctx.reportIssue(configuration.get().key(), ClearTextProtocolsCheck.omittingMessage("TransitEncryption"));
        }
    }

    private static void checkESReplicationGroup(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        String encryptionPropertyKey = "TransitEncryptionEnabled";
        if (PropertyUtils.isMissing(resource.properties(), encryptionPropertyKey)) {
            ClearTextProtocolsCheck.reportResource(ctx, resource, ClearTextProtocolsCheck.omittingMessage(encryptionPropertyKey));
        } else {
            ClearTextProtocolsCheck.reportOnFalseProperty(ctx, resource.properties(), encryptionPropertyKey, MESSAGE_CLEAR_TEXT);
        }
    }

    private static void checkKinesisStream(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (PropertyUtils.isMissing(resource.properties(), "StreamEncryption")) {
            ClearTextProtocolsCheck.reportResource(ctx, resource, ClearTextProtocolsCheck.omittingMessage("StreamEncryption"));
        }
    }

    private static void reportOnFalseProperty(CheckContext ctx, @Nullable Tree tree, String propertyName, String message) {
        PropertyUtils.value(tree, propertyName, ScalarTree.class).filter(TextUtils::isValueFalse).ifPresent(clientBroker -> ctx.reportIssue((HasTextRange)clientBroker, message));
    }

    private static String omittingMessage(String domainEndpointOptions) {
        return String.format(MESSAGE_OMITTING_FORMAT, domainEndpointOptions);
    }
}

