/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.reports;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Objects;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.iac.cloudformation.plugin.CfnLintRulesDefinition;
import org.sonarsource.analyzer.commons.internal.json.simple.JSONArray;
import org.sonarsource.analyzer.commons.internal.json.simple.JSONObject;
import org.sonarsource.analyzer.commons.internal.json.simple.parser.JSONParser;
import org.sonarsource.analyzer.commons.internal.json.simple.parser.ParseException;

public class CfnLintImporter {
    private static final Logger LOG = Loggers.get(CfnLintImporter.class);
    private static final JSONParser jsonParser = new JSONParser();
    public static final String LINE_NUMBER_KEY = "LineNumber";
    public static final String COLUMN_NUMBER_KEY = "ColumnNumber";

    private CfnLintImporter() {
    }

    public static void importReport(SensorContext context, File reportFile, AnalysisWarnings analysisWarnings) {
        JSONArray issuesJson;
        String path = reportFile.getPath();
        if (!reportFile.isFile()) {
            String message = String.format("Cfn-lint report importing: path does not seem to point to a file %s", path);
            CfnLintImporter.logWarnAndAddUnique(analysisWarnings, message);
            return;
        }
        try {
            issuesJson = (JSONArray)jsonParser.parse(Files.newBufferedReader(reportFile.toPath()));
        }
        catch (IOException e) {
            String message = String.format("Cfn-lint report importing: could not read report file %s", path);
            CfnLintImporter.logWarnAndAddUnique(analysisWarnings, message);
            return;
        }
        catch (ParseException e) {
            String message = String.format("Cfn-lint report importing: could not parse file as JSON %s", path);
            CfnLintImporter.logWarnAndAddUnique(analysisWarnings, message);
            return;
        }
        catch (RuntimeException e) {
            String message = String.format("Cfn-lint report importing: file is expected to contain a JSON array but didn't %s", path);
            CfnLintImporter.logWarnAndAddUnique(analysisWarnings, message);
            return;
        }
        int failedToSaveIssues = 0;
        for (Object issueJson : issuesJson) {
            try {
                CfnLintImporter.saveAsExternalIssue(context, (JSONObject)issueJson);
            }
            catch (RuntimeException e) {
                LOG.debug("Cfn-lint report importing: failed to save issue", (Object)e);
                ++failedToSaveIssues;
            }
        }
        if (failedToSaveIssues > 0) {
            String message = String.format("Cfn-lint report importing: could not save %d out of %d issues from %s", failedToSaveIssues, issuesJson.size(), path);
            CfnLintImporter.logWarnAndAddUnique(analysisWarnings, message);
        }
    }

    private static void saveAsExternalIssue(SensorContext context, JSONObject issueJson) {
        String path = (String)issueJson.get("Filename");
        FilePredicates predicates = context.fileSystem().predicates();
        InputFile inputFile = context.fileSystem().inputFile(predicates.or(predicates.hasAbsolutePath(path), predicates.hasRelativePath(path)));
        Objects.requireNonNull(inputFile);
        String ruleId = (String)((JSONObject)issueJson.get("Rule")).get("Id");
        if (!CfnLintRulesDefinition.RULE_LOADER.ruleKeys().contains(ruleId)) {
            ruleId = "cfn-lint.fallback";
        }
        NewExternalIssue externalIssue = context.newExternalIssue().ruleId(ruleId).type(CfnLintRulesDefinition.RULE_LOADER.ruleType(ruleId)).engineId("cfn-lint").severity(CfnLintRulesDefinition.RULE_LOADER.ruleSeverity(ruleId)).remediationEffortMinutes(CfnLintRulesDefinition.RULE_LOADER.ruleConstantDebtMinutes(ruleId));
        externalIssue.at(CfnLintImporter.getIssueLocation(issueJson, externalIssue, inputFile));
        externalIssue.save();
    }

    private static NewIssueLocation getIssueLocation(JSONObject issueJson, NewExternalIssue externalIssue, InputFile inputFile) {
        TextRange range;
        JSONObject issueJsonLocation = (JSONObject)issueJson.get("Location");
        JSONObject start = (JSONObject)issueJsonLocation.get("Start");
        JSONObject end = (JSONObject)issueJsonLocation.get("End");
        try {
            range = inputFile.newRange(CfnLintImporter.getIntOutOfJson(start.get(LINE_NUMBER_KEY)), CfnLintImporter.getIntOutOfJson(start.get(COLUMN_NUMBER_KEY)) - 1, CfnLintImporter.getIntOutOfJson(end.get(LINE_NUMBER_KEY)), CfnLintImporter.getIntOutOfJson(end.get(COLUMN_NUMBER_KEY)) - 1);
        }
        catch (IllegalArgumentException e) {
            range = inputFile.selectLine(CfnLintImporter.getIntOutOfJson(end.get(LINE_NUMBER_KEY)));
        }
        return externalIssue.newLocation().message((String)issueJson.get("Message")).on((InputComponent)inputFile).at(range);
    }

    private static int getIntOutOfJson(Object o) {
        return Math.toIntExact((Long)o);
    }

    private static void logWarnAndAddUnique(AnalysisWarnings analysisWarnings, String message) {
        LOG.warn(message);
        analysisWarnings.addUnique(message);
    }
}

