/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.checks;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.tree.TextTree;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.Trilean;

public class TextUtils {
    private TextUtils() {
    }

    public static Optional<String> getValue(@Nullable Tree tree) {
        if (tree instanceof TextTree) {
            return Optional.ofNullable(((TextTree)tree).value());
        }
        return Optional.empty();
    }

    public static Optional<Integer> getIntValue(@Nullable Tree tree) {
        Optional<String> stringValue = TextUtils.getValue(tree);
        if (stringValue.isPresent()) {
            try {
                return Optional.of(Integer.valueOf(stringValue.get()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public static Trilean isValue(@Nullable Tree tree, String expectedValue) {
        return TextUtils.matchesValue(tree, expectedValue::equalsIgnoreCase);
    }

    public static Trilean matchesValue(@Nullable Tree tree, Predicate<String> matcher) {
        if (tree instanceof TextTree) {
            return matcher.test(((TextTree)tree).value()) ? Trilean.TRUE : Trilean.FALSE;
        }
        return Trilean.UNKNOWN;
    }

    public static boolean isValueTrue(@Nullable Tree tree) {
        return TextUtils.isValue(tree, "true").isTrue();
    }

    public static boolean isValueFalse(@Nullable Tree tree) {
        return TextUtils.isValue(tree, "false").isTrue();
    }
}

