/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.iac.common.yaml.TreePredicates;
import org.sonar.iac.common.yaml.object.BlockObject;
import org.sonar.iac.kubernetes.checks.AbstractKubernetesObjectCheck;

@Rule(key="S6431")
public class HostNamespacesCheck
extends AbstractKubernetesObjectCheck {
    private static final String MESSAGE = "Make sure it is safe to use host operating system namespaces here.";
    private static final List<String> HOST_NAMESPACES_ATTRIBUTES = List.of("hostPID", "hostIPC", "hostNetwork");

    @Override
    void registerObjectCheck() {
        this.register("Pod", (BlockObject pod) -> HOST_NAMESPACES_ATTRIBUTES.forEach(name -> pod.attribute((String)name).reportIfValue(TreePredicates.isTrue(), MESSAGE)));
        this.register(List.of("DaemonSet", "Deployment", "Job", "ReplicaSet", "ReplicationController", "StatefulSet"), (BlockObject obj) -> HOST_NAMESPACES_ATTRIBUTES.forEach(name -> obj.block("template").block("spec").attribute((String)name).reportIfValue(TreePredicates.isTrue(), MESSAGE)));
    }
}

