/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.terraform.checks.aws.AwsIpRestrictedAdminAccessCheckPart;
import org.sonar.iac.terraform.checks.azure.AzureIpRestrictedAdminAccessCheckPart;
import org.sonar.iac.terraform.checks.gcp.GcpIpRestrictedAdminAccessCheckPart;

@Rule(key="S6321")
public class IpRestrictedAdminAccessCheck
implements IacCheck {
    public static final String MESSAGE = "Restrict IP addresses authorized to access administration services.";
    public static final String SECONDARY_MSG = "Related protocol setting.";
    public static final String ALL_IPV4 = "0.0.0.0/0";
    public static final String ALL_IPV6 = "::/0";
    public static final int SSH_PORT = 22;
    public static final int RDP_PORT = 3389;
    private static final Pattern PORT_RANGE_PATTERN = Pattern.compile("^(?<from>\\d{1,5})-(?<to>\\d{1,5})$");
    private static final Set<String> SENSITIVE_PORTS = Set.of("*", String.valueOf(22), String.valueOf(3389));

    @Override
    public void initialize(InitContext init) {
        new AwsIpRestrictedAdminAccessCheckPart().initialize(init);
        new AzureIpRestrictedAdminAccessCheckPart().initialize(init);
        new GcpIpRestrictedAdminAccessCheckPart().initialize(init);
    }

    public static boolean rangeContainsSshOrRdpPort(String range) {
        if (range.contains("-")) {
            Matcher m = PORT_RANGE_PATTERN.matcher(range);
            if (m.find()) {
                return IpRestrictedAdminAccessCheck.rangeContainsSshOrRdpPort(IpRestrictedAdminAccessCheck.portFromMatch(m, "from"), IpRestrictedAdminAccessCheck.portFromMatch(m, "to"));
            }
            return false;
        }
        return SENSITIVE_PORTS.contains(range);
    }

    private static int portFromMatch(Matcher m, String group) {
        return Integer.parseInt(m.group(group));
    }

    public static boolean rangeContainsSshOrRdpPort(int from, int to) {
        return 22 >= from && 22 <= to || 3389 >= from && 3389 <= to;
    }
}

