/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.azure;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

@Rule(key="S6380")
public class AnonymousAccessToResourceCheck
extends AbstractResourceCheck {
    private static final String APP_AUTH_MISSING_MESSAGE = "Omitting 'auth_settings' disables authentication. Make sure it is safe here.";
    private static final String DISABLED_AUTH_MESSAGE = "Make sure that disabling authentication is safe here.";
    private static final String API_MANAGEMENT_API_MESSAGE = "Omitting 'openid_authentication' disables authentication. Make sure it is safe here.";
    private static final String API_MANAGEMENT_MISSING_MESSAGE = "Omitting 'sign_in' authorizes anonymous access. Make sure it is safe here.";
    private static final String API_MANAGEMENT_DISABLED_MESSAGE = "Make sure that giving anonymous access without enforcing sign-in is safe here.";
    private static final String DATA_FACTORY_LINKED_SERVICE_ODATA_MESSAGE = "Omitting the 'basic_authentication' block disables authentication. Make sure it is safe here.";
    private static final String AUTHORIZING_ANONYMOUS_MESSAGE = "Make sure that authorizing anonymous access is safe here.";
    private static final String AUTHORIZING_POTENTIAL_ANONYMOUS_MESSAGE = "Make sure that authorizing potential anonymous access is safe here.";

    @Override
    protected void registerResourceChecks() {
        this.register(AnonymousAccessToResourceCheck::checkResourceAuthSettings, "azurerm_app_service", "azurerm_app_service_slot", "azurerm_function_app", "azurerm_function_app_slot", "azurerm_windows_web_app", "azurerm_linux_web_app");
        this.register(AnonymousAccessToResourceCheck::checkApiManagementApi, "azurerm_api_management_api");
        this.register(AnonymousAccessToResourceCheck::checkApiManagement, "azurerm_api_management");
        this.register(AnonymousAccessToResourceCheck::checkDataFactorLinkServiceOdata, "azurerm_data_factory_linked_service_odata");
        this.register(AnonymousAccessToResourceCheck::checkDataFactorLinkServiceWebAndSftp, "azurerm_data_factory_linked_service_sftp", "azurerm_data_factory_linked_service_web");
        this.register(AnonymousAccessToResourceCheck::checkRedisCache, "azurerm_redis_cache");
        this.register(AnonymousAccessToResourceCheck::checkStorageAccount, "azurerm_storage_account");
        this.register(AnonymousAccessToResourceCheck::checkStorageContainer, "azurerm_storage_container");
    }

    private static void checkResourceAuthSettings(CheckContext ctx, BlockTree resource) {
        List<BlockTree> authSettings = PropertyUtils.getAll(resource, "auth_settings", BlockTree.class);
        if (authSettings.isEmpty()) {
            AnonymousAccessToResourceCheck.reportResource(ctx, resource, APP_AUTH_MISSING_MESSAGE);
        } else {
            authSettings.forEach(settings -> AnonymousAccessToResourceCheck.checkAuthSettings(ctx, settings));
        }
    }

    private static void checkAuthSettings(CheckContext ctx, BlockTree authSettings) {
        PropertyUtils.get(authSettings, "enabled", AttributeTree.class).filter(enabled -> TextUtils.isValueFalse(enabled.value())).ifPresentOrElse(disabled -> ctx.reportIssue((HasTextRange)disabled, DISABLED_AUTH_MESSAGE), () -> PropertyUtils.get(authSettings, "unauthenticated_client_action", AttributeTree.class).ifPresentOrElse(action -> AnonymousAccessToResourceCheck.reportSensitiveValue(ctx, action, "AllowAnonymous", AUTHORIZING_ANONYMOUS_MESSAGE, new SecondaryLocation[0]), () -> ctx.reportIssue(authSettings, AUTHORIZING_ANONYMOUS_MESSAGE)));
    }

    private static void checkApiManagementApi(CheckContext ctx, BlockTree resource) {
        if (PropertyUtils.isMissing(resource, "openid_authentication")) {
            AnonymousAccessToResourceCheck.reportResource(ctx, resource, API_MANAGEMENT_API_MESSAGE);
        }
    }

    private static void checkApiManagement(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "sign_in", BlockTree.class).ifPresentOrElse(signIn -> PropertyUtils.get(signIn, "enabled", AttributeTree.class).ifPresent(enabled -> AnonymousAccessToResourceCheck.reportOnFalse(ctx, enabled, API_MANAGEMENT_DISABLED_MESSAGE, new SecondaryLocation[0])), () -> AnonymousAccessToResourceCheck.reportResource(ctx, resource, API_MANAGEMENT_MISSING_MESSAGE));
    }

    private static void checkDataFactorLinkServiceOdata(CheckContext ctx, BlockTree resource) {
        if (PropertyUtils.isMissing(resource, "basic_authentication")) {
            AnonymousAccessToResourceCheck.reportResource(ctx, resource, DATA_FACTORY_LINKED_SERVICE_ODATA_MESSAGE);
        }
    }

    private static void checkDataFactorLinkServiceWebAndSftp(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "authentication_type", AttributeTree.class).ifPresent(authentication -> AnonymousAccessToResourceCheck.reportSensitiveValue(ctx, authentication, "Anonymous", AUTHORIZING_ANONYMOUS_MESSAGE, new SecondaryLocation[0]));
    }

    private static void checkRedisCache(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "redis_configuration", BlockTree.class).flatMap(config -> PropertyUtils.get(config, "enable_authentication", AttributeTree.class)).ifPresent(authentication -> AnonymousAccessToResourceCheck.reportOnFalse(ctx, authentication, DISABLED_AUTH_MESSAGE, new SecondaryLocation[0]));
    }

    private static void checkStorageAccount(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "allow_blob_public_access", AttributeTree.class).ifPresent(publicAccess -> AnonymousAccessToResourceCheck.reportOnTrue(ctx, publicAccess, AUTHORIZING_POTENTIAL_ANONYMOUS_MESSAGE, new SecondaryLocation[0]));
    }

    private static void checkStorageContainer(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "container_access_type", AttributeTree.class).ifPresent(attr -> AnonymousAccessToResourceCheck.reportUnexpectedValue(ctx, attr, "private", AUTHORIZING_POTENTIAL_ANONYMOUS_MESSAGE, new SecondaryLocation[0]));
    }
}

