/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.azure;

import java.util.HashMap;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.TextTree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.extension.visitors.TreeContext;
import org.sonar.iac.common.extension.visitors.TreeVisitor;
import org.sonar.iac.terraform.api.tree.AttributeAccessTree;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.api.tree.FileTree;
import org.sonar.iac.terraform.api.tree.TerraformTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

@Rule(key="S6375")
public class HigherPrivilegedRoleAssignmentCheck
implements IacCheck {
    private static final Map<String, String> HIGHER_PRIVILEGED_ROLE = Map.of("9b895d92-2cd3-44c7-9d02-a6ac2d5ea5c3", "Application Administrator", "c4e39bd9-1100-46d3-8c65-fb160da0071f", "Authentication Administrator", "158c047a-c907-4556-b7ef-446551a6b5f7", "Cloud Application Administrator", "62e90394-69f5-4237-9190-012177145e10", "Global Administrator", "dd7a751-b60b-444a-984c-02652fe8fa1c", "Groups Administrator", "729827e3-9c14-49f7-bb1b-9608f156bbb8", "Helpdesk Administrator", "966707d0-3269-4727-9be2-8c3a10f19b9d", "Password Administrator", "7be44c8a-adaf-4e2a-84d6-ab2649e08a13", "Privileged Authentication Administrator", "e8611ab8-c189-46e8-94e1-60213ab1f814", "Privileged Role Administrator", "fe930be7-5e62-47db-91af-98c3a49a38b1", "User Administrator");
    private static final String MESSAGE = "Make sure that assigning the %s role is safe here.";
    private static final String SECONDARY_MESSAGE = "Role assigned here.";

    @Override
    public void initialize(InitContext init) {
        init.register(FileTree.class, (ctx, tree) -> {
            HigherPrivilegedRoleCollector collector = HigherPrivilegedRoleCollector.collect(tree);
            HigherPrivilegedRoleAssignmentCheck.checkAssignedRolePrivileges(ctx, collector);
        });
    }

    private static void checkAssignedRolePrivileges(CheckContext ctx, HigherPrivilegedRoleCollector collector) {
        collector.roleMember.entrySet().stream().filter(member -> collector.higherPrivilegedRoles.containsKey(member.getKey())).forEach(member -> {
            AttributeTree role = collector.higherPrivilegedRoles.get(member.getKey());
            SecondaryLocation secondary = new SecondaryLocation((HasTextRange)member.getValue(), SECONDARY_MESSAGE);
            ctx.reportIssue((HasTextRange)role, HigherPrivilegedRoleAssignmentCheck.message(((TextTree)((Object)role.value())).value()), secondary);
        });
    }

    private static String message(String role) {
        return String.format(MESSAGE, HIGHER_PRIVILEGED_ROLE.getOrDefault(role, role));
    }

    private static class HigherPrivilegedRoleCollector
    extends TreeVisitor<TreeContext> {
        private final Map<String, AttributeTree> higherPrivilegedRoles = new HashMap<String, AttributeTree>();
        private final Map<String, AttributeTree> roleMember = new HashMap<String, AttributeTree>();

        public HigherPrivilegedRoleCollector() {
            this.register(BlockTree.class, (ctx, blockTree) -> {
                if (AbstractResourceCheck.isResource(blockTree, "azuread_directory_role") && AbstractResourceCheck.hasReferenceLabel(blockTree)) {
                    this.collectHigherPrivilegedRole((BlockTree)blockTree);
                } else if (AbstractResourceCheck.isResource(blockTree, "azuread_directory_role_member")) {
                    this.collectDirectoryRoleMember((BlockTree)blockTree);
                }
            });
        }

        private void collectHigherPrivilegedRole(BlockTree resource) {
            PropertyUtils.get(resource, "display_name", AttributeTree.class).filter(attribute -> TextUtils.matchesValue(attribute.value(), HIGHER_PRIVILEGED_ROLE::containsValue).isTrue()).ifPresent(name -> this.higherPrivilegedRoles.putIfAbsent(AbstractResourceCheck.getReferenceLabel(resource), (AttributeTree)name));
            PropertyUtils.get(resource, "template_id", AttributeTree.class).filter(attribute -> TextUtils.matchesValue(attribute.value(), HIGHER_PRIVILEGED_ROLE::containsKey).isTrue()).ifPresent(id -> this.higherPrivilegedRoles.putIfAbsent(AbstractResourceCheck.getReferenceLabel(resource), (AttributeTree)id));
        }

        private void collectDirectoryRoleMember(BlockTree resource) {
            PropertyUtils.get(resource, "role_object_id", AttributeTree.class).filter(attribute -> attribute.value().is(TerraformTree.Kind.ATTRIBUTE_ACCESS)).filter(attribute -> HigherPrivilegedRoleCollector.isObjectIdReference((AttributeAccessTree)attribute.value())).ifPresent(attribute -> this.roleMember.putIfAbsent(HigherPrivilegedRoleCollector.getObjectReferenceLabel((AttributeAccessTree)attribute.value()), (AttributeTree)attribute));
        }

        private static boolean isObjectIdReference(AttributeAccessTree tree) {
            return "object_id".equals(tree.attribute().value()) && tree.object() instanceof AttributeAccessTree;
        }

        private static String getObjectReferenceLabel(AttributeAccessTree tree) {
            return ((AttributeAccessTree)tree.object()).attribute().value();
        }

        public static HigherPrivilegedRoleCollector collect(FileTree tree) {
            HigherPrivilegedRoleCollector collector = new HigherPrivilegedRoleCollector();
            collector.scan(new TreeContext(), tree);
            return collector;
        }
    }
}

