/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.gcp;

import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

public class GcpPublicNetworkAccessCheckPart
extends AbstractNewResourceCheck {
    @Override
    protected void registerResourceConsumer() {
        this.register("google_cloudbuild_worker_pool", (ResourceSymbol resource) -> resource.block("worker_config").reportIfAbsent(String.format("Omitting \"%s\" allows network access from the Internet. Make sure it is safe here.", "worker_config.no_external_ip"), new SecondaryLocation[0]).attribute("no_external_ip").reportIf(ExpressionPredicate.isFalse(), "Make sure allowing public network access is safe here.", new SecondaryLocation[0]).reportIfAbsent("Omitting \"%s\" allows network access from the Internet. Make sure it is safe here.", new SecondaryLocation[0]));
        this.register("google_compute_instance", (ResourceSymbol resource) -> resource.blocks("network_interface").forEach(block -> {
            block.block("access_config").report("Make sure allowing public network access is safe here.", new SecondaryLocation[0]);
            block.block("ipv6_access_config").report("Make sure allowing public network access is safe here.", new SecondaryLocation[0]);
        }));
        this.register("google_notebooks_instance", (ResourceSymbol resource) -> resource.attribute("no_public_ip").reportIf(ExpressionPredicate.isFalse(), "Make sure allowing public network access is safe here.", new SecondaryLocation[0]).reportIfAbsent("Omitting \"%s\" allows network access from the Internet. Make sure it is safe here.", new SecondaryLocation[0]));
        this.register("google_sql_database_instance", (ResourceSymbol resource) -> resource.block("settings").block("ip_configuration").attribute("ipv4_enabled").reportIf(ExpressionPredicate.isTrue(), "Make sure allowing public network access is safe here.", new SecondaryLocation[0]));
    }
}

