/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.jvm.JvmClass;
import org.jetbrains.kotlin.com.intellij.lang.jvm.JvmTypeDeclaration;
import org.jetbrains.kotlin.com.intellij.lang.jvm.facade.JvmFacade;
import org.jetbrains.kotlin.com.intellij.lang.jvm.facade.JvmFacadeImpl;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.kotlin.com.intellij.openapi.project.DumbService;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.AtomicNotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.openapi.util.Conditions;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.JvmPsiConversionHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiConstantEvaluationHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFinder;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModule;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaParserFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.PsiResolveHelper;
import org.jetbrains.kotlin.com.intellij.psi.impl.IsConstantExpressionVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.JavaPsiFacadeEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.impl.JavaFileManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.DummyHolderFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.JavaDummyHolder;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.JavaDummyHolderFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.FileContextUtil;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public final class JavaPsiFacadeImpl
extends JavaPsiFacadeEx {
    private static final Logger LOG = Logger.getInstance(JavaPsiFacadeImpl.class);
    private final PsiConstantEvaluationHelper myConstantEvaluationHelper;
    private final ConcurrentMap<String, PsiPackage> myPackageCache;
    private final ConcurrentMap<GlobalSearchScope, Map<String, PsiClass>> myClassCache;
    private final Map<GlobalSearchScope, Map<String, Collection<PsiJavaModule>>> myModuleCache;
    private final Project myProject;
    private final JavaFileManager myFileManager;
    private final AtomicNotNullLazyValue<JvmFacadeImpl> myJvmFacade;
    private final JvmPsiConversionHelper myConversionHelper;

    public JavaPsiFacadeImpl(@NotNull Project project) {
        if (project == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(0);
        }
        this.myPackageCache = ContainerUtil.createConcurrentSoftValueMap();
        this.myClassCache = ContainerUtil.createConcurrentSoftKeySoftValueMap();
        this.myModuleCache = ContainerUtil.createConcurrentSoftKeySoftValueMap();
        this.myProject = project;
        this.myFileManager = JavaFileManager.getInstance(this.myProject);
        this.myConstantEvaluationHelper = new PsiConstantEvaluationHelperImpl();
        this.myJvmFacade = AtomicNotNullLazyValue.createValue(() -> (JvmFacadeImpl)JvmFacade.getInstance(project));
        this.myConversionHelper = JvmPsiConversionHelper.getInstance(this.myProject);
        project.getMessageBus().connect().subscribe(PsiModificationTracker.TOPIC, () -> {
            this.myClassCache.clear();
            this.myPackageCache.clear();
            this.myModuleCache.clear();
        });
        DummyHolderFactory.setFactory(new JavaDummyHolderFactory());
    }

    @Override
    public PsiClass findClass(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope2) {
        if (qualifiedName2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(1);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(2);
        }
        ProgressIndicatorProvider.checkCanceled();
        Map map = this.myClassCache.computeIfAbsent(scope2, scope1 -> ContainerUtil.createConcurrentWeakValueMap());
        PsiClass result2 = (PsiClass)map.get(qualifiedName2);
        if (result2 == null) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            result2 = this.doFindClass(qualifiedName2, scope2);
            if (result2 != null && stamp.mayCacheNow()) {
                map.put(qualifiedName2, result2);
            }
        }
        return result2;
    }

    @Nullable
    private PsiClass doFindClass(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope2) {
        if (qualifiedName2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(3);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(4);
        }
        if (this.shouldUseSlowResolve()) {
            PsiClass[] classes2 = this.findClassesInDumbMode(qualifiedName2, scope2);
            if (classes2.length != 0) {
                return classes2[0];
            }
            return null;
        }
        List<PsiElementFinder> finders = this.filteredFinders();
        Predicate<PsiClass> classesFilter = JavaPsiFacadeImpl.getFilterFromFinders(scope2, finders);
        for (PsiElementFinder finder : finders) {
            PsiClass aClass = finder.findClass(qualifiedName2, scope2);
            if (aClass == null || classesFilter != null && !classesFilter.test(aClass)) continue;
            return aClass;
        }
        return null;
    }

    private PsiClass @NotNull [] findClassesInDumbMode(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope2) {
        if (qualifiedName2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(5);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(6);
        }
        String packageName = StringUtil.getPackageName(qualifiedName2);
        PsiPackage pkg = this.findPackage(packageName);
        String className = StringUtil.getShortName(qualifiedName2);
        if (pkg == null && packageName.length() < qualifiedName2.length()) {
            PsiClass[] containingClasses = this.findClassesInDumbMode(packageName, scope2);
            if (containingClasses.length == 1) {
                PsiClass[] psiClassArray = PsiElementFinder.filterByName(className, containingClasses[0].getInnerClasses());
                if (psiClassArray == null) {
                    JavaPsiFacadeImpl.$$$reportNull$$$0(7);
                }
                return psiClassArray;
            }
            if (PsiClass.EMPTY_ARRAY == null) {
                JavaPsiFacadeImpl.$$$reportNull$$$0(8);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        if (pkg == null) {
            if (PsiClass.EMPTY_ARRAY == null) {
                JavaPsiFacadeImpl.$$$reportNull$$$0(9);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass[] psiClassArray = pkg.findClassByShortName(className, scope2);
        if (psiClassArray == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(10);
        }
        return psiClassArray;
    }

    @Override
    public PsiClass @NotNull [] findClasses(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope2) {
        List<PsiClass> allClasses;
        if (qualifiedName2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(11);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(12);
        }
        PsiClass[] psiClassArray = (allClasses = this.findClassesWithJvmFacade(qualifiedName2, scope2)).isEmpty() ? PsiClass.EMPTY_ARRAY : allClasses.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(13);
        }
        return psiClassArray;
    }

    @NotNull
    private List<PsiClass> findClassesWithJvmFacade(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope2) {
        List<JvmClass> jvmClasses;
        if (qualifiedName2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(14);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(15);
        }
        ArrayList<PsiClass> result2 = null;
        List<PsiClass> ownClasses = this.findClassesWithoutJvmFacade(qualifiedName2, scope2);
        if (!ownClasses.isEmpty()) {
            result2 = new ArrayList<PsiClass>(ownClasses);
        }
        if (!(jvmClasses = this.myJvmFacade.getValue().findClassesWithoutJavaFacade(qualifiedName2, scope2)).isEmpty()) {
            List<PsiClass> jvmPsiClasses = ContainerUtil.map(jvmClasses, it -> this.myConversionHelper.convertTypeDeclaration((JvmTypeDeclaration)it));
            if (result2 == null) {
                result2 = new ArrayList<PsiClass>(jvmPsiClasses);
            } else {
                result2.addAll(jvmPsiClasses);
            }
        }
        List<PsiClass> list2 = result2 == null ? Collections.emptyList() : result2;
        if (list2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(16);
        }
        return list2;
    }

    @NotNull
    public List<PsiClass> findClassesWithoutJvmFacade(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope2) {
        if (qualifiedName2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(17);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(18);
        }
        if (this.shouldUseSlowResolve()) {
            List<PsiClass> list2 = Arrays.asList(this.findClassesInDumbMode(qualifiedName2, scope2));
            if (list2 == null) {
                JavaPsiFacadeImpl.$$$reportNull$$$0(19);
            }
            return list2;
        }
        List<PsiElementFinder> finders = this.filteredFinders();
        Predicate<PsiClass> classesFilter = JavaPsiFacadeImpl.getFilterFromFinders(scope2, finders);
        ArrayList result2 = null;
        for (PsiElementFinder finder : finders) {
            PsiClass[] finderClasses = finder.findClasses(qualifiedName2, scope2);
            if (finderClasses.length == 0) continue;
            if (result2 == null) {
                result2 = new ArrayList(finderClasses.length);
            }
            JavaPsiFacadeImpl.filterClassesAndAppend(finder, classesFilter, finderClasses, result2);
        }
        List<PsiClass> list3 = result2 == null ? Collections.emptyList() : result2;
        if (list3 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(20);
        }
        return list3;
    }

    private static Predicate<PsiClass> getFilterFromFinders(@NotNull GlobalSearchScope scope2, @NotNull List<PsiElementFinder> finders) {
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(21);
        }
        if (finders == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(22);
        }
        Predicate<PsiClass> filter2 = null;
        for (PsiElementFinder finder : finders) {
            Predicate<PsiClass> finderFilter = finder.getClassesFilter(scope2);
            if (finderFilter == null) continue;
            filter2 = filter2 == null ? finderFilter : filter2.and(finderFilter);
        }
        return filter2;
    }

    private boolean shouldUseSlowResolve() {
        DumbService dumbService = DumbService.getInstance(this.getProject());
        return dumbService.isDumb() && dumbService.isAlternativeResolveEnabled();
    }

    @Override
    @NotNull
    public PsiConstantEvaluationHelper getConstantEvaluationHelper() {
        PsiConstantEvaluationHelper psiConstantEvaluationHelper = this.myConstantEvaluationHelper;
        if (psiConstantEvaluationHelper == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(23);
        }
        return psiConstantEvaluationHelper;
    }

    @Override
    public PsiPackage findPackage(@NotNull String qualifiedName2) {
        PsiPackage aPackage;
        if (qualifiedName2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(24);
        }
        if ((aPackage = (PsiPackage)this.myPackageCache.get(qualifiedName2)) != null) {
            return aPackage;
        }
        for (PsiElementFinder finder : this.filteredFinders()) {
            aPackage = finder.findPackage(qualifiedName2);
            if (aPackage == null) continue;
            return ConcurrencyUtil.cacheOrGet(this.myPackageCache, qualifiedName2, aPackage);
        }
        return null;
    }

    @Override
    public PsiJavaModule findModule(@NotNull String moduleName, @NotNull GlobalSearchScope scope2) {
        Collection<PsiJavaModule> modules;
        if (moduleName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(25);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(26);
        }
        return (modules = this.findModules(moduleName, scope2)).size() == 1 ? modules.iterator().next() : null;
    }

    @Override
    @NotNull
    public Collection<PsiJavaModule> findModules(@NotNull String moduleName, @NotNull GlobalSearchScope scope2) {
        if (moduleName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(27);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(28);
        }
        Collection collection = this.myModuleCache.computeIfAbsent(scope2, k -> ContainerUtil.createConcurrentWeakValueMap()).computeIfAbsent(moduleName, k -> JavaFileManager.getInstance(this.myProject).findModules((String)k, scope2));
        if (collection == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(29);
        }
        return collection;
    }

    @NotNull
    private List<PsiElementFinder> filteredFinders() {
        List<PsiElementFinder> list2 = DumbService.getInstance(this.getProject()).filterByDumbAwareness(PsiElementFinder.EP.getPoint(this.myProject).getExtensionList());
        if (list2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(30);
        }
        return list2;
    }

    @Override
    @NotNull
    public PsiJavaParserFacade getParserFacade() {
        PsiElementFactory psiElementFactory = this.getElementFactory();
        if (psiElementFactory == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(31);
        }
        return psiElementFactory;
    }

    @Override
    @NotNull
    public PsiResolveHelper getResolveHelper() {
        PsiResolveHelper psiResolveHelper = PsiResolveHelper.SERVICE.getInstance(this.myProject);
        if (psiResolveHelper == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(32);
        }
        return psiResolveHelper;
    }

    @Override
    @NotNull
    public PsiNameHelper getNameHelper() {
        PsiNameHelper psiNameHelper = PsiNameHelper.getInstance(this.myProject);
        if (psiNameHelper == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(33);
        }
        return psiNameHelper;
    }

    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(34);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(35);
        }
        HashSet<String> result2 = new HashSet<String>();
        for (PsiElementFinder finder : this.filteredFinders()) {
            result2.addAll(finder.getClassNames(psiPackage, scope2));
        }
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(36);
        }
        return hashSet;
    }

    public PsiClass @NotNull [] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(37);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(38);
        }
        List<PsiElementFinder> finders = this.filteredFinders();
        Predicate<PsiClass> classesFilter = JavaPsiFacadeImpl.getFilterFromFinders(scope2, finders);
        ArrayList result2 = null;
        for (PsiElementFinder finder : finders) {
            PsiClass[] classes2 = finder.getClasses(psiPackage, scope2);
            if (classes2.length == 0) continue;
            if (result2 == null) {
                result2 = new ArrayList(classes2.length);
            }
            JavaPsiFacadeImpl.filterClassesAndAppend(finder, classesFilter, classes2, result2);
        }
        PsiClass[] psiClassArray = result2 == null ? PsiClass.EMPTY_ARRAY : result2.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(39);
        }
        return psiClassArray;
    }

    private static void filterClassesAndAppend(PsiElementFinder finder, @Nullable Predicate<? super PsiClass> classesFilter, PsiClass @NotNull [] classes2, @NotNull List<? super PsiClass> result2) {
        if (result2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(40);
        }
        if (classes2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(41);
        }
        for (PsiClass psiClass : classes2) {
            if (psiClass == null) {
                LOG.error("Finder " + finder + " returned null PsiClass");
                continue;
            }
            if (classesFilter != null && !classesFilter.test(psiClass)) continue;
            result2.add(psiClass);
        }
    }

    public PsiFile @NotNull [] getPackageFiles(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(42);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(43);
        }
        Condition<PsiFile> filter2 = null;
        for (PsiElementFinder finder : this.filteredFinders()) {
            Condition<PsiFile> finderFilter = finder.getPackageFilesFilter(psiPackage, scope2);
            if (finderFilter == null) continue;
            if (filter2 == null) {
                filter2 = finderFilter;
                continue;
            }
            filter2 = Conditions.and(filter2, finderFilter);
        }
        LinkedHashSet<PsiFile> result2 = new LinkedHashSet<PsiFile>();
        PsiDirectory[] directories2 = psiPackage.getDirectories(scope2);
        for (PsiDirectory directory : directories2) {
            for (PsiFile file2 : directory.getFiles()) {
                if (filter2 != null && !filter2.value(file2)) continue;
                result2.add(file2);
            }
        }
        for (PsiElementFinder finder : this.filteredFinders()) {
            Collections.addAll(result2, finder.getPackageFiles(psiPackage, scope2));
        }
        PsiFile[] psiFileArray = result2.toArray(PsiFile.EMPTY_ARRAY);
        if (psiFileArray == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(44);
        }
        return psiFileArray;
    }

    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2, @NotNull Processor<? super PsiDirectory> consumer, boolean includeLibrarySources) {
        if (psiPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(45);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(46);
        }
        if (consumer == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(47);
        }
        for (PsiElementFinder finder : this.filteredFinders()) {
            if (finder.processPackageDirectories(psiPackage, scope2, consumer, includeLibrarySources)) continue;
            return false;
        }
        return true;
    }

    public PsiPackage @NotNull [] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(48);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(49);
        }
        LinkedHashMap<String, PsiPackage> result2 = new LinkedHashMap<String, PsiPackage>();
        for (PsiElementFinder finder : this.filteredFinders()) {
            PsiPackage[] packages2;
            for (PsiPackage aPackage : packages2 = finder.getSubPackages(psiPackage, scope2)) {
                result2.putIfAbsent(aPackage.getName(), aPackage);
            }
        }
        PsiPackage[] psiPackageArray = result2.values().toArray(PsiPackage.EMPTY_ARRAY);
        if (psiPackageArray == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(50);
        }
        return psiPackageArray;
    }

    @Override
    public boolean isPartOfPackagePrefix(@NotNull String packageName) {
        if (packageName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(51);
        }
        Collection<String> packagePrefixes = this.myFileManager.getNonTrivialPackagePrefixes();
        for (String subpackageName : packagePrefixes) {
            if (!PsiNameHelper.isSubpackageOf(subpackageName, packageName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInPackage(@NotNull PsiElement element, @NotNull PsiPackage aPackage) {
        PsiFile file2;
        if (element == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(52);
        }
        if (aPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(53);
        }
        if ((file2 = FileContextUtil.getContextFile(element)) instanceof JavaDummyHolder) {
            return ((JavaDummyHolder)file2).isInPackage(aPackage);
        }
        if (file2 instanceof PsiJavaFile) {
            String packageName = ((PsiJavaFile)file2).getPackageName();
            return packageName.equals(aPackage.getQualifiedName());
        }
        return false;
    }

    @Override
    public boolean arePackagesTheSame(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        PsiFile file2;
        PsiFile file1;
        if (element1 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(54);
        }
        if (element2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(55);
        }
        if (Comparing.equal(file1 = FileContextUtil.getContextFile(element1), file2 = FileContextUtil.getContextFile(element2))) {
            return true;
        }
        if (file1 instanceof JavaDummyHolder && file2 instanceof JavaDummyHolder) {
            return true;
        }
        if (file1 instanceof JavaDummyHolder || file2 instanceof JavaDummyHolder) {
            JavaDummyHolder dummyHolder = (JavaDummyHolder)(file1 instanceof JavaDummyHolder ? file1 : file2);
            PsiFile other = file1 instanceof JavaDummyHolder ? file2 : file1;
            return dummyHolder.isSamePackage(other);
        }
        if (!(file1 instanceof PsiClassOwner)) {
            return false;
        }
        if (!(file2 instanceof PsiClassOwner)) {
            return false;
        }
        String package1 = ((PsiClassOwner)file1).getPackageName();
        String package2 = ((PsiClassOwner)file2).getPackageName();
        return Objects.equals(package1, package2);
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(56);
        }
        return project;
    }

    @Override
    public boolean isConstantExpression(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(57);
        }
        IsConstantExpressionVisitor visitor2 = new IsConstantExpressionVisitor();
        expression2.accept(visitor2);
        return visitor2.isConstant();
    }

    @Override
    @NotNull
    public PsiElementFactory getElementFactory() {
        PsiElementFactory psiElementFactory = PsiElementFactory.getInstance(this.myProject);
        if (psiElementFactory == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(58);
        }
        return psiElementFactory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 39: 
            case 44: 
            case 50: 
            case 56: 
            case 58: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 39: 
            case 44: 
            case 50: 
            case 56: 
            case 58: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 11: 
            case 14: 
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 12: 
            case 15: 
            case 18: 
            case 21: 
            case 26: 
            case 28: 
            case 35: 
            case 38: 
            case 43: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 39: 
            case 44: 
            case 50: 
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finders";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 34: 
            case 37: 
            case 42: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesInDumbMode";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesWithJvmFacade";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesWithoutJvmFacade";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstantEvaluationHelper";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "findModules";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "filteredFinders";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getParserFacade";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveHelper";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameHelper";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassNames";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageFiles";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubPackages";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doFindClass";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findClassesInDumbMode";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 39: 
            case 44: 
            case 50: 
            case 56: 
            case 58: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findClassesWithJvmFacade";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findClassesWithoutJvmFacade";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getFilterFromFinders";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findModules";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getClassNames";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getClasses";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "filterClassesAndAppend";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getPackageFiles";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "processPackageDirectories";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getSubPackages";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isPartOfPackagePrefix";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isInPackage";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "arePackagesTheSame";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isConstantExpression";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 39: 
            case 44: 
            case 50: 
            case 56: 
            case 58: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

