/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jdom;

import org.jetbrains.kotlin.org.jdom.Content;
import org.jetbrains.kotlin.org.jdom.Element;
import org.jetbrains.kotlin.org.jdom.IllegalDataException;
import org.jetbrains.kotlin.org.jdom.Parent;
import org.jetbrains.kotlin.org.jdom.Verifier;
import org.jetbrains.kotlin.org.jdom.output.Format;

public class Text
extends Content {
    private static final long serialVersionUID = 200L;
    protected String value;

    protected Text(Content.CType ctype) {
        super(ctype);
    }

    protected Text() {
        this(Content.CType.Text);
    }

    public Text(String str) {
        this(Content.CType.Text);
        this.setText(str);
    }

    public String getText() {
        return this.value;
    }

    public String getTextNormalize() {
        return Text.normalizeString(this.getText());
    }

    public static String normalizeString(String str) {
        if (str == null) {
            return "";
        }
        return Format.compact(str);
    }

    public Text setText(String str) {
        if (str == null) {
            this.value = "";
            return this;
        }
        String reason = Verifier.checkCharacterData(str);
        if (reason != null) {
            throw new IllegalDataException(str, "character content", reason);
        }
        this.value = str;
        return this;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return new StringBuilder(64).append("[Text: ").append(this.getText()).append("]").toString();
    }

    @Override
    public Text clone() {
        Text text = (Text)super.clone();
        text.value = this.value;
        return text;
    }

    @Override
    protected Text setParent(Parent parent2) {
        return (Text)super.setParent(parent2);
    }

    @Override
    public Element getParent() {
        return (Element)super.getParent();
    }
}

