/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u0004\u0018\u00010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0007J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0014\u0010\u001f\u001a\u00020\u0007*\u00020 2\u0006\u0010!\u001a\u00020\u0007H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/utils/LibraryUtils;", "", "()V", "LOG", "Lorg/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MANIFEST_PATH", "", "META_INF", "getMETA_INF", "()Ljava/lang/String;", "TITLE_KOTLIN_JAVASCRIPT_STDLIB", "checkAttributeValue", "", "library", "Ljava/io/File;", "expected", "attributeName", "Ljava/util/jar/Attributes$Name;", "getJarFile", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "classesRoots", "", "jarName", "getManifestFromDirectory", "Ljava/util/jar/Manifest;", "getManifestFromJar", "getManifestFromJarOrDirectory", "getManifestMainAttributesFromJarOrDirectory", "Ljava/util/jar/Attributes;", "isKotlinJavascriptStdLibrary", "getPropertyOrFail", "Ljava/util/Properties;", "propName", "util"})
public final class LibraryUtils {
    @NotNull
    public static final LibraryUtils INSTANCE = new LibraryUtils();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static String TITLE_KOTLIN_JAVASCRIPT_STDLIB;
    @NotNull
    private static final String META_INF;
    @NotNull
    private static final String MANIFEST_PATH;

    private LibraryUtils() {
    }

    @NotNull
    public final String getMETA_INF() {
        return META_INF;
    }

    @JvmStatic
    @Nullable
    public static final VirtualFile getJarFile(@NotNull List<? extends VirtualFile> classesRoots, @NotNull String jarName) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(classesRoots, "classesRoots");
            Intrinsics.checkNotNullParameter(jarName, "jarName");
            Iterable $this$firstOrNull$iv = classesRoots;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName(), jarName)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @JvmStatic
    public static final boolean isKotlinJavascriptStdLibrary(@NotNull File library) {
        Intrinsics.checkNotNullParameter(library, "library");
        Attributes.Name name = Attributes.Name.IMPLEMENTATION_TITLE;
        Intrinsics.checkNotNullExpressionValue(name, "IMPLEMENTATION_TITLE");
        return INSTANCE.checkAttributeValue(library, TITLE_KOTLIN_JAVASCRIPT_STDLIB, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Manifest getManifestFromJar(File library) {
        if (!library.canRead()) {
            return null;
        }
        try {
            Closeable closeable = new JarFile(library);
            Throwable throwable = null;
            try {
                JarFile jarFile = (JarFile)closeable;
                boolean bl = false;
                Manifest manifest2 = jarFile.getManifest();
                return manifest2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (IOException ignored) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Manifest getManifestFromDirectory(File library) {
        if (!library.canRead() || !library.isDirectory()) {
            return null;
        }
        File manifestFile2 = new File(library, MANIFEST_PATH);
        if (!manifestFile2.exists()) {
            return null;
        }
        try (FileInputStream inputStream = new FileInputStream(manifestFile2);){
            Manifest manifest2 = new Manifest(inputStream);
            return manifest2;
        }
        catch (IOException ignored) {
            LOG.warn("IOException " + ignored);
            return null;
        }
    }

    private final Manifest getManifestFromJarOrDirectory(File library) {
        return library.isDirectory() ? this.getManifestFromDirectory(library) : this.getManifestFromJar(library);
    }

    private final Attributes getManifestMainAttributesFromJarOrDirectory(File library) {
        Manifest manifest2 = this.getManifestFromJarOrDirectory(library);
        return manifest2 != null ? manifest2.getMainAttributes() : null;
    }

    private final boolean checkAttributeValue(File library, String expected, Attributes.Name attributeName) {
        Attributes attributes;
        Attributes attributes2 = attributes = this.getManifestMainAttributesFromJarOrDirectory(library);
        String value2 = attributes2 != null ? attributes2.getValue(attributeName) : null;
        return value2 != null && Intrinsics.areEqual(value2, expected);
    }

    private final String getPropertyOrFail(Properties $this$getPropertyOrFail, String propName) {
        String value2 = $this$getPropertyOrFail.getProperty(propName);
        if (value2 == null) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            $this$getPropertyOrFail.list(new PrintStream(bytes));
            LOG.error(propName + " not found.\n " + bytes);
        }
        Intrinsics.checkNotNullExpressionValue(value2, "value");
        return value2;
    }

    static {
        Logger logger = Logger.getInstance(LibraryUtils.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(LibraryUtils::class.java)");
        LOG = logger;
        META_INF = "META-INF/";
        MANIFEST_PATH = META_INF + "MANIFEST.MF";
        String jsStdLib = "";
        InputStream manifestProperties2 = LibraryUtils.class.getResourceAsStream("/kotlinManifest.properties");
        if (manifestProperties2 != null) {
            try {
                Properties properties2 = new Properties();
                properties2.load(manifestProperties2);
                jsStdLib = INSTANCE.getPropertyOrFail(properties2, "manifest.impl.title.kotlin.javascript.stdlib");
            }
            catch (IOException e) {
                LOG.error(e);
            }
        } else {
            LOG.error("Resource 'kotlinManifest.properties' not found.");
        }
        TITLE_KOTLIN_JAVASCRIPT_STDLIB = jsStdLib;
    }
}

