/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.kotlin.api.AbstractCheck;
import org.sonarsource.kotlin.plugin.KotlinFileContext;

@Rule(key="S101")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/sonarsource/kotlin/checks/BadClassNameCheck;", "Lorg/sonarsource/kotlin/api/AbstractCheck;", "()V", "format", "", "getFormat", "()Ljava/lang/String;", "setFormat", "(Ljava/lang/String;)V", "formatRegex", "Lkotlin/text/Regex;", "initialize", "", "ruleKey", "Lorg/sonar/api/rule/RuleKey;", "visitClass", "ktClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "context", "Lorg/sonarsource/kotlin/plugin/KotlinFileContext;", "Companion", "sonar-kotlin-plugin"})
public final class BadClassNameCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RuleProperty(key="format", description="Regular expression used to check the class names against.", defaultValue="^[A-Z][a-zA-Z0-9]*$")
    @NotNull
    private String format = "^[A-Z][a-zA-Z0-9]*$";
    private Regex formatRegex;
    @NotNull
    private static final String DEFAULT_FORMAT = "^[A-Z][a-zA-Z0-9]*$";

    @NotNull
    public final String getFormat() {
        return this.format;
    }

    public final void setFormat(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        this.format = string2;
    }

    @Override
    public void initialize(@NotNull RuleKey ruleKey) {
        Intrinsics.checkNotNullParameter(ruleKey, "ruleKey");
        this.formatRegex = new Regex(this.format);
        super.initialize(ruleKey);
    }

    @Override
    public void visitClass(@NotNull KtClass ktClass, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(ktClass, "ktClass");
        Intrinsics.checkNotNullParameter(context, "context");
        String string2 = ktClass.getName();
        Intrinsics.checkNotNull(string2);
        String name = string2;
        if (!(ktClass instanceof KtEnumEntry)) {
            CharSequence charSequence = name;
            Regex regex = this.formatRegex;
            if (regex == null) {
                Intrinsics.throwUninitializedPropertyAccessException("formatRegex");
                regex = null;
            }
            if (!regex.matches(charSequence)) {
                AbstractCheck abstractCheck = this;
                PsiElement psiElement = ktClass.getNameIdentifier();
                Intrinsics.checkNotNull(psiElement);
                AbstractCheck.reportIssue$sonar_kotlin_plugin$default(abstractCheck, context, psiElement, "Rename class \"" + name + "\" to match the regular expression " + this.format, null, null, 12, null);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/sonarsource/kotlin/checks/BadClassNameCheck$Companion;", "", "()V", "DEFAULT_FORMAT", "", "sonar-kotlin-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

