/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.AbstractCheck;
import org.sonarsource.kotlin.plugin.KotlinFileContext;

@Rule(key="S1125")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0016\u0010\u0005\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00040\u0006\"\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0013"}, d2={"Lorg/sonarsource/kotlin/checks/BooleanLiteralCheck;", "Lorg/sonarsource/kotlin/api/AbstractCheck;", "()V", "getBooleanLiteral", "Lorg/jetbrains/kotlin/psi/KtExpression;", "trees", "", "([Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/psi/KtExpression;", "visitBinaryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "context", "Lorg/sonarsource/kotlin/plugin/KotlinFileContext;", "visitIfExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "visitUnaryExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "Companion", "sonar-kotlin-plugin"})
public final class BooleanLiteralCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<KtSingleValueToken> CONDITIONAL_BINARY_OPERATORS;
    @NotNull
    private static final Set<String> BOOLEAN_LITERALS;
    @NotNull
    private static final String MESSAGE = "Remove the unnecessary Boolean literal.";

    @Override
    public void visitIfExpression(@NotNull KtIfExpression expression2, @NotNull KotlinFileContext context) {
        block0: {
            KtExpression[] ktExpressionArray;
            KtExpression ktExpression;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(context, "context");
            if (!BooleanLiteralCheck.Companion.isIfWithMaxTwoBranches(expression2) || BooleanLiteralCheck.Companion.hasBlockBranch(expression2) || (ktExpression = this.getBooleanLiteral(ktExpressionArray = new KtExpression[]{expression2.getThen(), expression2.getElse()})) == null) break block0;
            KtExpression it = ktExpression;
            boolean bl = false;
            AbstractCheck.reportIssue$sonar_kotlin_plugin$default((AbstractCheck)this, context, it, MESSAGE, null, null, 12, null);
        }
    }

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression2, @NotNull KotlinFileContext context) {
        block1: {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(context, "context");
            if (!CollectionsKt.contains((Iterable)CONDITIONAL_BINARY_OPERATORS, expression2.getOperationToken())) break block1;
            KtExpression[] ktExpressionArray = new KtExpression[]{expression2.getLeft(), expression2.getRight()};
            KtExpression ktExpression = this.getBooleanLiteral(ktExpressionArray);
            if (ktExpression != null) {
                KtExpression it = ktExpression;
                boolean bl = false;
                AbstractCheck.reportIssue$sonar_kotlin_plugin$default((AbstractCheck)this, context, it, MESSAGE, null, null, 12, null);
            }
        }
    }

    @Override
    public void visitUnaryExpression(@NotNull KtUnaryExpression expression2, @NotNull KotlinFileContext context) {
        block1: {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(context, "context");
            if (!Intrinsics.areEqual(KtTokens.EXCL, expression2.getOperationToken())) break block1;
            KtExpression[] ktExpressionArray = new KtExpression[]{expression2.getBaseExpression()};
            KtExpression ktExpression = this.getBooleanLiteral(ktExpressionArray);
            if (ktExpression != null) {
                KtExpression it = ktExpression;
                boolean bl = false;
                AbstractCheck.reportIssue$sonar_kotlin_plugin$default((AbstractCheck)this, context, it, MESSAGE, null, null, 12, null);
            }
        }
    }

    private final KtExpression getBooleanLiteral(KtExpression ... trees) {
        Object v0;
        block1: {
            Sequence sequence2 = SequencesKt.mapNotNull(ArraysKt.asSequence(trees), (Function1)new Function1<KtExpression, KtExpression>(this){
                final /* synthetic */ BooleanLiteralCheck this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final KtExpression invoke(@Nullable KtExpression it) {
                    return it != null ? this.this$0.skipParentheses$sonar_kotlin_plugin(it) : null;
                }
            });
            Iterator iterator2 = sequence2.iterator();
            while (iterator2.hasNext()) {
                Object r = iterator2.next();
                KtExpression it = (KtExpression)r;
                boolean bl = false;
                if (!(it instanceof KtConstantExpression && BOOLEAN_LITERALS.contains(((KtConstantExpression)it).getText()))) continue;
                v0 = r;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    static {
        Object[] objectArray = new KtSingleValueToken[]{KtTokens.ANDAND, KtTokens.OROR};
        CONDITIONAL_BINARY_OPERATORS = SetsKt.setOf(objectArray);
        objectArray = new String[]{"true", "false"};
        BOOLEAN_LITERALS = SetsKt.setOf(objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/sonarsource/kotlin/checks/BooleanLiteralCheck$Companion;", "", "()V", "BOOLEAN_LITERALS", "", "", "CONDITIONAL_BINARY_OPERATORS", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "kotlin.jvm.PlatformType", "MESSAGE", "hasBlockBranch", "", "ifTree", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "isIfWithMaxTwoBranches", "sonar-kotlin-plugin"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isIfWithMaxTwoBranches(KtIfExpression ifTree) {
            PsiElement grandParent = ifTree.getParent().getParent();
            boolean isElseIf = grandParent instanceof KtIfExpression && ((KtIfExpression)grandParent).getElse() == ifTree;
            boolean isIfElseIf = ifTree.getElse() instanceof KtIfExpression;
            return !isElseIf && !isIfElseIf;
        }

        private final boolean hasBlockBranch(KtIfExpression ifTree) {
            return ifTree.getThen() instanceof KtBlockExpression || ifTree.getElse() instanceof KtBlockExpression;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

