/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.AbstractCheck;
import org.sonarsource.kotlin.checks.CodeAfterJumpCheckKt;
import org.sonarsource.kotlin.plugin.KotlinFileContext;

@Rule(key="S1763")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lorg/sonarsource/kotlin/checks/CodeAfterJumpCheck;", "Lorg/sonarsource/kotlin/api/AbstractCheck;", "()V", "checkStatements", "", "context", "Lorg/sonarsource/kotlin/plugin/KotlinFileContext;", "statementsOrExpressions", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "visitBlockExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "sonar-kotlin-plugin"})
public final class CodeAfterJumpCheck
extends AbstractCheck {
    @Override
    public void visitBlockExpression(@NotNull KtBlockExpression expression2, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        List<KtExpression> list2 = expression2.getStatements();
        Intrinsics.checkNotNullExpressionValue(list2, "expression.statements");
        this.checkStatements(context, list2);
    }

    private final void checkStatements(KotlinFileContext context, List<? extends KtElement> statementsOrExpressions) {
        int n = statementsOrExpressions.size() - 1;
        for (int i = 0; i < n; ++i) {
            String it;
            KtElement current = statementsOrExpressions.get(i);
            if (CodeAfterJumpCheckKt.access$getJump(current) == null) continue;
            boolean bl = false;
            AbstractCheck.reportIssue$sonar_kotlin_plugin$default((AbstractCheck)this, context, current, "Refactor this piece of code to not have any dead code after this \"" + it + "\".", null, null, 12, null);
        }
    }
}

