/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.AbstractCheck;
import org.sonarsource.kotlin.api.ApiExtensionsKt;
import org.sonarsource.kotlin.api.FunMatcherImpl;
import org.sonarsource.kotlin.checks.CollectionSizeAndArrayLengthCheckKt;
import org.sonarsource.kotlin.plugin.KotlinFileContext;

@Rule(key="S3981")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JC\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0011\u0010\u0017\u001a\u00020\u0018*\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\u0019J\u0011\u0010\u001a\u001a\u00020\u0018*\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lorg/sonarsource/kotlin/checks/CollectionSizeAndArrayLengthCheck;", "Lorg/sonarsource/kotlin/api/AbstractCheck;", "()V", "checkConditionsAndSelectMessage", "", "ctx", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "opToken", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "testedExpr", "Lorg/jetbrains/kotlin/psi/KtExpression;", "integerValue", "", "opWithEq", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "opWithoutEq", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;Lorg/jetbrains/kotlin/psi/KtExpression;Ljava/lang/Integer;Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;)Ljava/lang/String;", "visitBinaryExpression", "", "bet", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "fileCtx", "Lorg/sonarsource/kotlin/plugin/KotlinFileContext;", "isNegative", "", "(Ljava/lang/Integer;)Z", "isZeroOrNegative", "sonar-kotlin-plugin"})
public final class CollectionSizeAndArrayLengthCheck
extends AbstractCheck {
    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression bet, @NotNull KotlinFileContext fileCtx) {
        block4: {
            String msg;
            String string2;
            Integer rightIntValue;
            Intrinsics.checkNotNullParameter(bet, "bet");
            Intrinsics.checkNotNullParameter(fileCtx, "fileCtx");
            BindingContext ctx = fileCtx.getBindingContext();
            IElementType iElementType = bet.getOperationToken();
            Intrinsics.checkNotNullExpressionValue(iElementType, "bet.operationToken");
            IElementType opToken = iElementType;
            KtExpression ktExpression = bet.getLeft();
            Integer leftIntValue = ktExpression != null ? ApiExtensionsKt.predictRuntimeIntValue(ktExpression, ctx) : null;
            KtExpression ktExpression2 = bet.getRight();
            Integer n = rightIntValue = ktExpression2 != null ? ApiExtensionsKt.predictRuntimeIntValue(ktExpression2, ctx) : null;
            if (this.isZeroOrNegative(leftIntValue)) {
                KtExpression ktExpression3 = bet.getRight();
                KtSingleValueToken ktSingleValueToken = KtTokens.LTEQ;
                Intrinsics.checkNotNullExpressionValue(ktSingleValueToken, "LTEQ");
                KtSingleValueToken ktSingleValueToken2 = KtTokens.GT;
                Intrinsics.checkNotNullExpressionValue(ktSingleValueToken2, "GT");
                string2 = this.checkConditionsAndSelectMessage(ctx, opToken, ktExpression3, leftIntValue, ktSingleValueToken, ktSingleValueToken2);
            } else if (this.isZeroOrNegative(rightIntValue)) {
                KtExpression ktExpression4 = bet.getLeft();
                KtSingleValueToken ktSingleValueToken = KtTokens.GTEQ;
                Intrinsics.checkNotNullExpressionValue(ktSingleValueToken, "GTEQ");
                KtSingleValueToken ktSingleValueToken3 = KtTokens.LT;
                Intrinsics.checkNotNullExpressionValue(ktSingleValueToken3, "LT");
                string2 = this.checkConditionsAndSelectMessage(ctx, opToken, ktExpression4, rightIntValue, ktSingleValueToken, ktSingleValueToken3);
            } else {
                string2 = null;
            }
            String string3 = msg = string2;
            if (string3 == null) break block4;
            String it = string3;
            boolean bl = false;
            AbstractCheck.reportIssue$sonar_kotlin_plugin$default((AbstractCheck)this, fileCtx, bet, it, null, null, 12, null);
        }
    }

    private final String checkConditionsAndSelectMessage(BindingContext ctx, IElementType opToken, KtExpression testedExpr, Integer integerValue, KtSingleValueToken opWithEq, KtSingleValueToken opWithoutEq) {
        if (testedExpr instanceof KtDotQualifiedExpression) {
            boolean bl;
            block7: {
                Iterable $this$any$iv = CollectionSizeAndArrayLengthCheckKt.getMATCHERS();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FunMatcherImpl it = (FunMatcherImpl)element$iv;
                        boolean bl2 = false;
                        if (!it.matches(CallUtilKt.getResolvedCall(testedExpr, ctx))) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl) {
                if (Intrinsics.areEqual(opToken, opWithEq)) {
                    return CollectionSizeAndArrayLengthCheckKt.getISSUE_MESSAGE_SIZE_ALWAYS_GTEQ();
                }
                if (Intrinsics.areEqual(opToken, opWithoutEq) || this.isNegative(integerValue) && Intrinsics.areEqual(opToken, KtTokens.EQEQ)) {
                    return CollectionSizeAndArrayLengthCheckKt.getISSUE_MESSAGE_SIZE_NEVER_LT();
                }
            }
        }
        return null;
    }

    public final boolean isZeroOrNegative(@Nullable Integer $this$isZeroOrNegative) {
        return $this$isZeroOrNegative != null && $this$isZeroOrNegative <= 0;
    }

    public final boolean isNegative(@Nullable Integer $this$isNegative) {
        return $this$isNegative != null && $this$isNegative < 0;
    }
}

