/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi2ir.KotlinUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.AbstractCheck;
import org.sonarsource.kotlin.api.CallAbstractCheck;
import org.sonarsource.kotlin.api.FunMatcherImpl;
import org.sonarsource.kotlin.checks.ExternalAndroidStorageAccessCheckKt;
import org.sonarsource.kotlin.plugin.KotlinFileContext;

@Rule(key="S5324")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/sonarsource/kotlin/checks/ExternalAndroidStorageAccessCheck;", "Lorg/sonarsource/kotlin/api/CallAbstractCheck;", "()V", "functionsToVisit", "", "Lorg/sonarsource/kotlin/api/FunMatcherImpl;", "getFunctionsToVisit", "()Ljava/util/List;", "visitFunctionCall", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "kotlinFileContext", "Lorg/sonarsource/kotlin/plugin/KotlinFileContext;", "visitReferenceExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "sonar-kotlin-plugin"})
public final class ExternalAndroidStorageAccessCheck
extends CallAbstractCheck {
    @NotNull
    private final List<FunMatcherImpl> functionsToVisit = ExternalAndroidStorageAccessCheckKt.access$getHOTSPOT_FUNS$p();

    @NotNull
    public List<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull ResolvedCall<?> resolvedCall2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        AbstractCheck abstractCheck = this;
        KtExpression ktExpression = callExpression.getCalleeExpression();
        Intrinsics.checkNotNull(ktExpression);
        AbstractCheck.reportIssue$sonar_kotlin_plugin$default(abstractCheck, kotlinFileContext, ktExpression, "Make sure accessing the Android external storage is safe here.", null, null, 12, null);
    }

    @Override
    public void visitReferenceExpression(@NotNull KtReferenceExpression expression2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (expression2 instanceof KtNameReferenceExpression && ExternalAndroidStorageAccessCheckKt.access$getHOTSPOT_PROPS$p().contains(((KtNameReferenceExpression)expression2).getReferencedName())) {
            PropertyDescriptor prop;
            Object v = kotlinFileContext.getBindingContext().get(BindingContext.REFERENCE_TARGET, expression2);
            PropertyDescriptor propertyDescriptor = prop = v instanceof PropertyDescriptor ? (PropertyDescriptor)v : null;
            if (prop != null) {
                boolean bl;
                block6: {
                    Iterable $this$any$iv = ExternalAndroidStorageAccessCheckKt.access$getHOTSPOT_FUNS$p();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            FunMatcherImpl it = (FunMatcherImpl)element$iv;
                            boolean bl2 = false;
                            if (!it.matches(KotlinUtilsKt.getUnwrappedGetMethod(prop))) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    AbstractCheck.reportIssue$sonar_kotlin_plugin$default((AbstractCheck)this, kotlinFileContext, expression2, "Make sure accessing the Android external storage is safe here.", null, null, 12, null);
                }
            }
        }
    }
}

