/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.AbstractCheck;
import org.sonarsource.kotlin.plugin.KotlinFileContext;

@Rule(key="S1145")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u0004*\u00020\u0006H\u0002J\f\u0010\u000e\u001a\u00020\u0004*\u00020\u0006H\u0002J\u0014\u0010\u000f\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010\u0012\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u0004*\u00020\u0006H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/sonarsource/kotlin/checks/IfConditionalAlwaysTrueOrFalseCheck;", "Lorg/sonarsource/kotlin/api/AbstractCheck;", "()V", "isAlwaysTrueOrFalse", "", "condition", "Lorg/jetbrains/kotlin/psi/KtExpression;", "visitIfExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "kotlinFileContext", "Lorg/sonarsource/kotlin/plugin/KotlinFileContext;", "isFalseValueLiteral", "isNegation", "isSimpleExpression", "operation", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "isSimpleExpressionWithLiteral", "hasLiteralValue", "Lkotlin/Function1;", "isTrueValueLiteral", "sonar-kotlin-plugin"})
public final class IfConditionalAlwaysTrueOrFalseCheck
extends AbstractCheck {
    @Override
    public void visitIfExpression(@NotNull KtIfExpression expression2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        KtExpression ktExpression = expression2.getCondition();
        Intrinsics.checkNotNull(ktExpression);
        if (this.isAlwaysTrueOrFalse(ktExpression)) {
            AbstractCheck abstractCheck = this;
            KtExpression ktExpression2 = expression2.getCondition();
            Intrinsics.checkNotNull(ktExpression2);
            AbstractCheck.reportIssue$sonar_kotlin_plugin$default(abstractCheck, kotlinFileContext, ktExpression2, "Remove this useless \"if\" statement.", null, null, 12, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAlwaysTrueOrFalse(KtExpression condition) {
        if (this.isTrueValueLiteral(condition)) return true;
        if (this.isFalseValueLiteral(condition)) return true;
        KtSingleValueToken ktSingleValueToken = KtTokens.ANDAND;
        Intrinsics.checkNotNullExpressionValue(ktSingleValueToken, "ANDAND");
        if (this.isSimpleExpressionWithLiteral(condition, ktSingleValueToken, (Function1<? super KtExpression, Boolean>)new Function1<KtExpression, Boolean>(this){
            final /* synthetic */ IfConditionalAlwaysTrueOrFalseCheck this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtExpression it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return IfConditionalAlwaysTrueOrFalseCheck.access$isFalseValueLiteral(this.this$0, it);
            }
        })) return true;
        KtSingleValueToken ktSingleValueToken2 = KtTokens.OROR;
        Intrinsics.checkNotNullExpressionValue(ktSingleValueToken2, "OROR");
        if (!this.isSimpleExpressionWithLiteral(condition, ktSingleValueToken2, (Function1<? super KtExpression, Boolean>)new Function1<KtExpression, Boolean>(this){
            final /* synthetic */ IfConditionalAlwaysTrueOrFalseCheck this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtExpression it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return IfConditionalAlwaysTrueOrFalseCheck.access$isTrueValueLiteral(this.this$0, it);
            }
        })) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTrueValueLiteral(KtExpression $this$isTrueValueLiteral) {
        KtExpression e = this.skipParentheses$sonar_kotlin_plugin($this$isTrueValueLiteral);
        if (e instanceof KtConstantExpression) {
            if (Intrinsics.areEqual(((KtConstantExpression)e).getText(), "true")) return true;
        }
        if (!this.isNegation(e)) return false;
        Intrinsics.checkNotNull(e, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtUnaryExpression");
        KtExpression ktExpression = ((KtUnaryExpression)e).getBaseExpression();
        Intrinsics.checkNotNull(ktExpression);
        if (!this.isFalseValueLiteral(ktExpression)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFalseValueLiteral(KtExpression $this$isFalseValueLiteral) {
        KtExpression e = this.skipParentheses$sonar_kotlin_plugin($this$isFalseValueLiteral);
        if (e instanceof KtConstantExpression) {
            if (Intrinsics.areEqual(((KtConstantExpression)e).getText(), "false")) return true;
        }
        if (!this.isNegation(e)) return false;
        Intrinsics.checkNotNull(e, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtUnaryExpression");
        KtExpression ktExpression = ((KtUnaryExpression)e).getBaseExpression();
        Intrinsics.checkNotNull(ktExpression);
        if (!this.isTrueValueLiteral(ktExpression)) return false;
        return true;
    }

    private final boolean isNegation(KtExpression $this$isNegation) {
        return $this$isNegation instanceof KtUnaryExpression && Intrinsics.areEqual(((KtUnaryExpression)$this$isNegation).getOperationToken(), KtTokens.EXCL);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSimpleExpressionWithLiteral(KtExpression $this$isSimpleExpressionWithLiteral, KtSingleValueToken operation, Function1<? super KtExpression, Boolean> hasLiteralValue) {
        if (!this.isSimpleExpression($this$isSimpleExpressionWithLiteral, operation)) return false;
        PsiElement $this$anyDescendantOfType$iv = $this$isSimpleExpressionWithLiteral;
        boolean $i$f$anyDescendantOfType = false;
        PsiElement $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        PsiElement $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept(new PsiRecursiveElementWalkingVisitor(hasLiteralValue, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                if (element instanceof KtExpression && ((Boolean)this.$predicate.invoke(element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        if ((PsiElement)result$iv$iv$iv.element == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSimpleExpression(KtExpression $this$isSimpleExpression, KtSingleValueToken operation) {
        KtExpression e = this.skipParentheses$sonar_kotlin_plugin($this$isSimpleExpression);
        if (e instanceof KtNameReferenceExpression) {
            return true;
        }
        if (e instanceof KtConstantExpression) {
            return true;
        }
        if (!(e instanceof KtBinaryExpression)) return false;
        if (!Intrinsics.areEqual(((KtBinaryExpression)e).getOperationToken(), operation)) return false;
        KtExpression ktExpression = ((KtBinaryExpression)e).getLeft();
        Intrinsics.checkNotNull(ktExpression);
        if (!this.isSimpleExpression(ktExpression, operation)) return false;
        KtExpression ktExpression2 = ((KtBinaryExpression)e).getRight();
        Intrinsics.checkNotNull(ktExpression2);
        if (!this.isSimpleExpression(ktExpression2, operation)) return false;
        return true;
    }

    public static final /* synthetic */ boolean access$isFalseValueLiteral(IfConditionalAlwaysTrueOrFalseCheck $this, KtExpression $receiver) {
        return $this.isFalseValueLiteral($receiver);
    }

    public static final /* synthetic */ boolean access$isTrueValueLiteral(IfConditionalAlwaysTrueOrFalseCheck $this, KtExpression $receiver) {
        return $this.isTrueValueLiteral($receiver);
    }
}

