/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.AbstractCheck;
import org.sonarsource.kotlin.api.ApiExtensionsKt;
import org.sonarsource.kotlin.plugin.KotlinFileContext;

@Rule(key="S6315")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/sonarsource/kotlin/checks/UnusedDeferredResultCheck;", "Lorg/sonarsource/kotlin/api/AbstractCheck;", "()V", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "context", "Lorg/sonarsource/kotlin/plugin/KotlinFileContext;", "sonar-kotlin-plugin"})
public final class UnusedDeferredResultCheck
extends AbstractCheck {
    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression2, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        BindingContext bindingContext2 = context.getBindingContext();
        if (Intrinsics.areEqual(ApiExtensionsKt.expressionTypeFqn(expression2, bindingContext2), "kotlinx.coroutines.Deferred") && BindingContextUtilsKt.isUsedAsStatement(expression2, bindingContext2)) {
            AbstractCheck abstractCheck = this;
            KtExpression ktExpression = expression2.getCalleeExpression();
            Intrinsics.checkNotNull(ktExpression);
            AbstractCheck.reportIssue$sonar_kotlin_plugin$default(abstractCheck, context, ktExpression, "This function returns \"Deferred\", but its result is never used.", null, null, 12, null);
            return;
        }
    }
}

