/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.fs.TextRange;
import org.sonarsource.kotlin.converter.Annotation;
import org.sonarsource.kotlin.converter.Comment;
import org.sonarsource.kotlin.converter.KotlinTextRanges;
import org.sonarsource.kotlin.converter.Token;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0017H\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lorg/sonarsource/kotlin/converter/CommentAnnotationsAndTokenVisitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "psiDocument", "Lorg/jetbrains/kotlin/com/intellij/openapi/editor/Document;", "inputFile", "Lorg/sonar/api/batch/fs/InputFile;", "(Lorg/jetbrains/kotlin/com/intellij/openapi/editor/Document;Lorg/sonar/api/batch/fs/InputFile;)V", "allAnnotations", "", "Lorg/sonarsource/kotlin/converter/Annotation;", "getAllAnnotations", "()Ljava/util/List;", "allComments", "Lorg/sonarsource/kotlin/converter/Comment;", "getAllComments", "tokens", "Lorg/sonarsource/kotlin/converter/Token;", "getTokens", "createComment", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiComment;", "range", "Lorg/sonar/api/batch/fs/TextRange;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "visitElement", "", "Companion", "sonar-kotlin-plugin"})
public final class CommentAnnotationsAndTokenVisitor
extends KtTreeVisitorVoid {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Document psiDocument;
    @NotNull
    private final InputFile inputFile;
    @NotNull
    private final List<Comment> allComments;
    @NotNull
    private final List<Annotation> allAnnotations;
    @NotNull
    private final List<Token> tokens;
    private static final int MIN_BLOCK_COMMENT_LENGTH = 4;
    private static final int MIN_DOC_COMMENT_LENGTH = 5;
    private static final int MIN_LINE_COMMENT_LENGTH = 2;
    private static final int BLOCK_COMMENT_PREFIX_LENGTH = 2;
    private static final int BLOCK_COMMENT_SUFFIX_LENGTH = 2;
    private static final int DOC_COMMENT_PREFIX_LENGTH = 3;
    private static final int DOC_COMMENT_SUFFIX_LENGTH = 2;
    private static final int LINE_COMMENT_PREFIX_LENGTH = 2;

    public CommentAnnotationsAndTokenVisitor(@NotNull Document psiDocument, @NotNull InputFile inputFile) {
        Intrinsics.checkNotNullParameter(psiDocument, "psiDocument");
        Intrinsics.checkNotNullParameter(inputFile, "inputFile");
        this.psiDocument = psiDocument;
        this.inputFile = inputFile;
        this.allComments = new ArrayList();
        this.allAnnotations = new ArrayList();
        this.tokens = new ArrayList();
    }

    @NotNull
    public final List<Comment> getAllComments() {
        return this.allComments;
    }

    @NotNull
    public final List<Annotation> getAllAnnotations() {
        return this.allAnnotations;
    }

    @NotNull
    public final List<Token> getTokens() {
        return this.tokens;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        if (element instanceof PsiComment) {
            this.allComments.add(this.createComment((PsiComment)element));
        } else if (element instanceof LeafPsiElement && !(element instanceof PsiWhiteSpace)) {
            Token.Type type2 = ((LeafPsiElement)element).getElementType() instanceof KtKeywordToken ? Token.Type.KEYWORD : (((LeafPsiElement)element).getElementType() == KtTokens.REGULAR_STRING_PART ? Token.Type.STRING_LITERAL : Token.Type.OTHER);
            boolean bl = false;
            TextRange textRange2 = this.range(element);
            String string2 = ((LeafPsiElement)element).getText();
            Intrinsics.checkNotNullExpressionValue(string2, "element.text");
            this.tokens.add(new Token(textRange2, string2, type2));
        } else if (element instanceof KtAnnotationEntry) {
            Name name = ((KtAnnotationEntry)element).getShortName();
            if (name != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                Name shortName = name;
                boolean bl = false;
                List<? extends ValueArgument> list2 = ((KtAnnotationEntry)element).getValueArguments();
                Intrinsics.checkNotNullExpressionValue(list2, "element.valueArguments");
                Iterable iterable = list2;
                boolean $i$f$filterIsInstance = false;
                void var7_8 = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof KtValueArgument)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterIsInstanceTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void obj;
                    KtValueArgument ktValueArgument = (KtValueArgument)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(obj.getText());
                }
                List argumentsText = (List)destination$iv$iv;
                String string3 = shortName.asString();
                Intrinsics.checkNotNullExpressionValue(string3, "shortName.asString()");
                this.allAnnotations.add(new Annotation(string3, argumentsText, this.range(element)));
            }
        }
        super.visitElement(element);
    }

    private final Comment createComment(PsiComment element) {
        String text = element.getText();
        IElementType iElementType = element.getTokenType();
        Intrinsics.checkNotNullExpressionValue(iElementType, "element.tokenType");
        IElementType tokenType = iElementType;
        int length = text.length();
        Pair<Integer, Integer> pair = Intrinsics.areEqual(KtTokens.BLOCK_COMMENT, tokenType) && length >= 4 ? TuplesKt.to(2, 2) : (Intrinsics.areEqual(KtTokens.DOC_COMMENT, tokenType) && length >= 5 ? TuplesKt.to(3, 2) : ((Intrinsics.areEqual(KtTokens.EOL_COMMENT, tokenType) || Intrinsics.areEqual(KtTokens.SHEBANG_COMMENT, tokenType)) && length >= 2 ? TuplesKt.to(2, 0) : TuplesKt.to(0, 0)));
        int prefixLength = ((Number)pair.component1()).intValue();
        int suffixLength = ((Number)pair.component2()).intValue();
        Intrinsics.checkNotNullExpressionValue(text, "text");
        String string2 = text.substring(prefixLength, length - suffixLength);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        String contentText = string2;
        TextRange range = this.range(element);
        return new Comment(text, contentText, range);
    }

    private final TextRange range(PsiElement element) {
        TextPointer start = KotlinTextRanges.INSTANCE.textPointerAtOffset(this.inputFile, this.psiDocument, PsiUtilsKt.getStartOffset(element));
        TextPointer end = KotlinTextRanges.INSTANCE.textPointerAtOffset(this.inputFile, this.psiDocument, PsiUtilsKt.getEndOffset(element));
        TextRange textRange2 = this.inputFile.newRange(start, end);
        Intrinsics.checkNotNullExpressionValue(textRange2, "inputFile.newRange(start, end)");
        return textRange2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/sonarsource/kotlin/converter/CommentAnnotationsAndTokenVisitor$Companion;", "", "()V", "BLOCK_COMMENT_PREFIX_LENGTH", "", "BLOCK_COMMENT_SUFFIX_LENGTH", "DOC_COMMENT_PREFIX_LENGTH", "DOC_COMMENT_SUFFIX_LENGTH", "LINE_COMMENT_PREFIX_LENGTH", "MIN_BLOCK_COMMENT_LENGTH", "MIN_DOC_COMMENT_LENGTH", "MIN_LINE_COMMENT_LENGTH", "sonar-kotlin-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

