/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.externalreport.androidlint;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.analyzer.commons.ExternalRuleLoader;
import org.sonarsource.kotlin.externalreport.androidlint.AndroidLintRulesDefinitionKt;
import org.sonarsource.kotlin.externalreport.androidlint.AndroidLintSensor;
import org.sonarsource.kotlin.externalreport.androidlint.AndroidLintXmlReportReader;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a0\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"LOG", "Lorg/sonar/api/utils/log/Logger;", "kotlin.jvm.PlatformType", "NO_ISSUES_ERROR_MESSAGE", "", "importReport", "", "reportPath", "Ljava/io/File;", "context", "Lorg/sonar/api/batch/sensor/SensorContext;", "saveIssue", "id", "file", "line", "message", "sonar-kotlin-plugin"})
public final class AndroidLintSensorKt {
    private static final Logger LOG = Loggers.get(AndroidLintSensor.class);
    @NotNull
    public static final String NO_ISSUES_ERROR_MESSAGE = "No issues information will be saved as the report file '{}' can't be read.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void importReport(File reportPath, SensorContext context) {
        try {
            Closeable closeable = new FileInputStream(reportPath);
            Throwable throwable = null;
            try {
                FileInputStream it = (FileInputStream)closeable;
                boolean bl = false;
                AndroidLintXmlReportReader.Companion.read(it, (arg_0, arg_1, arg_2, arg_3) -> AndroidLintSensorKt.importReport$lambda-1$lambda-0(context, arg_0, arg_1, arg_2, arg_3));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (Exception e) {
            LOG.error(NO_ISSUES_ERROR_MESSAGE, (Object)reportPath, (Object)e);
        }
    }

    private static final void saveIssue(SensorContext context, String id, String file2, String line, String message) {
        if (((CharSequence)id).length() == 0 || ((CharSequence)message).length() == 0 || ((CharSequence)file2).length() == 0 || !AndroidLintRulesDefinitionKt.isTextFile(file2)) {
            Object[] objectArray = new Object[]{id, file2, message};
            LOG.debug("Missing information or unsupported file type for id:'{}', file:'{}', message:'{}'", objectArray);
            return;
        }
        FilePredicates predicates = context.fileSystem().predicates();
        InputFile inputFile = context.fileSystem().inputFile(predicates.or(predicates.hasAbsolutePath(file2), predicates.hasRelativePath(file2)));
        if (inputFile == null) {
            LOG.warn("No input file found for {}. No android lint issues will be imported on this file.", (Object)file2);
            return;
        }
        ExternalRuleLoader externalRuleLoader = AndroidLintRulesDefinitionKt.getRULE_LOADER();
        String ruleKey = externalRuleLoader.ruleKeys().contains(id) ? id : "external.catchall";
        NewExternalIssue newExternalIssue = context.newExternalIssue();
        newExternalIssue.type(externalRuleLoader.ruleType(ruleKey)).severity(externalRuleLoader.ruleSeverity(ruleKey)).remediationEffortMinutes(externalRuleLoader.ruleConstantDebtMinutes(ruleKey));
        NewIssueLocation primaryLocation = newExternalIssue.newLocation().message(message).on((InputComponent)inputFile);
        if (((CharSequence)line).length() > 0) {
            primaryLocation.at(inputFile.selectLine(Integer.parseInt(line)));
        }
        newExternalIssue.at(primaryLocation).engineId("android-lint").ruleId(ruleKey).save();
    }

    private static final void importReport$lambda-1$lambda-0(SensorContext $context, String id, String file2, String line, String message) {
        Intrinsics.checkNotNullParameter($context, "$context");
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(line, "line");
        Intrinsics.checkNotNullParameter(message, "message");
        AndroidLintSensorKt.saveIssue($context, id, file2, line, message);
    }

    public static final /* synthetic */ void access$importReport(File reportPath, SensorContext context) {
        AndroidLintSensorKt.importReport(reportPath, context);
    }
}

