/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.externalreport.ktlint;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonarsource.analyzer.commons.ExternalRuleLoader;
import org.sonarsource.kotlin.externalreport.ktlint.CheckstyleReportParser;
import org.sonarsource.kotlin.externalreport.ktlint.Finding;
import org.sonarsource.kotlin.externalreport.ktlint.FindingsPerFile;
import org.sonarsource.kotlin.externalreport.ktlint.InvalidReportFormatException;
import org.sonarsource.kotlin.externalreport.ktlint.JsonReportParser;
import org.sonarsource.kotlin.externalreport.ktlint.KtlintRulesDefinition;
import org.sonarsource.kotlin.externalreport.ktlint.ReportImporterKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/sonarsource/kotlin/externalreport/ktlint/ReportImporter;", "", "analysisWarnings", "Lorg/sonar/api/notifications/AnalysisWarnings;", "context", "Lorg/sonar/api/batch/sensor/SensorContext;", "(Lorg/sonar/api/notifications/AnalysisWarnings;Lorg/sonar/api/batch/sensor/SensorContext;)V", "getAnalysisWarnings", "()Lorg/sonar/api/notifications/AnalysisWarnings;", "getContext", "()Lorg/sonar/api/batch/sensor/SensorContext;", "importExternalIssues", "", "filePath", "", "linterFindings", "", "Lorg/sonarsource/kotlin/externalreport/ktlint/Finding;", "importFile", "reportFile", "Ljava/io/File;", "importJsonFile", "sonar-kotlin-plugin"})
public final class ReportImporter {
    @NotNull
    private final AnalysisWarnings analysisWarnings;
    @NotNull
    private final SensorContext context;

    public ReportImporter(@NotNull AnalysisWarnings analysisWarnings, @NotNull SensorContext context) {
        Intrinsics.checkNotNullParameter(analysisWarnings, "analysisWarnings");
        Intrinsics.checkNotNullParameter(context, "context");
        this.analysisWarnings = analysisWarnings;
        this.context = context;
    }

    @NotNull
    public final AnalysisWarnings getAnalysisWarnings() {
        return this.analysisWarnings;
    }

    @NotNull
    public final SensorContext getContext() {
        return this.context;
    }

    public final void importFile(@NotNull File reportFile) {
        Intrinsics.checkNotNullParameter(reportFile, "reportFile");
        String string2 = FilesKt.getExtension(reportFile);
        if (Intrinsics.areEqual(string2, "json")) {
            this.importJsonFile(reportFile);
        } else if (Intrinsics.areEqual(string2, "xml")) {
            new CheckstyleReportParser(this.context).importFile(reportFile);
        } else {
            String it = "The ktlint report file '" + reportFile + "' has an unsupported extension/format. Expected 'json' or 'xml', got '" + FilesKt.getExtension(reportFile) + "'.";
            boolean bl = false;
            ReportImporterKt.getLOG().error(it);
            this.analysisWarnings.addUnique(it);
        }
    }

    public final void importJsonFile(@NotNull File reportFile) {
        JsonReportParser jsonReportParser;
        Intrinsics.checkNotNullParameter(reportFile, "reportFile");
        try {
            Path path2 = reportFile.toPath();
            Intrinsics.checkNotNullExpressionValue(path2, "reportFile.toPath()");
            JsonReportParser $this$importJsonFile_u24lambda_u2d1 = jsonReportParser = new JsonReportParser(path2);
            boolean bl = false;
            $this$importJsonFile_u24lambda_u2d1.parse();
        }
        catch (InvalidReportFormatException e) {
            ReportImporterKt.getLOG().error("No issue information will be saved as the report file '" + reportFile + "' cannot be read. " + e.getMessage());
            return;
        }
        JsonReportParser parser = jsonReportParser;
        Iterable $this$forEach$iv = parser.getReport();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FindingsPerFile findingsPerFile = (FindingsPerFile)element$iv;
            boolean bl = false;
            String filePath = findingsPerFile.component1();
            List<Finding> linterFindings = findingsPerFile.component2();
            this.importExternalIssues(filePath, linterFindings);
        }
    }

    private final void importExternalIssues(String filePath, List<Finding> linterFindings) {
        FilePredicates predicates = this.context.fileSystem().predicates();
        InputFile inputFile = this.context.fileSystem().inputFile(predicates.or(predicates.hasAbsolutePath(filePath), predicates.hasRelativePath(filePath)));
        if (inputFile == null) {
            ReportImporter $this$importExternalIssues_u24lambda_u2d3 = this;
            boolean bl = false;
            ReportImporterKt.getLOG().warn("Invalid input file " + filePath);
            return;
        }
        InputFile inputFile2 = inputFile;
        ExternalRuleLoader ruleLoader = KtlintRulesDefinition.Companion.getRULE_LOADER();
        Iterable $this$forEach$iv = linterFindings;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NewExternalIssue newExternalIssue;
            String string2;
            Finding finding = (Finding)element$iv;
            boolean bl = false;
            int line = finding.component1();
            String message = finding.component3();
            String preliminaryRuleKey = finding.component4();
            if (StringsKt.startsWith$default(preliminaryRuleKey, "experimental:", false, 2, null)) {
                String string3 = preliminaryRuleKey.substring("experimental:".length());
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).substring(startIndex)");
            } else {
                string2 = preliminaryRuleKey;
            }
            String truncatedPrelimRuleKey = string2;
            String ruleKey = KtlintRulesDefinition.Companion.getRULE_LOADER().ruleKeys().contains(truncatedPrelimRuleKey) ? truncatedPrelimRuleKey : "external.catchall";
            NewExternalIssue $this$importExternalIssues_u24lambda_u2d5_u24lambda_u2d4 = newExternalIssue = this.context.newExternalIssue();
            boolean bl2 = false;
            $this$importExternalIssues_u24lambda_u2d5_u24lambda_u2d4.type(ruleLoader.ruleType(ruleKey));
            $this$importExternalIssues_u24lambda_u2d5_u24lambda_u2d4.severity(ruleLoader.ruleSeverity(ruleKey));
            $this$importExternalIssues_u24lambda_u2d5_u24lambda_u2d4.remediationEffortMinutes(ruleLoader.ruleConstantDebtMinutes(ruleKey));
            $this$importExternalIssues_u24lambda_u2d5_u24lambda_u2d4.at($this$importExternalIssues_u24lambda_u2d5_u24lambda_u2d4.newLocation().message(message).on((InputComponent)inputFile2).at(inputFile2.selectLine(line)));
            $this$importExternalIssues_u24lambda_u2d5_u24lambda_u2d4.engineId("ktlint");
            $this$importExternalIssues_u24lambda_u2d5_u24lambda_u2d4.ruleId(ruleKey);
            $this$importExternalIssues_u24lambda_u2d5_u24lambda_u2d4.save();
        }
    }
}

