/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.plugin;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonarsource.kotlin.api.InputFileContext;
import org.sonarsource.kotlin.plugin.KotlinFileContext;
import org.sonarsource.kotlin.plugin.KtMetricVisitor;
import org.sonarsource.kotlin.plugin.MetricVisitorKt;
import org.sonarsource.kotlin.visiting.KotlinFileVisitor;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\t\u001a\u00020\nJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\fJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\fJ\u0006\u0010\u0011\u001a\u00020\nJ\u0006\u0010\u0012\u001a\u00020\nJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/sonarsource/kotlin/plugin/MetricVisitor;", "Lorg/sonarsource/kotlin/visiting/KotlinFileVisitor;", "fileLinesContextFactory", "Lorg/sonar/api/measures/FileLinesContextFactory;", "noSonarFilter", "Lorg/sonar/api/issue/NoSonarFilter;", "(Lorg/sonar/api/measures/FileLinesContextFactory;Lorg/sonar/api/issue/NoSonarFilter;)V", "ktMetricVisitor", "Lorg/sonarsource/kotlin/plugin/KtMetricVisitor;", "cognitiveComplexity", "", "commentLines", "", "executableLines", "", "linesOfCode", "nosonarLines", "numberOfClasses", "numberOfFunctions", "visit", "", "kotlinFileContext", "Lorg/sonarsource/kotlin/plugin/KotlinFileContext;", "sonar-kotlin-plugin"})
public final class MetricVisitor
extends KotlinFileVisitor {
    @NotNull
    private final FileLinesContextFactory fileLinesContextFactory;
    @NotNull
    private final NoSonarFilter noSonarFilter;
    private KtMetricVisitor ktMetricVisitor;

    public MetricVisitor(@NotNull FileLinesContextFactory fileLinesContextFactory, @NotNull NoSonarFilter noSonarFilter) {
        Intrinsics.checkNotNullParameter(fileLinesContextFactory, "fileLinesContextFactory");
        Intrinsics.checkNotNullParameter(noSonarFilter, "noSonarFilter");
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.noSonarFilter = noSonarFilter;
    }

    @Override
    public void visit(@NotNull KotlinFileContext kotlinFileContext) {
        int line;
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        this.ktMetricVisitor = new KtMetricVisitor();
        InputFileContext ctx = kotlinFileContext.component1();
        KtFile file2 = kotlinFileContext.component2();
        KtMetricVisitor ktMetricVisitor = this.ktMetricVisitor;
        if (ktMetricVisitor == null) {
            Intrinsics.throwUninitializedPropertyAccessException("ktMetricVisitor");
            ktMetricVisitor = null;
        }
        file2.accept(ktMetricVisitor);
        org.sonar.api.measures.Metric metric = CoreMetrics.NCLOC;
        Intrinsics.checkNotNullExpressionValue(metric, "NCLOC");
        Metric metric2 = (Metric)metric;
        KtMetricVisitor ktMetricVisitor2 = this.ktMetricVisitor;
        if (ktMetricVisitor2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("ktMetricVisitor");
            ktMetricVisitor2 = null;
        }
        MetricVisitorKt.access$saveMetric(ctx, metric2, ktMetricVisitor2.getLinesOfCode().size());
        org.sonar.api.measures.Metric metric3 = CoreMetrics.COMMENT_LINES;
        Intrinsics.checkNotNullExpressionValue(metric3, "COMMENT_LINES");
        Metric metric4 = (Metric)metric3;
        KtMetricVisitor ktMetricVisitor3 = this.ktMetricVisitor;
        if (ktMetricVisitor3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("ktMetricVisitor");
            ktMetricVisitor3 = null;
        }
        MetricVisitorKt.access$saveMetric(ctx, metric4, ktMetricVisitor3.getCommentLines().size());
        org.sonar.api.measures.Metric metric5 = CoreMetrics.FUNCTIONS;
        Intrinsics.checkNotNullExpressionValue(metric5, "FUNCTIONS");
        Metric metric6 = (Metric)metric5;
        KtMetricVisitor ktMetricVisitor4 = this.ktMetricVisitor;
        if (ktMetricVisitor4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("ktMetricVisitor");
            ktMetricVisitor4 = null;
        }
        MetricVisitorKt.access$saveMetric(ctx, metric6, ktMetricVisitor4.getNumberOfFunctions());
        org.sonar.api.measures.Metric metric7 = CoreMetrics.CLASSES;
        Intrinsics.checkNotNullExpressionValue(metric7, "CLASSES");
        Metric metric8 = (Metric)metric7;
        KtMetricVisitor ktMetricVisitor5 = this.ktMetricVisitor;
        if (ktMetricVisitor5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("ktMetricVisitor");
            ktMetricVisitor5 = null;
        }
        MetricVisitorKt.access$saveMetric(ctx, metric8, ktMetricVisitor5.getNumberOfClasses());
        org.sonar.api.measures.Metric metric9 = CoreMetrics.COMPLEXITY;
        Intrinsics.checkNotNullExpressionValue(metric9, "COMPLEXITY");
        Metric metric10 = (Metric)metric9;
        KtMetricVisitor ktMetricVisitor6 = this.ktMetricVisitor;
        if (ktMetricVisitor6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("ktMetricVisitor");
            ktMetricVisitor6 = null;
        }
        MetricVisitorKt.access$saveMetric(ctx, metric10, ktMetricVisitor6.getComplexity());
        org.sonar.api.measures.Metric metric11 = CoreMetrics.STATEMENTS;
        Intrinsics.checkNotNullExpressionValue(metric11, "STATEMENTS");
        Metric metric12 = (Metric)metric11;
        KtMetricVisitor ktMetricVisitor7 = this.ktMetricVisitor;
        if (ktMetricVisitor7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("ktMetricVisitor");
            ktMetricVisitor7 = null;
        }
        MetricVisitorKt.access$saveMetric(ctx, metric12, ktMetricVisitor7.getStatements());
        org.sonar.api.measures.Metric metric13 = CoreMetrics.COGNITIVE_COMPLEXITY;
        Intrinsics.checkNotNullExpressionValue(metric13, "COGNITIVE_COMPLEXITY");
        Metric metric14 = (Metric)metric13;
        KtMetricVisitor ktMetricVisitor8 = this.ktMetricVisitor;
        if (ktMetricVisitor8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("ktMetricVisitor");
            ktMetricVisitor8 = null;
        }
        MetricVisitorKt.access$saveMetric(ctx, metric14, ktMetricVisitor8.getCognitiveComplexity());
        FileLinesContext fileLinesContext = this.fileLinesContextFactory.createFor(ctx.getInputFile());
        KtMetricVisitor ktMetricVisitor9 = this.ktMetricVisitor;
        if (ktMetricVisitor9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("ktMetricVisitor");
            ktMetricVisitor9 = null;
        }
        Iterable $this$forEach$iv = ktMetricVisitor9.getLinesOfCode();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            line = ((Number)element$iv).intValue();
            boolean bl = false;
            fileLinesContext.setIntValue("ncloc_data", line, 1);
        }
        KtMetricVisitor ktMetricVisitor10 = this.ktMetricVisitor;
        if (ktMetricVisitor10 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("ktMetricVisitor");
            ktMetricVisitor10 = null;
        }
        $this$forEach$iv = ktMetricVisitor10.getExecutableLines();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            line = ((Number)element$iv).intValue();
            boolean bl = false;
            fileLinesContext.setIntValue("executable_lines_data", line, 1);
        }
        fileLinesContext.save();
        InputFile inputFile = ctx.getInputFile();
        KtMetricVisitor ktMetricVisitor11 = this.ktMetricVisitor;
        if (ktMetricVisitor11 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("ktMetricVisitor");
            ktMetricVisitor11 = null;
        }
        this.noSonarFilter.noSonarInFile(inputFile, ktMetricVisitor11.getNosonarLines());
    }

    @NotNull
    public final Set<Integer> commentLines() {
        KtMetricVisitor ktMetricVisitor = this.ktMetricVisitor;
        if (ktMetricVisitor == null) {
            Intrinsics.throwUninitializedPropertyAccessException("ktMetricVisitor");
            ktMetricVisitor = null;
        }
        return CollectionsKt.toSet((Iterable)ktMetricVisitor.getCommentLines());
    }

    @NotNull
    public final Set<Integer> linesOfCode() {
        KtMetricVisitor ktMetricVisitor = this.ktMetricVisitor;
        if (ktMetricVisitor == null) {
            Intrinsics.throwUninitializedPropertyAccessException("ktMetricVisitor");
            ktMetricVisitor = null;
        }
        return CollectionsKt.toSet((Iterable)ktMetricVisitor.getLinesOfCode());
    }

    @NotNull
    public final Set<Integer> nosonarLines() {
        KtMetricVisitor ktMetricVisitor = this.ktMetricVisitor;
        if (ktMetricVisitor == null) {
            Intrinsics.throwUninitializedPropertyAccessException("ktMetricVisitor");
            ktMetricVisitor = null;
        }
        return CollectionsKt.toSet((Iterable)ktMetricVisitor.getNosonarLines());
    }

    public final int numberOfFunctions() {
        KtMetricVisitor ktMetricVisitor = this.ktMetricVisitor;
        if (ktMetricVisitor == null) {
            Intrinsics.throwUninitializedPropertyAccessException("ktMetricVisitor");
            ktMetricVisitor = null;
        }
        return ktMetricVisitor.getNumberOfFunctions();
    }

    public final int numberOfClasses() {
        KtMetricVisitor ktMetricVisitor = this.ktMetricVisitor;
        if (ktMetricVisitor == null) {
            Intrinsics.throwUninitializedPropertyAccessException("ktMetricVisitor");
            ktMetricVisitor = null;
        }
        return ktMetricVisitor.getNumberOfClasses();
    }

    public final int cognitiveComplexity() {
        KtMetricVisitor ktMetricVisitor = this.ktMetricVisitor;
        if (ktMetricVisitor == null) {
            Intrinsics.throwUninitializedPropertyAccessException("ktMetricVisitor");
            ktMetricVisitor = null;
        }
        return ktMetricVisitor.getCognitiveComplexity();
    }

    @NotNull
    public final Set<Integer> executableLines() {
        KtMetricVisitor ktMetricVisitor = this.ktMetricVisitor;
        if (ktMetricVisitor == null) {
            Intrinsics.throwUninitializedPropertyAccessException("ktMetricVisitor");
            ktMetricVisitor = null;
        }
        return ktMetricVisitor.getExecutableLines();
    }
}

