/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ngram.NGramTokenizer;
import org.elasticsearch.Version;
import org.elasticsearch.analysis.common.CharMatcher;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenizerFactory;

public class NGramTokenizerFactory
extends AbstractTokenizerFactory {
    private final int minGram;
    private final int maxGram;
    private final CharMatcher matcher;
    static final Map<String, CharMatcher> MATCHERS;

    static CharMatcher parseTokenChars(Settings settings) {
        List characterClasses = settings.getAsList("token_chars");
        if (characterClasses == null || characterClasses.isEmpty()) {
            return null;
        }
        CharMatcher.Builder builder = new CharMatcher.Builder();
        for (String characterClass : characterClasses) {
            CharMatcher matcher = MATCHERS.get(characterClass = characterClass.toLowerCase(Locale.ROOT).trim());
            if (matcher == null) {
                if (!characterClass.equals("custom")) {
                    throw new IllegalArgumentException("Unknown token type: '" + characterClass + "', must be one of " + Stream.of(MATCHERS.keySet(), Collections.singleton("custom")).flatMap(x -> x.stream()).collect(Collectors.toSet()));
                }
                String customCharacters = settings.get("custom_token_chars");
                if (customCharacters == null) {
                    throw new IllegalArgumentException("Token type: 'custom' requires setting `custom_token_chars`");
                }
                final Set customCharSet = customCharacters.chars().boxed().collect(Collectors.toSet());
                matcher = new CharMatcher(){

                    @Override
                    public boolean isTokenChar(int c) {
                        return customCharSet.contains(c);
                    }
                };
            }
            builder.or(matcher);
        }
        return builder.build();
    }

    NGramTokenizerFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, settings, name);
        int maxAllowedNgramDiff = indexSettings.getMaxNgramDiff();
        this.minGram = settings.getAsInt("min_gram", Integer.valueOf(1));
        this.maxGram = settings.getAsInt("max_gram", Integer.valueOf(2));
        int ngramDiff = this.maxGram - this.minGram;
        if (ngramDiff > maxAllowedNgramDiff) {
            if (indexSettings.getIndexVersionCreated().onOrAfter(Version.V_7_0_0)) {
                throw new IllegalArgumentException("The difference between max_gram and min_gram in NGram Tokenizer must be less than or equal to: [" + maxAllowedNgramDiff + "] but was [" + ngramDiff + "]. This limit can be set by changing the [" + IndexSettings.MAX_NGRAM_DIFF_SETTING.getKey() + "] index level setting.");
            }
            this.deprecationLogger.critical(DeprecationCategory.ANALYSIS, "ngram_big_difference", "Deprecated big difference between max_gram and min_gram in NGram Tokenizer,expected difference must be less than or equal to: [" + maxAllowedNgramDiff + "]", new Object[0]);
        }
        this.matcher = NGramTokenizerFactory.parseTokenChars(settings);
    }

    public Tokenizer create() {
        if (this.matcher == null) {
            return new NGramTokenizer(this.minGram, this.maxGram);
        }
        return new NGramTokenizer(this.minGram, this.maxGram){

            protected boolean isTokenChar(int chr) {
                return NGramTokenizerFactory.this.matcher.isTokenChar(chr);
            }
        };
    }

    static {
        HashMap<String, CharMatcher> matchers = new HashMap<String, CharMatcher>();
        matchers.put("letter", CharMatcher.Basic.LETTER);
        matchers.put("digit", CharMatcher.Basic.DIGIT);
        matchers.put("whitespace", CharMatcher.Basic.WHITESPACE);
        matchers.put("punctuation", CharMatcher.Basic.PUNCTUATION);
        matchers.put("symbol", CharMatcher.Basic.SYMBOL);
        for (Field field : Character.class.getFields()) {
            if (field.getName().startsWith("DIRECTIONALITY") || !Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || field.getType() != Byte.TYPE) continue;
            try {
                matchers.put(field.getName().toLowerCase(Locale.ROOT), CharMatcher.ByUnicodeCategory.of(field.getByte(null)));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        MATCHERS = Collections.unmodifiableMap(matchers);
    }
}

