/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.coverage;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.python.EmptyReportException;
import org.sonar.plugins.python.PythonReportSensor;
import org.sonar.plugins.python.coverage.CoberturaParser;
import org.sonar.plugins.python.warnings.AnalysisWarningsWrapper;

public class PythonCoverageSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(PythonCoverageSensor.class);
    public static final String REPORT_PATHS_KEY = "sonar.python.coverage.reportPaths";
    public static final String DEFAULT_REPORT_PATH = "coverage-reports/*coverage-*.xml";
    public static final String REPORT_PATH_KEY = "sonar.python.coverage.reportPath";
    private final AnalysisWarningsWrapper analysisWarnings;

    public PythonCoverageSensor(AnalysisWarningsWrapper analysisWarnings) {
        this.analysisWarnings = analysisWarnings;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("Cobertura Sensor for Python coverage").onlyOnLanguage("py");
    }

    public void execute(SensorContext context) {
        String baseDir = context.fileSystem().baseDir().getPath();
        Configuration config = context.config();
        this.warnDeprecatedPropertyUsage(config);
        HashSet<InputFile> filesCovered = new HashSet<InputFile>();
        List<File> reports = this.getCoverageReports(baseDir, config);
        if (!reports.isEmpty()) {
            LOG.info("Python test coverage");
            for (File report : PythonCoverageSensor.uniqueAbsolutePaths(reports)) {
                Map<InputFile, NewCoverage> coverageMeasures = this.parseReport(report, context);
                PythonCoverageSensor.saveMeasures(coverageMeasures, filesCovered);
            }
        }
    }

    private List<File> getCoverageReports(String baseDir, Configuration config) {
        if (!config.hasKey(REPORT_PATHS_KEY)) {
            return PythonReportSensor.getReports(config, baseDir, REPORT_PATHS_KEY, DEFAULT_REPORT_PATH, this.analysisWarnings);
        }
        return Arrays.stream(config.getStringArray(REPORT_PATHS_KEY)).flatMap(path -> PythonReportSensor.getReports(config, baseDir, REPORT_PATHS_KEY, path, this.analysisWarnings).stream()).collect(Collectors.toList());
    }

    private void warnDeprecatedPropertyUsage(Configuration config) {
        if (config.hasKey(REPORT_PATH_KEY)) {
            String msg = "Property 'sonar.python.coverage.reportPath' has been removed. Please use 'sonar.python.coverage.reportPaths' instead.";
            LOG.warn(msg);
            this.analysisWarnings.addUnique(msg);
        }
    }

    private static Set<File> uniqueAbsolutePaths(List<File> reports) {
        return reports.stream().map(File::getAbsoluteFile).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Map<InputFile, NewCoverage> parseReport(File report, SensorContext context) {
        HashMap<InputFile, NewCoverage> coverageMeasures = new HashMap<InputFile, NewCoverage>();
        try {
            CoberturaParser parser = new CoberturaParser();
            parser.parseReport(report, context, coverageMeasures);
            if (!parser.errors().isEmpty()) {
                String parseErrors = String.join((CharSequence)"%n", parser.errors());
                this.analysisWarnings.addUnique(String.format("The following error(s) occurred while trying to import coverage report:%n%s", parseErrors));
            }
        }
        catch (EmptyReportException e) {
            this.analysisWarnings.addUnique(String.format("The coverage report '%s' has been ignored because it seems to be empty.", report));
            LOG.warn("The report '{}' seems to be empty, ignoring. '{}'", (Object)report, (Object)e);
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException("Error parsing the report '" + report + "'", e);
        }
        return coverageMeasures;
    }

    private static void saveMeasures(Map<InputFile, NewCoverage> coverageMeasures, HashSet<InputFile> coveredFiles) {
        for (Map.Entry<InputFile, NewCoverage> entry : coverageMeasures.entrySet()) {
            InputFile inputFile = entry.getKey();
            coveredFiles.add(inputFile);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Saving coverage measures for file '{}'", (Object)inputFile.toString());
            }
            entry.getValue().save();
        }
    }
}

