/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.caching;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.python.TokenLocation;
import org.sonar.python.caching.StringTable;
import org.sonar.python.caching.VarLengthInputStream;
import org.sonar.python.caching.VarLengthOutputStream;

public class CpdSerializer {
    private CpdSerializer() {
    }

    public static SerializationResult serialize(List<Token> tokens) throws IOException {
        return new Serializer().convert(tokens);
    }

    public static List<TokenInfo> deserialize(byte[] dataBytes, byte[] stringTableBytes) throws IOException {
        return new Deserializer(new VarLengthInputStream(dataBytes), new VarLengthInputStream(stringTableBytes)).convert();
    }

    private static class Deserializer {
        private final VarLengthInputStream in;
        private final VarLengthInputStream stringTableIn;
        private StringTable stringTable;

        private Deserializer(VarLengthInputStream in, VarLengthInputStream stringTableIn) {
            this.in = in;
            this.stringTableIn = stringTableIn;
        }

        public List<TokenInfo> convert() throws IOException {
            try (VarLengthInputStream varLengthInputStream = this.in;){
                ArrayList<TokenInfo> arrayList;
                block14: {
                    VarLengthInputStream varLengthInputStream2 = this.stringTableIn;
                    try {
                        this.stringTable = this.readStringTable();
                        int sizeOfCpdTokens = this.readInt();
                        ArrayList<TokenInfo> cpdTokens = new ArrayList<TokenInfo>(sizeOfCpdTokens);
                        for (int i = 0; i < sizeOfCpdTokens; ++i) {
                            this.readCpdToken(cpdTokens);
                        }
                        if (!"END".equals(this.in.readUTF())) {
                            throw new IOException("Can't read data from cache, format corrupted");
                        }
                        arrayList = cpdTokens;
                        if (varLengthInputStream2 == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (varLengthInputStream2 != null) {
                            try {
                                varLengthInputStream2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    varLengthInputStream2.close();
                }
                return arrayList;
            }
        }

        private void readCpdToken(List<TokenInfo> cpdTokens) throws IOException {
            cpdTokens.add(new TokenInfo(this.readInt(), this.readInt(), this.readInt(), this.readInt(), this.readString()));
        }

        private int readInt() throws IOException {
            return this.in.readInt();
        }

        private String readString() throws IOException {
            return this.stringTable.getString(this.in.readInt());
        }

        private StringTable readStringTable() throws IOException {
            int size = this.stringTableIn.readInt();
            ArrayList<String> byIndex = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                byIndex.add(this.stringTableIn.readUTF());
            }
            if (!"END".equals(this.stringTableIn.readUTF())) {
                throw new IOException("Can't read data from cache, format corrupted");
            }
            return new StringTable(byIndex);
        }
    }

    private static class Serializer {
        private final ByteArrayOutputStream stream = new ByteArrayOutputStream();
        private final VarLengthOutputStream out = new VarLengthOutputStream(this.stream);
        private final StringTable stringTable = new StringTable();

        private Serializer() {
        }

        public SerializationResult convert(List<Token> tokens) throws IOException {
            try (VarLengthOutputStream varLengthOutputStream = this.out;){
                SerializationResult serializationResult;
                block13: {
                    ByteArrayOutputStream byteArrayOutputStream = this.stream;
                    try {
                        this.writeInt(tokens.size());
                        for (Token token : tokens) {
                            this.write(token);
                        }
                        this.out.writeUTF("END");
                        serializationResult = new SerializationResult(this.stream.toByteArray(), this.writeStringTable());
                        if (byteArrayOutputStream == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (byteArrayOutputStream != null) {
                            try {
                                byteArrayOutputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    byteArrayOutputStream.close();
                }
                return serializationResult;
            }
        }

        private void write(Token token) throws IOException {
            TokenLocation location = new TokenLocation(token);
            this.writeInt(location.startLine());
            this.writeInt(location.startLineOffset());
            this.writeInt(location.endLine());
            this.writeInt(location.endLineOffset());
            this.writeText(token.value());
        }

        private void writeText(@Nullable String text) throws IOException {
            this.out.writeInt(this.stringTable.getIndex(text));
        }

        private void writeInt(int number) throws IOException {
            this.out.writeInt(number);
        }

        private byte[] writeStringTable() throws IOException {
            ByteArrayOutputStream stringTableStream = new ByteArrayOutputStream();
            VarLengthOutputStream output = new VarLengthOutputStream(stringTableStream);
            List<String> byIndex = this.stringTable.getStringList();
            output.writeInt(byIndex.size());
            for (String string : byIndex) {
                output.writeUTF(string);
            }
            output.writeUTF("END");
            return stringTableStream.toByteArray();
        }
    }

    public static class SerializationResult {
        public final byte[] data;
        public final byte[] stringTable;

        public SerializationResult(byte[] data, byte[] stringTable) {
            this.data = data;
            this.stringTable = stringTable;
        }
    }

    public static final class TokenInfo {
        public final int startLine;
        public final int startLineOffset;
        public final int endLine;
        public final int endLineOffset;
        public final String value;

        public static TokenInfo from(Token token) {
            TokenLocation location = new TokenLocation(token);
            return new TokenInfo(location.startLine(), location.startLineOffset(), location.endLine(), location.endLineOffset(), token.value());
        }

        public TokenInfo(int startLine, int startLineOffset, int endLine, int endLineOffset, String value) {
            this.startLine = startLine;
            this.startLineOffset = startLineOffset;
            this.endLine = endLine;
            this.endLineOffset = endLineOffset;
            this.value = value;
        }
    }
}

