/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.function.BiConsumer;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.python.checks.cdk.AbstractS3BucketCheck;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;

@Rule(key="S6252")
public class S3BucketVersioningCheck
extends AbstractS3BucketCheck {
    public static final String MESSAGE = "Make sure an unversioned S3 bucket is safe here.";
    public static final String MESSAGE_OMITTING = "Omitting the \"versioned\" argument disables S3 bucket versioning. Make sure it is safe here.";

    @Override
    BiConsumer<SubscriptionContext, CallExpression> visitBucketConstructor() {
        return (ctx, bucket) -> CdkUtils.getArgument(ctx, bucket, "versioned").ifPresentOrElse(version -> version.addIssueIf(CdkPredicate.isFalse(), MESSAGE, new IssueLocation[0]), () -> ctx.addIssue(bucket.callee(), MESSAGE_OMITTING));
    }
}

