/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.python.checks.cdk.AbstractCdkResourceCheck;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;

@Rule(key="S6319")
public class UnencryptedSageMakerNotebookCheck
extends AbstractCdkResourceCheck {
    private static final String OMITTING_MESSAGE = "Omitting kms_key_id disables encryption of SageMaker notebook instances. Make sure it is safe here.";

    @Override
    protected void registerFqnConsumer() {
        this.checkFqn("aws_cdk.aws_sagemaker.CfnNotebookInstance", (ctx, callExpression) -> CdkUtils.getArgument(ctx, callExpression, "kms_key_id").ifPresentOrElse(argKmsKey -> argKmsKey.addIssueIf(CdkPredicate.isNone(), OMITTING_MESSAGE, new IssueLocation[0]), () -> ctx.addIssue(callExpression.callee(), OMITTING_MESSAGE)));
    }
}

