/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.python.checks.cdk.AbstractCdkResourceCheck;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;

@Rule(key="S6330")
public class UnencryptedSqsQueueCheck
extends AbstractCdkResourceCheck {
    private static final String UNENCRYPTED_MESSAGE = "Setting \"encryption\" to \"QueueEncryption.UNENCRYPTED\" disables SQS queues encryption. Make sure it is safe here.";
    private static final String NONE_MESSAGE = "Setting \"encryption\" to \"None\" disables SQS queues encryption. Make sure it is safe here.";
    private static final String OMITTING_MESSAGE = "Omitting \"encryption\" disables SQS queues encryption. Make sure it is safe here.";
    private static final String CFN_NONE_MESSAGE = "Setting \"kms_master_key_id\" to \"None\" disables SQS queues encryption. Make sure it is safe here.";
    private static final String CFN_OMITTING_MESSAGE = "Omitting \"kms_master_key_id\" disables SQS queues encryption. Make sure it is safe here.";

    @Override
    protected void registerFqnConsumer() {
        this.checkFqn("aws_cdk.aws_sqs.Queue", this::checkQueue);
        this.checkFqn("aws_cdk.aws_sqs.CfnQueue", this::checkCfnQueue);
    }

    protected void checkQueue(SubscriptionContext ctx, CallExpression resourceConstructor) {
        CdkUtils.getArgument(ctx, resourceConstructor, "encryption").ifPresentOrElse(flow -> {
            flow.addIssueIf(CdkPredicate.isFqn("aws_cdk.aws_sqs.QueueEncryption.UNENCRYPTED"), UNENCRYPTED_MESSAGE, new IssueLocation[0]);
            flow.addIssueIf(CdkPredicate.isNone(), NONE_MESSAGE, new IssueLocation[0]);
        }, () -> ctx.addIssue(resourceConstructor.callee(), OMITTING_MESSAGE));
    }

    protected void checkCfnQueue(SubscriptionContext ctx, CallExpression resourceConstructor) {
        CdkUtils.getArgument(ctx, resourceConstructor, "kms_master_key_id").ifPresentOrElse(flow -> flow.addIssueIf(CdkPredicate.isNone(), CFN_NONE_MESSAGE, new IssueLocation[0]), () -> ctx.addIssue(resourceConstructor.callee(), CFN_OMITTING_MESSAGE));
    }
}

