/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sonar.plugins.python.api.tree.ClassPattern;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Pattern;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class ClassPatternImpl
extends PyTree
implements ClassPattern {
    private final Expression targetClass;
    private final Token leftPar;
    private final List<Pattern> arguments;
    private final List<Token> argumentSeparators;
    private final Token rightPar;

    public ClassPatternImpl(Expression targetClass, Token leftPar, List<Pattern> arguments, List<Token> argumentSeparators, Token rightPar) {
        this.targetClass = targetClass;
        this.leftPar = leftPar;
        this.arguments = arguments;
        this.argumentSeparators = argumentSeparators;
        this.rightPar = rightPar;
    }

    @Override
    public Expression targetClass() {
        return this.targetClass;
    }

    @Override
    public Token leftPar() {
        return this.leftPar;
    }

    @Override
    public List<Pattern> arguments() {
        return this.arguments;
    }

    @Override
    public List<Token> argumentSeparators() {
        return this.argumentSeparators;
    }

    @Override
    public Token rightPar() {
        return this.rightPar;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitClassPattern(this);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.CLASS_PATTERN;
    }

    @Override
    List<Tree> computeChildren() {
        ArrayList<Tree> children = new ArrayList<Tree>(Arrays.asList(this.targetClass, this.leftPar));
        int i = 0;
        for (Pattern element : this.arguments) {
            children.add(element);
            if (i < this.argumentSeparators.size()) {
                children.add(this.argumentSeparators.get(i));
            }
            ++i;
        }
        children.add(this.rightPar);
        return children;
    }
}

